// AList - Version 2.0
// Written by Gregory Gulick
// Copyright 1994 - All Rights Reserved

#include <pb_sdk.h>

#define CTRUE 0
#define CFALSE -1

#define SELECT_FILE_AREA		"\n\007Select file area or [\003Enter\007] for list (\003Q\007 to Quit) : "
#define CONTINUE_FILE_AREA		"\n\007Select file area or [\003Enter\007] for more (\003Q\007 to Quit) : "
#define END_FILE_AREA			"\n\007End of list.  Select file area or [\003Enter\007] to quit : "

#define SELECT_MESS_AREA        "\n\007Select message area or [\003Enter\007] for list (\003Q\007 to Quit) : "
#define CONTINUE_MESS_AREA      "\n\007Select message area or [\003Enter\007] for more (\003Q\007 to Quit) : "
#define END_MESS_AREA           "\n\007End of list.  Select message area or [\003Enter\007] to quit : "

#define CONTINUE_MESS_GROUP     "\n\007Select message group or [\003Enter\007] for more (\003Q\007 to Quit) : "
#define END_MESS_GROUP          "\n\007End of list.  Select message group or [\003Enter\007] to quit : "

#define CONTINUE_FILE_GROUP     "\n\007Select file group or [\003Enter\007] for more (\003Q\007 to Quit) : "
#define END_FILE_GROUP          "\n\007End of list.  Select file group or [\003Enter\007] to quit : "

// Prototypes

void main(int argc, char **argv);				// Read command line, etc.
void no_memory(void);							// No memory?  Abort program.
void press_enter(void);							// Press enter to continue.
void header(void);								// Prog name, author, etc.
int q_filearea(char querry[100]);				// Querry for file area
int q_messarea(char querry[100]);               // Querry for message area
int q_messgroup(char querry[100]);              // Querry for message group
int q_filegroup(char querry[100]);              // Querry for file group
void list_fileareas(void);						// List file areas.
void list_messareas(void);                      // List message areas.
bool valid_farea(int x, bool cd_stat,           // Is a valid file area?
                 byte group_members[4],
                 bool all_groups);
bool valid_marea(int x, byte area_stat,         // Is a valid mess area?
                 byte group_members[4],
                 bool all_groups);
void get_filearea(int r_area);					// Actual selection of area
void get_messarea(int r_area);                  // Actual selection of area
void invalid_area(void);						// Bad area selection
void invalid_group(void);                       // Bad group selection
void read_cmd_line(char command_line[100]);     // Read Command line
void display_fill_char(void);                   // Show defined fill character
void read_group_info(char filename[100]);       // Read message group info
void select_mess_group(void);                   // Select message group
void select_file_group(void);                   // Select file group

// Global Variables

	int ln;										// Current line number
	bool quick_prompt;							// Want quick prompt?
	char ch;									// Multipurpose character
	char argument[100][100];					// Command line paramater
	int total_arguments = 0;   					// Total arguments
    char fill_char;                             // Fill character
    bool no_fill_char = TRUE;                   // Use default fill char?
    int num_of_groups;                          // Number of mess/file groups

struct group_type {
    char name[80];
    unsigned int level;
    long flags;
    long flagsNot;
    byte extra[10];
} group[100];

/* -------------------------------------------------------------------------
                   -- Beginning of Standard PEX Routines --
   ------------------------------------------------------------------------- */

void no_memory(void)
{
	printf("\f");
	SetColor(RED);
	printf("Insufficient memory to run PowerPEX!\n");
	press_enter();
	exit();										// Abort program
}

void press_enter(void)
{
	SetColor(WHITE);
	printf("\nPress [");
	SetColor(YELLOW);
	printf("Enter");
	SetColor(WHITE);
	printf("] to Continue.");
	ch=WaitKeys("\r");
}

void header(void)
{
		printf("\f");
		SetColor(WHITE);
        printf("AList v2.0 ");
		SetColor(CYAN);
		printf(" ");
		SetColor(BLUE);
        printf("A PowerPEX by Gregory Gulick           ");
		SetColor(CYAN);
		printf("         (C) Copyright 1994\n");
		SetColor(MAGENTA);
		printf("\n\n");

		ln = 4;                                 // Start on line 4
}

void display_fill_char(void)
{
    if (no_fill_char == TRUE) {
        if (CurUser->uFlags & UFLAG_NOIBM)
            printf(".");
        else
            printf("");
    }
    else
        printf("%c",fill_char);
}

/* -------------------------------------------------------------------------
                     -- Beginning of File Area Listing --
   ------------------------------------------------------------------------- */

void invalid_area(void)
{
	SetColor(RED);
	printf("\n\nInvalid area.\n");
	press_enter();
	exit();
}

void get_filearea(int r_area)
{
	FILEAREA *fa, *fas;							// File pointers

	if ((fa = (FILEAREA *) calloc(1,800))==NULL) // Allocate memory.
		no_memory();                            // No memory?  Abort.

	fas = fa;									// *fas points to fa

	// Test if request file area exists

	if (ReadFileArea(r_area,fa) == CTRUE) {

		// Test if user has sufficient access to file area

		if (CheckAccess(fa->level,fa->flags) == FALSE) {
			free(fas);							// Free memory
			invalid_area();
		}

		// Set the user's file area

		CurUser->fileArea=r_area;
		free(fas);								// Free memory
		exit();
	} // End of test for valid file area

	// If an invalid area...

	else {
		free(fas);          					// Free memory
		invalid_area();
	}
	exit();
}

int q_filearea(char querry[100])
{
	char buf[10];								// Input buffer

	if (quick_prompt == TRUE) {					// If want a quick prompt
		printf("%s",querry);
		Input (buf,5,INPUT_UPALL);
		if (strstr(buf,"Q") != NULL)
			exit();
		else if (atoi(buf) == 0)
			return(0);
		else
			get_filearea(atoi(buf));
	}
	return(0);									// Simulate pressing enter
}

bool valid_farea(int x, bool cd_stat, byte group_members[4],
                 bool all_groups)
{
    int lp, loop;                               // Loop variables
    int file_group;                             // File group member
	int valid = FALSE;							// Value to return

	char *part1, *part2, *part1s, *part2s;		// Test pointers (s=start)
    char *fg, *fgs;                             // Group test pointers

	if ((part1 = (char *) calloc(1,20))==NULL)  // Allocate memory and test
		no_memory();							// No memory?  Exit.
	if ((part2 = (char *) calloc(1,20))==NULL)  // Allocate memory and test
		no_memory();							// No memory?  Exit.
    if ((fg = (char *) calloc(1,20))==NULL)     // Allocate memory and test
        no_memory();                            // No memory?  Exit.

	part1s = part1;								// *part1s points to *part1
	part2s = part2;								// *part2s points to *part2
    fgs = fg;                                   // *fgs points to *fg

	// Loop starts on 2 because of the F/M option on the command line.

	for (lp=1;lp<=total_arguments;++lp) {

		// Test for * which indicates printing all areas

		if (strcmp(argument[lp],"*") == 0)
			valid = TRUE;

        // Test for FILE GROUPs

        if (all_groups == TRUE)                 // Member of all groups?
            valid = TRUE;
        else if (strstr(argument[lp],"FG:") != NULL) {
            fg = strstr(argument[lp],"FG:");
            ++fg;++fg;++fg;
            file_group = atoi(fg);
            for (loop = 0; loop <= 3; ++loop) {
                if (group_members[loop] == file_group)
                    valid = TRUE;
            }
        }

		// Test for C which indicates to print CD-ROM areas

		if ((strcmp(argument[lp],"C") == 0) && (cd_stat == TRUE))
			valid = TRUE;

		// Test for -C which indicates to suppress all CD-ROM

		if ((strcmp(argument[lp],"-C") == 0) && (cd_stat == TRUE))
			valid = FALSE;

		// Add the argument.  If the argument and the current area equals
		// zero, then the number was negative indicating to suppress an
		// area from the display.

		if (atoi(argument[lp]) + x == 0)
			valid = FALSE;

		// If the current area (x) and the current argument are the same,
		// this indicates a desired area.

		if (x == atoi(argument[lp]))
			valid = TRUE;

		// Test for adding multiple areas.

		if (strstr(argument[lp],"+[") != NULL) {
			strcpy(part1,argument[lp]);
			++part1; ++part1;					// Skip the "+["
			part2 = strstr(part1,"..");
			++part2; ++part2;					// Skip the two periods
			if ((x >= atoi(part1)) && (x <= atoi(part2)))
				valid = TRUE;
		} // End of testing for adding multiple areas

		// Test for supressing multiple areas.

		if (strstr(argument[lp],"-[") != NULL) {
			strcpy(part1,argument[lp]);
			++part1; ++part1;					// Skip the "-["
			part2 = strstr(part1,"..");
			++part2; ++part2;                   // Skip the two periods
			if ((x >= atoi(part1)) && (x <= atoi(part2)))
				valid = FALSE;
		} // End of testing for suppressing multiple areas
	} // End of loop

	free(part1s);								// Free Memory
	free(part2s);                               // Free Memory
    free(fgs);                                  // Free Memory
	return(valid);								// Return TRUE or FALSE
} // End of function

void list_fileareas(void)
{
	// Variables and their purposes:
	// -----------------------------
	//
	// *fa - File area pointer.
	// *fas - File area pointer that points to the beginning of the file
	//		  area pointer.  Used to clear the memory.
	// x,y - Generic loop variables.

	FILEAREA *fa, *fas;
	int x,y;

	// The next few lines test for free memory.  If the memory allocation
	// fails, the program called no_memory() and exits the PEX.  Otherwise,
	// *fas is assigned the position of *fa.

	if ((fa = (FILEAREA *) calloc(1,800)) == NULL)
		no_memory();

	fas = fa;									// fas points to start of fa

	if (q_filearea(SELECT_FILE_AREA) == 0) {	// Start listing file areas
		quick_prompt = TRUE;					// Quick prompt from now on.
		header();								// Print program information
		for (x=1; x!=9999; ++x) {				// Loop to find areas
			if (ReadFileArea(x,fa) == CTRUE) {	// If area exists

				// This next line tests whether or not a found file area
				// should be shown to the user.  First it tests to see if
				// the user has access to the area, then it tests if the
				// file area found is one of the valid file areas from the
				// command line paramaters.

                if ((CheckAccess(fa->level,fa->flags) == TRUE) &&
                    (valid_farea(x,fa->cdrom,fa->groups,fa->allGroups)==TRUE)) {
					SetColor(CYAN);
					printf("[");
					SetColor(MAGENTA);
					printf("%4d",x);
					SetColor(CYAN);
					printf("] ");
					SetColor(WHITE);
					printf("%1.50s ",fa->name);

					// Test for area status : FREE, CD-ROM, HARD DRIVE

					if ((fa->cdrom == TRUE) && (fa->free == FALSE)) {
                        for (y=strlen(fa->name) + 8; y<=69; ++y)
                            display_fill_char();
						SetColor(CYAN);
						printf(" [CD-ROM]\n");
					} // End of test for CD-ROM area

					else if ((fa->cdrom == TRUE) && (fa->free == TRUE)) {
                        for (y=strlen(fa->name) + 8; y<=62; ++y)
                            display_fill_char();
						SetColor(BLUE);
						printf(" [FREE] ");
						SetColor(CYAN);
						printf("[CD-ROM]\n");
					} // End of test for FREE CD-ROM area

					else if ((fa->cdrom == FALSE) && (fa->free == TRUE)) {
                        for (y=strlen(fa->name) + 8; y<=58; ++y)
                            display_fill_char();
						SetColor(BLUE);
						printf(" [FREE] ");
						SetColor(CYAN);
						printf("[HARD DRIVE]\n");
					} // End of test for FREE HARD DRIVE area

					else {
                        for (y=strlen(fa->name) + 8; y<=65; ++y)
                            display_fill_char();
						SetColor(CYAN);
						printf(" [HARD DRIVE]\n");
					} // End of HARD DRIVE area

					// Test if screen is passed the user's screen length

					if (ln == CurUser->screenLength-2) {
						if (q_filearea(CONTINUE_FILE_AREA) == 0)
							header();
					} // End of test for screen position

					else // If not at screenlength,
						++ln; // Increment screen length
				} // End of valid area check
			} // End of test if file area exists
		} // End of 1 to 9999 loop
	} // End of listing file areas
	if (q_filearea(END_FILE_AREA) == 0)						// Final querry
		exit();
	free(fas);									// Free memory
} // End of function

void select_file_group(void)
{
    int loop;                                   // Loop variable

    printf("\006File Groups:\n\n");
    ln = ln + 2;

    for (loop = 1; loop <= num_of_groups; ++loop) {
        if ((CheckAccess(group[loop].level,group[loop].flags) == TRUE) && (group[loop].name[0] != '\x0')) {
            printf("\006[\004%2d\006] \007%1.60s\n",loop,group[loop].name);

            // Check if screenlength is okay.

            if (ln == CurUser->screenLength-2) {
                if (q_filegroup(CONTINUE_FILE_GROUP) == 0) // Continuing...
                    header();
                else                            // If user selected group...
                    return;                     // ... go to calling funct.
            }
            else
                ++ln;                           // Increment screen length.
        }
    }
    if (q_filegroup(END_FILE_GROUP) == 0)       // If we have show all groups
        exit();                                 // and press enter?  Quit.
}

int q_filegroup(char querry[100])
{

/*  * This function querrys the user for a file group.  If the user  selects a
    * file group, then the function returns 1 which tells the calling function
    * to cease displaying the message groups.  Furthermore, if a group is
    * selected, an extra argument is added as if it was placed on argv[2]
    * (command line) to list the desired file group.                        */

	char buf[10];								// Input buffer

    printf("%s",querry);
    Input (buf,2,INPUT_UPALL);
    if (strstr(buf,"Q") != NULL)
        exit();
    else if (atoi(buf) == 0)
        return(0);
    else {
        if (CheckAccess(group[atoi(buf)].level,group[atoi(buf)].flags) == TRUE) {
            CurUser->fileGroup = atoi(buf);          // Set user's filegroup
            ++total_arguments;                      // Add extra argument
            sprintf(argument[total_arguments],"FG:%d",atoi(buf));
            return(1);
        }
        else
            invalid_group();
    }
    return(0);
}

/* -------------------------------------------------------------------------
                   -- Beginning of Message Area Listing --
   ------------------------------------------------------------------------- */

void get_messarea(int r_area)
{
    MSGAREA *ma, *mas;                         // File pointers

    if ((ma = (MSGAREA *) calloc(1,1500))==NULL)// Allocate memory.
		no_memory();                            // No memory?  Abort.

    mas = ma;                                   // *mas points to ma

    // Test if requested message area exists

    if (ReadMsgArea(r_area,ma) == TRUE) {

        // Test if user has sufficient access for message area

        if ((CheckAccess(ma->writeLevel,ma->writeFlags) == FALSE) &&
            (CheckAccess(ma->readLevel,ma->readFlags) == FALSE)) {
            free(mas);                          // Free memory
			invalid_area();
		}

        CurUser->msgArea=r_area;                // Set the user's mess area
        free(mas);                              // Free memory
		exit();
    }
    else {                                      // If invalid area...
        free(mas);                              // Free memory
		invalid_area();
	}
	exit();
}

int q_messarea(char querry[100])
{
	char buf[10];								// Input buffer

	if (quick_prompt == TRUE) {					// If want a quick prompt
		printf("%s",querry);
		Input (buf,5,INPUT_UPALL);
		if (strstr(buf,"Q") != NULL)
			exit();
		else if (atoi(buf) == 0)
			return(0);
		else
            get_messarea(atoi(buf));            // See if a valid area
	}
	return(0);									// Simulate pressing enter
}

bool valid_marea(int x, byte area_stat, byte group_members[4],
                 bool all_groups)
{
    int lp, loop;                               // Loop variables
	int valid = FALSE;							// Value to return
    int mess_group;                             // Message group

    char *part1, *part2, *part1s, *part2s;      // Test pointers (s=start)
    char *mg, *mgs;                             // Message group pointers

	if ((part1 = (char *) calloc(1,20))==NULL)  // Allocate memory and test
		no_memory();							// No memory?  Exit.
	if ((part2 = (char *) calloc(1,20))==NULL)  // Allocate memory and test
		no_memory();							// No memory?  Exit.
    if ((mg = (char *) calloc(1,20))==NULL)     // Allocate memory and test
        no_memory();                            // No memory?  Exit.

	part1s = part1;								// *part1s points to *part1
	part2s = part2;								// *part2s points to *part2
    mgs = mg;                                   // *mgs points to *mg

	// Loop starts on 2 because of the F/M option on the command line.

	for (lp=1;lp<=total_arguments;++lp) {

		// Test for * which indicates printing all areas

		if (strcmp(argument[lp],"*") == 0)
			valid = TRUE;

        // Test for MESSAGE GROUP

        if (all_groups == TRUE)                 // Member of all groups?
            valid = TRUE;
        else if (strstr(argument[lp],"MG:") != NULL) {
            mg = strstr(argument[lp],"MG:");
            ++mg;++mg;++mg;
            mess_group = atoi(mg);
            for (loop = 0; loop <= 3; ++loop) {
                if (group_members[loop] == mess_group)
                    valid = TRUE;
            }
        }

        // Test for E which indicates to list all ECHOs

        if ((strcmp(argument[lp],"E") == 0) && (area_stat == 2))
			valid = TRUE;

        // Test for -E which indicates to suppress all ECHOs

        if ((strcmp(argument[lp],"-E") == 0) && (area_stat == 2))
			valid = FALSE;

        // Test for N which indicates to list all NETMAIL areas

        if ((strcmp(argument[lp],"N") == 0) && (area_stat == 1))
            valid = TRUE;

        // Test for -N which indicates to suppress all NETMAIL areas

        if ((strcmp(argument[lp],"-N") == 0) && (area_stat == 1))
            valid = FALSE;

        // Test for L which indicates to list all LOCAL areas

        if ((strcmp(argument[lp],"L") == 0) && (area_stat == 0))
			valid = TRUE;

        // Test for -L which indicates to suppress all LOCAL areas

        if ((strcmp(argument[lp],"-L") == 0) && (area_stat == 0))
			valid = FALSE;

        // Test for PE which indicates to list all PRIVATE ECHOs

        if ((strcmp(argument[lp],"PE") == 0) && (area_stat == 3))
			valid = TRUE;

        // Test for -PE which indicates to suppress all PRIVATE ECHOs

        if ((strcmp(argument[lp],"-PE") == 0) && (area_stat == 3))
			valid = FALSE;

		// Add the argument.  If the argument and the current area equals
		// zero, then the number was negative indicating to suppress an
		// area from the display.

		if (atoi(argument[lp]) + x == 0)
			valid = FALSE;

		// If the current area (x) and the current argument are the same,
		// this indicates a desired area.

		if (x == atoi(argument[lp]))
			valid = TRUE;

		// Test for adding multiple areas.

		if (strstr(argument[lp],"+[") != NULL) {
			strcpy(part1,argument[lp]);
			++part1; ++part1;					// Skip the "+["
			part2 = strstr(part1,"..");
			++part2; ++part2;					// Skip the two periods
			if ((x >= atoi(part1)) && (x <= atoi(part2)))
				valid = TRUE;
		} // End of testing for adding multiple areas

		// Test for supressing multiple areas.

		if (strstr(argument[lp],"-[") != NULL) {
			strcpy(part1,argument[lp]);
			++part1; ++part1;					// Skip the "-["
			part2 = strstr(part1,"..");
			++part2; ++part2;                   // Skip the two periods
			if ((x >= atoi(part1)) && (x <= atoi(part2)))
				valid = FALSE;
		} // End of testing for suppressing multiple areas
	} // End of loop

	free(part1s);								// Free Memory
    free(part2s);                               // Free Memory
    free(mgs);                                  // Free Memory
    return(valid);                              // Return TRUE or FALSE
} // End of function

void list_messareas(void)
{
	// Variables and their purposes:
	// -----------------------------
	//
    // *ma - Message area pointer.
    // *mas - Message area pointer that points to the beginning of the message
	//		  area pointer.  Used to clear the memory.
	// x,y - Generic loop variables.

    MSGAREA *ma, *mas;
	int x,y;

	// The next few lines test for free memory.  If the memory allocation
	// fails, the program called no_memory() and exits the PEX.  Otherwise,
	// *fas is assigned the position of *fa.

    if ((ma = (MSGAREA *) calloc(1,1000)) == NULL)
		no_memory();

    mas = ma;                                   // mas points to start of ma

    if (q_messarea(SELECT_MESS_AREA) == 0) {    // Start listing message areas
		quick_prompt = TRUE;					// Quick prompt from now on.
		header();								// Print program information
		for (x=1; x!=9999; ++x) {				// Loop to find areas
            if (ReadMsgArea(x,ma) == TRUE) {    // If area exists

                // This next line tests whether or not a found message area
				// should be shown to the user.  First it tests to see if
                // the user has read AND write access to the area, then it
                // tests if the message area found is one of the valid message
                // areas from the command line paramaters.

                if ( ((CheckAccess(ma->readLevel,ma->readFlags) == TRUE) ||
                   (CheckAccess(ma->writeLevel,ma->writeFlags) == TRUE)) &&
                   (valid_marea(x,ma->msgKind,ma->groups,ma->allGroups) == TRUE) ) {

                    printf("\006[\004%4d\006] \007%1.50s ",x,ma->name);

                    // Test for area status : LOCAL, NET, ECHO, etc...

                    if (ma->msgKind == 0) {
                        for (y=strlen(ma->name) + 8; y<=70; ++y)
                            display_fill_char();
						SetColor(CYAN);
                        printf(" [LOCAL]\n");
                    } // End of test for LOCAL area

                    else if (ma->msgKind == 1) {
                        for (y=strlen(ma->name) + 8; y<=68; ++y)
                            display_fill_char();
						SetColor(CYAN);
                        printf(" [NETMAIL]\n");
                    } // End of test for NETMAIL area

                    else if (ma->msgKind == 2) {
                        for (y=strlen(ma->name) + 8; y<=71; ++y)
                            display_fill_char();
						SetColor(CYAN);
                        printf(" [ECHO]\n");
                    } // End of test for ECHO area

					else {
                        for (y=strlen(ma->name) + 8; y<=63; ++y)
                            display_fill_char();
						SetColor(CYAN);
                        printf(" [PRIVATE ECHO]\n");
                    } // End of PRIVATE ECHO area

					// Test if screen is passed the user's screen length

					if (ln == CurUser->screenLength-2) {
                        if (q_messarea(CONTINUE_MESS_AREA) == 0)
							header();
					} // End of test for screen position

					else // If not at screenlength,
						++ln; // Increment screen length
				} // End of valid area check
			} // End of test if file area exists
        } // End of 1 to 9999 loop
    } // End of listing file areas
    if (q_messarea(END_MESS_AREA) == 0)         // Final querry
		exit();
    free(mas);                                  // Free memory
} // End of function

void select_mess_group(void)
{
    int loop;                                   // Loop variable

    printf("\006Message Groups:\n\n");
    ln = ln + 2;

    for (loop = 1; loop <= num_of_groups; ++loop) {
        if ((CheckAccess(group[loop].level,group[loop].flags) == TRUE) && (group[loop].name[0] != '\x0')) {
            printf("\006[\004%2d\006] \007%1.60s\n",loop,group[loop].name);

            // Check if screenlength is okay.

            if (ln == CurUser->screenLength-2) {
                if (q_messgroup(CONTINUE_MESS_GROUP) == 0) // Continuing...
                    header();
                else                            // If user selected group...
                    return;                     // ... go to calling funct.
            }
            else
                ++ln;                           // Increment screen length.
        }
    }
    if (q_messgroup(END_MESS_GROUP) == 0)       // If we have show all groups
        exit();                                 // and press enter?  Quit.
}

int q_messgroup(char querry[100])
{

/*  * This function querrys the user for a message group.  If the user
    * selects a message group, then the function returns 1 which tells
    * the calling function to cease displaying the message groups.
    * Furthermore, if a group is selected, an extra argument is added
    * as if it was placed on argv[2] (command line) to list the desired
    * message group.                                                       */

	char buf[10];								// Input buffer

    printf("%s",querry);
    Input (buf,2,INPUT_UPALL);
    if (strstr(buf,"Q") != NULL)
        exit();
    else if (atoi(buf) == 0)
        return(0);
    else {
        if (CheckAccess(group[atoi(buf)].level,group[atoi(buf)].flags) == TRUE) {
            CurUser->msgGroup = atoi(buf);          // Set user's filegroup
            ++total_arguments;                      // Add extra argument
            sprintf(argument[total_arguments],"MG:%d",atoi(buf));
            return(1);
        }
        else
            invalid_group();
    }
    return(0);
}

/* -------------------------------------------------------------------------
                       -- Beginning of Program Body --
   ------------------------------------------------------------------------- */

void invalid_group(void)
{
    printf("\n\n\001Access denied.\n");
	press_enter();
	exit();
}

void read_group_info(char filename[100])
{

    // This procedure reads both the filegroup and message group information
    // since the file structures are identical.

    FILE *fp;                                   // File pointer
    char group_filename[100];                   // Filename for group file

    num_of_groups = 0;                          // Reset number of groups

    header();                                   // Show program header

    sprintf(group_filename,"%s%s",SysPath,      // Build filename
            filename);

    if (access(group_filename,00) == CFALSE) {
        printf("\001%s \007does not exist.  Cannot do file/message grouping.\n",
                filename);
        press_enter();
        exit();
    }

    fp = fopen(group_filename,"rb");            // Open for binary read

    do {
        ++num_of_groups;
        fread(&group[num_of_groups], sizeof(struct group_type), 1, fp);
        if (feof(fp)) {
            --num_of_groups;
            break;
        }
    } while ((!feof(fp)) && (num_of_groups < 99));

    fclose(fp);                                 // Close group file

    if (num_of_groups < 1) {                    // Empty file?
        printf("\001No groups defined!\n");
        press_enter();
        exit();
    }
}

void read_cmd_line(char command_line[100])
{

	// This function parses the command line and places the results in the
	// variable "argument[]" starting at element 1.  This is used to get
	// around the 8 or 9 parameter limit on the command line.

	char *token;

	char tokensep[]=",";

	token = strtok(command_line,tokensep);

	// This procedure parses the command line, and places the upper case
	// equivalents into the array of argument[].

	while ((token != NULL) && (total_arguments <= 99)) {
		++total_arguments;
		strcpy(argument[total_arguments],strupr(token));
		token = strtok(NULL, tokensep);
	}
}

void main(int argc, char **argv)
{

    char *parse, *parses;                       // Parsing for fill char

    if ((parse = (char *) calloc(1,5)) == NULL)
        no_memory();

    parses = parse;                             // *parses points to parse

	if (argc < 1) {								// If insufficient arguments
		printf("\001\f\001Not enough command line arguments.\n");
		press_enter();
		exit();
    }

    if (strstr(argv[1],"/") != NULL) {
        parse = strstr(argv[1],"/");
        if (parse[1] == '\x0')
            fill_char = ' ';
        else
            fill_char = parse[1];
        no_fill_char = FALSE;
    }

    free(parses);                               // Free memory

	read_cmd_line(argv[2]);						// Read and parse cmd line

	if (strstr(strupr(argv[1]),"F") != NULL) {  // Want file area listing?
		if (strstr(argv[1],"N") != NULL)		// Suppress quick prompt?
			quick_prompt = FALSE;
		else                                    // Want quick prompt.
			quick_prompt = TRUE;

        if (strstr(strupr(argv[1]),"!") != NULL) {
            read_group_info("FGROUPS.PB");
            select_file_group();
            printf("\n");
        }
        else if ((strstr(strupr(argv[1]),"?") != NULL) &&
            (CurUser->fileGroup == 0)) {
                read_group_info("FGROUPS.PB");
                select_file_group();
                printf("\n");
        }
        else if ((strstr(strupr(argv[1]),"?") != NULL) &&
            (CurUser->fileGroup != 0)) {
            ++total_arguments;                  // Add extra argument
            sprintf(argument[total_arguments],"FG:%d",CurUser->fileGroup);
            printf("\n");
        }

		list_fileareas();
	}
	else if (strstr(strupr(argv[1]),"M") != NULL) {
		if (strstr(argv[1],"N") != NULL)		// Suppress quick prompt?
			quick_prompt = FALSE;
		else
			quick_prompt = TRUE;				// Want quick prompt.

        // Check if we are asking for forcing mess group selection.

        if (strstr(strupr(argv[1]),"!") != NULL) {
            read_group_info("MGROUPS.PB");
            select_mess_group();
            printf("\n");
        }
        else if ((strstr(strupr(argv[1]),"?") != NULL) &&
            (CurUser->msgGroup == 0)) {
                read_group_info("MGROUPS.PB");
                select_mess_group();
                printf("\n");
        }
        else if ((strstr(strupr(argv[1]),"?") != NULL) &&
            (CurUser->msgGroup != 0)) {
            ++total_arguments;                  // Add extra argument
            sprintf(argument[total_arguments],"MG:%d",CurUser->msgGroup);
            printf("\n");
        }

        list_messareas();                       // Begin listing mess areas
	}
	else {										// Invalid command line param
		SetColor(RED);
		printf("\nUnknown command line parameter in AList.\n");
		press_enter();
	}

	exit();										// Leave program
}
