# *Translator Definitions*

PEXNAME = TESTKEY.PEX
CFG = $(PEXNAME:.PEX=.CFG)
OBJ = $(PEXNAME:.PEX=.OBJ)
MAKEFILE = $(PEXNAME:.PEX=.MAK)

CC = bcc +$(PEXNAME:.PEX=.CFG)
TASM = tasm
TLIB = tlib
TLINK = tlink
LIBPATH = ..
INCLUDEPATH = ..

PB_MBH=$(LIBPATH)\pb_mbh.lib

LIBS = $(PB_MBH)
OBJS =  $(PB_MBH:lib=obj) $(OBJ)

# *Implicit Rules*

.c.obj:
  $(CC) -c {$< }

.cpp.obj:
  $(CC) -c {$< }

# *List Macros*

#               *Explicit Rules*
$(PEXNAME): $(CFG) $(OBJS)
   $(TLINK) /C/n/s/L$(LIBPATH) @&&|
$(OBJS)
$(PEXNAME)
                # no map file
$(LIBS)
|
  tdstrip -s $(PEXNAME)
  copy $(PEXNAME) $(PROBOARD)\PEX

# *Individual File Dependencies*
$(PEXNAME:.PEX=.OBJ): $(CFG) $(PEXNAME:.PEX=.CPP)

# *Compiler Configuration File*
$(CFG): $(MAKEFILE)
  copy &&|
-R
-ml!
-2
-w+
-v-
-y-
-G
-r-
-O-
-I$(INCLUDEPATH)
-L$(LIBPATH)
| $(CFG)

# Turbo Link  Version 5.1 Copyright (c) 1992 Borland International
# Syntax: TLINK objfiles, exefile, mapfile, libfiles, deffile
# @xxxx indicates use response file xxxx
# /m  Map file with publics         /x  No map file at all
# /i  Initialize all segments       /l  Include source line numbers
# /L  Specify library search paths  /s  Detailed map of segments
# /n  No default libraries          /d  Warn if duplicate symbols in libraries
# /c  Case significant in symbols   /3  Enable 32-bit processing
# /o  Overlay switch                /v  Full symbolic debug information
# /P[=NNNNN]  Pack code segments    /A=NNNN  Set NewExe segment alignment
# /ye Expanded memory swapping      /yx Extended memory swapping
# /e  Ignore Extended Dictionary
# /t  Create COM file (same as /Tdc)
# /C  Case sensitive exports and imports
# /Txx  Specify output file type
#           /Tdx  DOS image (default)
#           /Twx  Windows image
#                 (third letter can be c=COM, e=EXE, d=DLL)

# Borland C++  Version 3.1 Copyright (c) 1992 Borland International
# Syntax is: BCC [ options ] file[s]     * = default; -x- = turn switch x off
#   -1      80186/286 Instructions    -2      80286 Protected Mode Inst.
#   -Ax     Disable extensions        -B      Compile via assembly
#   -C      Allow nested comments     -Dxxx   Define macro
#   -Exxx   Alternate Assembler name  -G      Generate for speed
#   -Hxxx   Use pre-compiled headers  -Ixxx   Include files directory
#   -K      Default char is unsigned  -Lxxx   Libraries directory
#   -M      Generate link map         -N      Check stack overflow
#   -Ox     Optimizations             -P      Force C++ compile
#   -Qxxx   Memory usage control      -S      Produce assembly output
#   -Txxx   Set assembler option      -Uxxx   Undefine macro
#   -Vx     Virtual table control     -Wxxx   Create Windows application
#   -X      Suppress autodep. output  -Yx     Overlay control
#   -Z      Suppress register reloads -a      Generate word alignment
#   -b    * Treat enums as integers   -c      Compile only
#   -d      Merge duplicate strings   -exxx   Executable file name
#   -fxx    Floating point options    -gN     Stop after N warnings
#   -iN     Max. identifier length    -jN     Stop after N errors
#   -k      Standard stack frame      -lx     Set linker option
#   -mx     Set Memory Model          -nxxx   Output file directory
#   -oxxx   Object file name          -p      Pascal calls
#   -r    * Register variables        -u    * Underscores on externs
#   -v      Source level debugging    -wxxx   Warning control
#   -y      Produce line number info  -zxxx   Set segment names
