/* FUNCTION: GetKey()
 *
 * PURPOSE:
 *
 * Show the world how to handle cursor keys in ProBoard. This function
 * could be used for writing PEX's that use cursor control, e.g.
 * file taggers like EastTag and EFL.
 *
 * DISCLAIMER:
 *
 * This file is only to be used for entertaining purposes. Actually
 * using this piece of code in programs is totally your own responsability.
 *
 * OTHER STUFF WORTH READING:
 *
 * This source is hereby donated to the Public Domain.
 * It took me an evening of experimenting with Philippe's SDK for ProBoard
 * to make this work the way I want it to.
 *
 * If you use the source please be honest and mention it in your documentation.
 * When possible please send me the program you wrote with it or tell me
 * where to get in in the Netherlands.
 *
 * Hope this is of some use for at least one person besides me out there:)
 *
 * I hope more people start donating ProBoard related sources to the
 * Public Domain. Perhaps this could be some kind of start.
 *
 * Hugo Voerman
 * sysop Moir Brandts Honk BBS
 *
 * +31-70-3461215 (USR/DS)
 * +31-70-3457929 (ZyXEL 19k2)
 * +31-70-3452981 (LineLink 144e)
 *
 * FIDO: 2:281/522.7
 * THANet: 70:3170/100
*/

#include <pb_mbh.h>

// Global Flag indicating there is a local key available
bool g_fLocalKeyAvailable = FALSE;

// Global word (KEY) containing the value of the local key
KEY  g_wLocalKey;

KEY GetKey(void)
{
   byte l_bState;
   KEY key;

   for(key = 0, l_bState = 0; ; )
   {

      while(!key) {

         if((key = (KEY)PeekChar()) != 0) {
            printf("Remote ");
            break;
         }

         if(g_fLocalKeyAvailable) {
            g_fLocalKeyAvailable = FALSE;
            printf("Local ");
            return(g_wLocalKey);
         }
      }

      switch(l_bState) {
         case 0:
            if(key == KEY_ESC) {
               short l_sCountDown = 1000; // timout for single [esc] detection
                                          // tested on 12 mhz 0WS 80286

               char l_cNewKey; //the PeekChar() in proboard is real crap
                               // since it actually reads a key is not
                               // a peek function but more a kbhit and getch
                               // together. So this is our "keyboard buffer"

               for(;l_sCountDown && !(l_cNewKey = PeekChar()); l_sCountDown--);

               if(l_sCountDown) {
                  l_bState = 1;
                  key = (KEY)l_cNewKey;
               } else {
                  // return the "single" ESC key
                  return(key);
               }
            } else {
               return(key);
            }
            break;

         case 1: // ESC has been seen
            if(key == 0x005B) { // '['
               // on our way to cursor keys!!!
               l_bState = 2;
               key = 0;
               break;
            } else {
               return(key);
            }

         case 2:
            switch (key) {
               case 65:
                  return(KEY_UP);

               case 66:
                  return(KEY_DN);

               case 67:
                  return(KEY_RT);

               case 68:
                  return(KEY_LT);

               case 72:
                  return(KEY_HOME);

               case 75:
                  return(KEY_END);

               default:
                  return(key);
            }
      }
   }
}

//
// ... for testing the above code ...
//

int KeyHandler(KEY k)
{
   switch(k) {
      /* here the keys that you don't want proboard to handle
        must be summarized
      */
      case KEY_F1: // get rid of that screen molesting help "thing"
      case KEY_LT:
      case KEY_RT:
      case KEY_DN:
      case KEY_UP:
      case KEY_HOME:
      case KEY_END:
         g_fLocalKeyAvailable = TRUE;
         g_wLocalKey = k;
         return HANDLED;
   }
   return(NOT_HANDLED);
}

void main(void)
{
   KEY key;

   InstallHandler(HANDLER_SYSOPKEY, KeyHandler);

   for(;;) {
      if((key = GetKey()) == KEY_RET) {
         break;
      }

      switch(key) {
         case KEY_ESC:
            printf("Escape\n");
            break;
         case KEY_LT:
            printf("Left\n");
            break;
         case KEY_RT:
            printf("Right\n");
            break;
         case KEY_UP:
            printf("Up\n");
            break;
         case KEY_DN:
            printf("Down\n");
            break;
         case KEY_HOME:
            printf("Home\n");
            break;
         case KEY_END:
            printf("End\n");
            break;

         default:
            printf("key: %X (%u)\n", key, key);
      }
   }
}


