#ifndef __EXAMPLE_HPP_
#define __EXAMPLE_HPP_

/* This global string is here to demonstrate the free-ing of
	memory in an atexit function of memory allocated in the
	main()
*/

char *g_szString = NULL; // globally initialise this pointer to NULL

/* This is a base class, used for educational purposes.
	I use it to show you that pure virtual functions work
	with our MBH PB SDK.
*/
class _BASEUSER {
private:
	char *c_szUserName;
	char *c_szAlias;
	word	c_usLevel;
	dword c_ulTimesCalled;

protected:

	virtual void display(void) = 0;

public:

   _BASEUSER(void);  // the constructor
   ~_BASEUSER(void); // the descructor

	// for direct yet protected access to the username
	inline char *UserName(void) { return c_szUserName; }

	// for direct yet protected access to the users' alias
	inline char *Alias(void) { return c_szAlias; }

	// for direct yet protected access to the users' level
	inline word Level(void) { return c_usLevel; }

	// for direct yet protected access to the users' times called
	inline dword TimesCalled(void) { return c_ulTimesCalled; }
};

class _USER : public _BASEUSER {

private:

protected:

public:
   _USER(void);   // the constructor
   ~_USER(void);  // the destructor
	void display(void);
};


/* A global USER object is made below.
	This is not possible with the original pb_sdk.obj since all the
	proboard data has not been initialised at this moment.
	Please remind that the constructor of this object is executed
	BEFORE main()!
*/
_USER USER;

#endif // __EXAMPLE_HPP_
