//
//    Copyright (C) 1994 Moir Brandts Honk
//    Distributed under license by the Free Software Foundation, Inc.
//
// This file is part of MBH PEX development kit.
//
// MBH PEX LIB is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// MBH PEX LIB is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MBH PEX LIB; see the file COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//
// Report problems and direct all questions to:
//
// 
// Moir Brandts Honk     LINEA DATARUM & TABULA FIBULARUM      Moir Brandts Honk
// 
//
//     (sysop -[TJS]-)
//     The Netherlands
//
//     netmail:
//          Fido: 2:281/522.7
//          THANet Hub: 70:3170/100
//
//     phone:
//                 USR/DS: +31-70-3461215
//           ZyXEL 1496E+: +31-70-3457929
//          LineLink 144e: +31-70-3452981
//
//     Snail Mail:
//          P.O. Box 709
//          2501 CS  Den Haag
//          The Netherlands
//
#define _PB_MBH_H
#include <pb_mbh.h>

#include "example.hpp"

#define THE_MESSAGE "This is a PEX (Proboard " \
             "Extension) file built\r\n" \
             "with the MBH PEX development kit, " \
             "version 2.01\r\n"

PB_DOS_Message_Struct My_Message =
{
  sizeof(THE_MESSAGE) - 1,
  /* subtract one as the terminating NUL-byte is counted by sizeof()... */
  THE_MESSAGE
};

PB_DOS_Message_Struct *PB_DOS_Message = &My_Message;

/* constructor for the base user class. It dynamically allocates
	memory for storage of the users name and alias.
	If a strdup() fails it calles exit() that will call
	the destructor at the right time!
*/
_BASEUSER::_BASEUSER(void)
{
	printf("_BASEUSER class constructor - START\n");

	c_szUserName = NULL;
	c_szAlias	 = NULL;

	if((c_szUserName = strdup(CurUser->name)) == NULL) {
		printf("Not enough memory for storing user's name\n");
		exit(2);
	}

	if((c_szAlias = strdup(CurUser->alias)) == NULL) {
		printf("Not enough memory for storing user's alias\n");
		exit(3);
	}

	c_usLevel = CurUser->level;
   c_ulTimesCalled = CurUser->timesCalled;

   printf("  Username and alias have been dynamically inserted in class\n");
	printf("_BASEUSER class constructor - END\n");
	WaitKey();
}

/* The destructor of our base class free's all NON NULL!! pointers
	This desctructor is call through exit(). So if something went
	wrong in the constructor, this destructor will ONLY free
	the right strings
*/
_BASEUSER::~_BASEUSER(void)
{
	printf("_BASEUSER class destructor - START\n");

	if(c_szUserName) { free(c_szUserName); }
	if(c_szAlias)	  { free(c_szAlias)	 ; }

   printf("  All memory for username and user alias has been free()-d\n");
	printf("_BASEUSER class destructor - END\n");
	WaitKey();
}

/* The _USER class constructor. Since all the real work is already done
   in the _BASEUSER class' constructor this is here just to show you
   the calling sequence of constructors in real life!
*/
_USER::_USER(void)
{
   printf("_USER class constructor - START\n");

   printf("  Not much to do around here:)\n");

	printf("_USER class constructor - END\n");
	WaitKey();
}

/* The _USER class destructor. Since all the real work is already done
   in the _BASEUSER class' destructor this is here just to show you
   the calling sequence of destructors in real life!
*/
_USER::~_USER(void)
{
	printf("_USER class destructor - START\n");

   printf("  Not much to do around here:)\n");

	printf("_USER class destructor - END\n");
	WaitKey();
}

/* Now let's fill in the pure virtual function in our User class
	derived from _BASEUSER
	Without the existance of _fpure_error_ in our own library
	this would cause a linker error.
*/
void _USER::display(void)
{
   printf("_USER::display() - START\n");
   printf(g_szString,
			 UserName(),
			 Alias(),
			 Level(),
			 TimesCalled()
			);
   printf("_USER::display() - END\n");
	WaitKey();
}

/* The function below is registered in the main() as an atexit function.
   Our staartup code will make sure this one is executed just AFTER main()
   but right before the desctructors.
*/
void exitHandler(void)
{
   printf("exitHander() - START\n");
   printf("  The global string : %s",
			 g_szString
			);
	free(g_szString);
   printf("  The global string has been free()-d\n");
   printf("exitHander() - END\n");
   WaitKey();
}

/* Well, here it is. The long awaited main()
   As you will see when running this example PEX, a lot more than
   called in main() is executed.
*/
void main(int argc, char *argv[])
{
   printf("main() - START\n");

   if((g_szString = strdup("  User: %s (alias %s)\n  has level %u and called for %ld times\n")) == NULL) {
      printf("  Sorry bro, not enough mem for global string\n"
				 "\n"
				 "Press enter to exit the program\n");
		WaitKey();
		exit(1); // this will NOT execute our exit handler since it is
					// installed below! This way free()-ing a NULL pointer
					// is prevented.
	}

	atexit(exitHandler); // register our exit handler

   USER.display();

   /* print the argv list until a NULL argv[...] is found
      this loop would most vertainly cause a CRASH due to the
      non-ansi C++ compiant argv handling
      see: Ellis, M.A., Stroustrup, B., The Annotated C++ Reference Manual,
           ANSI Base Document,1992,Addison Wesley,ISBN 0-201-51459-1,pp.19
   */
   for (argc=0; *argv; ) {
      printf("  argv[%d] = <%s>\n", argc++, *argv++);
   }

   printf("main() - END\n");
   WaitKey();
}


