/***********************************************************************
*                                                                      *
*   Program  INTRUDER                                                  *
*   Author   Peter Bloemendaal                                         *
*            Brainbox systems +31-70-3523661                           *
*   eMail  : internet -> bloemendaal@rullf2.LeidenUniv.nl              *
*            fidonet  -> 2:281/908                                     *
*                                                                      *
*   Purpose  Place a message on the users screen (Proboard)            *
*                                                                      *
*----------------------------------------------------------------------*
*                                                                      *
*   This source is copyrighted and distributed under the GNU license   *
*                                                                      *
*   If you use parts of this source and distribute compiled versions   *
*   of it, you have to make your source available!!!                   *
*                                                                      *
*                                                                      *
*----------------------------------------------------------------------*
*  $Log: fulledit.cpv $
*/

#include "PB_MBH.H"
#include "edit.cpp"
#include "border.hpp"

#define VERSION "Intrude 0.1"


class IntEdit : public Edit
{
   public:

      IntEdit(int x1, int y1, int x2, int y2, unsigned char *s)
         : Edit(x1, y1, x2, y2, s){ ; } ;
      int processKey(unsigned int)  ;
} ;

IntEdit::processKey(unsigned int key)
{
   return key ;
}



// The editor part itself
void intruder(void)
{
   char *tekst ;

   IntEdit edit(10,5,70,15,(unsigned char*) "") ;

   if (edit.loadFile("INTRUDE.SEM") == 0)
   {
      if ( (tekst = (char*) malloc(strlen(edit.getText()) + 50)) == NULL)
         return ;

      Border  border(10, 5, 70, 15);
      border.setTopColor((C_RED << 4) | C_BROWN) ;
      border.setBotColor((C_RED << 4) | C_LIGHTRED) ;
      border.open() ;
      edit.setColor((C_RED << 4) | C_YELLOW) ;
      edit.setEditable(FALSE);
      edit.setInput(INPUT_KEYBOARD | INPUT_PEXUSER) ;
      strcpy(tekst,edit.getText() ) ;
      strcat(tekst,"\n\nPress <ESC> to continue") ;
      edit.setText(tekst) ;

      edit.change() ;

      unlink("INTRUDE.SEM") ;
      clrscr() ;
      printf("\nPress <ENTER>\n") ;
   }
}




void main(void)
{
   FILE *in ;

   if ( (in = fopen("INTRUDE.SEM","rt")) == NULL)
      return  ;
   fclose(in) ;

#ifdef _PB_SDK_H
   if ( (CurUser->uFlags & UFLAG_ANSI) ||
        (CurUser->uFlags & UFLAG_AVATAR) ||
        (CurUser->uFlags & UFLAG_AVTPLUS) )
#endif
      intruder() ;
#ifdef _PB_SDK_H
   else
   {
      CurUser->uFlags = CurUser->uFlags | UFLAG_ANSI ;
      intruder() ;
      CurUser->uFlags = CurUser->uFlags & ~UFLAG_ANSI ;
   }
#endif
}
