/***********************************************************************
*                                                                      *
*  Definition file for QUOTE.CPP                                       *
*                                                                      *
*  Purpose : Implementation of different colors for quote lines        *
*                                                                      *
*  Author  : Peter Bloemendaal                                         *
*            Brainbox systems +31-70-3523661                           *
*  eMail   : internet -> bloemendaal@rullf2.LeidenUniv.nl              *
*            fidonet  -> 2:281/908                                     *
*                                                                      *
*----------------------------------------------------------------------*
*                                                                      *
*                                                                      *
* $Log: quote.cpv $
// Revision 1.1  1994/08/27  11:21:57  BRAINBOX
// Initial revision
//
//                                                                *
*                                                                      *
************************************************************************
*/

#ifndef _QUOTE_CPP
#define _QUOTE_CPP


#include "ABBREV.CPP"
#include "QUOTE.HPP"

#define QUOTE_POS   10

void QuoteEdit::setQuoteColor(unsigned char col)
{
   quoteColor = col ;
}


unsigned char QuoteEdit::getQuoteColor(void)
{
   return quoteColor ;
}

void QuoteEdit::display(void)
{
   register int  i, j, k;
   char *st ;
   bool l_fQuote ;
   unsigned long quotePos ;

   l_fQuote = FALSE ;

   st = (char*) malloc(width+1) ;

   this->formatText() ;


   this->Output::outTextattr(color) ;

   for (i = 0 ; i < height ; i++)
      if (strcmp(curScreen[i],oldScreen[i]) != 0)
      {
         for (j = 0 ; j < width ; j++)
            if (curScreen[i][j] != oldScreen[i][j])
               break ;
         for (k = width ; k > 0 ; k--)
            if (curScreen[i][k] != oldScreen[i][k])
               break ;
         strncpy(st,curScreen[i]+j,k-j+1) ;
         st[k - j + 1] = '\0' ;

         this->Output::outGotoxy(x1 + j, y1 + i) ;
         // look if the line contains a quote
         quotePos = strchr(curScreen[i],'>') - curScreen[i] ;
         if (quotePos <= QUOTE_POS )
         {
            if (!l_fQuote)
               this->outTextattr(quoteColor) ;
            l_fQuote = TRUE ;
         }
         else
         {
            if (l_fQuote)
               this->outTextattr(color) ;
            l_fQuote = FALSE ;
         }

         this->Output::outPrintf(st) ;
      }
   // Place cursor
   this->redrawCursor() ;

   this->copyScreen() ;

   free(st) ;
}

void QuoteEdit::redraw(void)
{
   register int i ;
   bool l_fQuote ;
   unsigned long quotePos ;

   l_fQuote = FALSE ;

   this->drawborder() ;
   this->formatText() ;
   this->Output::outTextattr(color) ;

   for (i = 0 ; i < height ; i++)
   {
      this->Output::outGotoxy(x1,y1+i) ;

      // look if the line contains a quote
      quotePos = strchr(curScreen[i],'>') - curScreen[i] ;
      if (quotePos <= QUOTE_POS )
      {
         if (!l_fQuote)
            this->outTextattr(quoteColor) ;
         l_fQuote = TRUE ;
      }
      else
      {
         if (l_fQuote)
            this->outTextattr(color) ;
         l_fQuote = FALSE ;
      }

      this->Output::outPrintf(curScreen[i]) ;
   }
   // Place cursor
   this->redrawCursor() ;

   this->copyScreen() ;
}

#endif
