/*
 * This file is part of PB-Lib v2.0r1 (add-on)
 *
 * Copyright (c) 1996 by Branislav L. Slantchev
 * A Product of Silicon Creations, Inc.
 *
 * This source is distributed under the terms and conditions of the
 * GNU General Public License. A copy of the license is included with
 * this distrbiution (see the file 'Copying.Doc').
 *
 * Contact: 73023.262@compuserve.com
*/
#ifndef __EDITLINE_H
#define __EDITLINE_H

#include "pblib.h"
#include "class/dlist.h"
#include "class/tobjs.h"

class edit
{
public:
	enum num    { hex = 1, blank = 2, pos = 4 };
	enum date   { european = 1, american = 2, show = 4, strict = 8 };
	enum file   { path = 1, wildcards = 2, upper = 4 };
	enum combo  { dispose = 1, init = 2 };
    enum passwd { proboard = 1, secure = 2 };
};

// the palette layout for TEditLine is as follows:
//
//		palette[0]	- active foreground color
//		palette[1]	- not used
//		palette[2]	- active background color
//		palette[3]	- active background fill character
//		palette[4]	- active selection color
//		palette[5]	- not used
//		palette[6]	- inactive foreground color
//		palette[7]	- not used
//		palette[8]	- inactive background color
//		palette[9]	- inactive background fill character


////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
class TEditLine
{
public:
	TEditLine(const CRect &bounds, short maxLen);
    ~TEditLine();

    virtual void    draw();
    virtual void    drawView();
    virtual void    handle(ushort aKeyCode);
    virtual void    setPalette(const char *aPalette);
    virtual void    setState(Boolean enable);
    virtual Boolean getState();
    virtual void    setData(void *ptr);
    virtual void    getData(void *ptr);
    virtual char    filterOnDraw(char aChar);

	static char leftArrow;		// these are the scroll indicators
    static char rightArrow;		// can be changed by the caller program

protected:
	uchar   getPalette(short pos);	// retrieve palette color or character
    Boolean canScroll(Boolean left);
    void    deleteSelect();
    void    selectAll();
    void    rightWord();
    void    leftWord();
    void    zapWord();

    char     palette[10];	// palette
    Boolean  mustPatch;	// patch the output handle() to make char visible
    Boolean  focused;	// is the view focused (used by draw() for colors)
    Boolean  insertMode;// insert mode flag
	char    *data;		// pointer to the string being edited
    short    firstPos;	// first position to display
    short    curPos;	// index of the current cursor position
    short    startSel;	// index of the selection start character
    short    endSel;	// index of the selection end character
    short    maxLen;	// maximum allowable length of the string
    CPoint   origin;	// the origin of the input line
    CPoint   size;		// the size (horizontal and vertical)
};

////////////////////////////////////////////////////////////////////////////
// Class to input numbers
////////////////////////////////////////////////////////////////////////////
class TEditNumber: public TEditLine
{
public:
	TEditNumber(const CRect &bounds, short aMaxLen, short aOptions);

    virtual void getData(void *ptr);
    virtual void setData(void *ptr);
    virtual void handle(ushort aKeyCode);

protected:
	short options;
};

////////////////////////////////////////////////////////////////////////////
// Class to input dates
////////////////////////////////////////////////////////////////////////////
class TEditDate: public TEditNumber
{
public:
	TEditDate(const CRect &bounds, short aOptions);

    virtual void getData(void *ptr);
    virtual void setData(void *ptr);
    virtual void handle(ushort aKeyCode);
    virtual Boolean valid(ushort aKeyCode);

protected:
    static const char *euro;
    static const char *amer;
    static const char *none;
	short options;
};

////////////////////////////////////////////////////////////////////////////
// Class to input file names and paths
////////////////////////////////////////////////////////////////////////////
class TEditFile: public TEditLine
{
public:
	TEditFile(const CRect &bounds, short aMaxLen, short aOptions);
    virtual void handle(ushort aKeyCode);

protected:
	short options;
};

////////////////////////////////////////////////////////////////////////////
// Class for combo box input line with speed searches and toggles
////////////////////////////////////////////////////////////////////////////
class TEditCombo: public TEditLine
{
public:
	TEditCombo(const CRect &bounds, short Options, TDoubleList *items);
    ~TEditCombo();

    virtual void handle(ushort aKeyCode);
    virtual void getData(void *ptr);
    virtual void setData(void *ptr);

protected:
	void incrementalSearch(ushort aKeyCode);

    short        nCompare;
	short        options;
	TDoubleList *list;
    TListCursor  iter;
};

////////////////////////////////////////////////////////////////////////////
// Class for accepting passwords as input
////////////////////////////////////////////////////////////////////////////
class TEditPassword: public TEditLine
{
public:
	TEditPassword(const CRect &bounds, short aMaxLen, short Options);
    virtual char setPwdChar(char aChar);

protected:
	char  filterOnDraw(char aChar);
    static const char m_Chars[];

    char  pwdChar;
    short options;
};

#endif
