/*
 * This file is part of hKeys (requires PB-Lib v3.0 or later)
 *
 * Copyright (c) 1995, 1996 Branislav L. Slantchev
 * A Product of Silicon Creations, Inc.
 *
 * This source is distributed under the terms and conditions of the
 * GNU General Public License. A copy of the license is included with
 * this distrbiution (see the file 'Copying.Doc').
 *
 * Contact: 73023.262@compuserve.com, sci@webstar.net, 1:383/47@fidonet
*/
#include "pblsdk.h"
#include "pblfile.h"
#include "pblport.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#define PROGRAM_VERSION "v1.0"

void
print_program_banner()
{
	printf("hKeys %s - Create ProBoard menu items with special hotkeys\n"
		   "    Compiled on %s at %s\n"
		   "    Copyright (c) by Branislav L. Slantchev /gargoyle\n"
		   "    A product of Silicon Creations, Inc.\n\n",
		PROGRAM_VERSION, __DATE__, __TIME__);
}

void
print_program_help()
{
	puts("Usage: hkeys <menu file(s)> -[return|escape]\n");
	puts("    menu file: the name of the menu file(s) you want to process");
	puts("    -return  : add an entry with 'enter' as the hotkey");
	puts("    -escape  : add an entry with 'escape' as the hotkey\n");
	puts("You can abbreviate -return to -r and -escape to -e");
	puts("Wildcards can be used for the menu file specification");
	puts("If you don't specify -return or -escape, none will be created");
	puts("You can specify both -return and -escape in one command\n");
	puts("Examples:");
	puts("    hkeys global -escape   <- add escape item to the GLOBAL menu");
	puts("    hkeys * -return        <- add return item to all menus");
	puts("    hkeys top -r -e        <- add return and escape items to TOP\n");
}

int
make_spec(char *szMenuSpec, char *szWildcard)
{
	char    szFilePath[MAXPATH];
	CONFIG  ConfigRec;
	FILE   *fp;

	sprintf(szFilePath, "%s\\config.pro", getenv("PROBOARD"));
	if( 0 == (fp = fopen(szFilePath, "rb")) ) return 0;
	file_read(fp, &ConfigRec);
	fclose(fp);
	sprintf(szFilePath, "%s%s", ConfigRec.mnupath, file_name(szWildcard));
	file_chext(szMenuSpec, szFilePath, ".pbm");
	return 1;
}

void
create_hotkeys(char *pathSpec, Boolean bCreateEscape, Boolean bCreateReturn)
{
	zDosFile   ffblk;
	int        done;
	char       szBasePath[MAXPATH], szFileName[MAXPATH];
	FILE      *fp;
	MENU_ITEM  EscapeRec, ReturnRec;

	memset(&EscapeRec, 0, sizeof(EscapeRec));
	memset(&ReturnRec, 0, sizeof(ReturnRec));

	strcpy(EscapeRec.text, "(escape) key item [generated by hKeys]");
	strcpy(ReturnRec.text, "(return) key item [generated by hKeys]");
	EscapeRec.color = ReturnRec.color = 15;
	EscapeRec.hotkey = 033;
	ReturnRec.hotkey = 015;
	memset(&EscapeRec.timeFrame, 0xff, sizeof(TimeFrame));
	memset(&ReturnRec.timeFrame, 0xff, sizeof(TimeFrame));

	strcpy(szBasePath, file_dirspec(pathSpec));
	done = FindFirst(pathSpec, 0, &ffblk);
	while( !done ){
		printf("Processing %s ", ffblk.name);
		if( bCreateEscape ) printf("(escape) ");
		if( bCreateReturn ) printf("(return) ");
		printf("... ");

		sprintf(szFileName, "%s%s", szBasePath, ffblk.name);
		if( 0 == (fp = fopen(szFileName, "r+b")) ){
			printf("file not found: '%s'\n", szFileName);
		}
		else{
			fseek(fp, 0L, SEEK_END);
			if( bCreateEscape ) file_write(fp, &EscapeRec);
			if( bCreateReturn ) file_write(fp, &ReturnRec);
			printf("updated\n");
			fclose(fp);
		}

		done = FindNext(&ffblk);
	}
}

int
main(int argc, char *argv[])
{
	char    pathSpec[MAXPATH];
	Boolean bCreateReturn = False;
	Boolean bCreateEscape = False;

	print_program_banner();
	if( 2 > argc ){
		print_program_help();
		return 1;
	}
	if( !make_spec(pathSpec, argv[1]) ){
		puts("hkeys: unable to construct menu specification (aborting)");
		return 1;
	}
	for( int i = 2; i < argc; ++i ){
		switch( argv[i][1] ){
			case 'e': case 'E': bCreateEscape = True; break;
			case 'r': case 'R': bCreateReturn = True; break;
			default :
				printf("hkeys: unknown option: '%s'\n", argv[i]);
				return 1;
		}
	}
	if( !bCreateEscape && !bCreateReturn ){
		print_program_help();
		puts("hkeys: nothing to do!");
		return 1;
	}
	create_hotkeys(pathSpec, bCreateEscape, bCreateReturn);
	return 0;
}
