
MKCOL							User's Manual						MKCOL
						Last revision date: May 09, 1995


NAME
	MKCOL - create color definitions for the 'Physical Graffiti' wall.

SYNOPSIS
	mkcol

VERSION
	MKCOL version 1.0

DESCRIPTION
	MKCOL creates color definitions for the GRAFFITI executables (both
	ProBoard and Standard EXE). It will let you create your own custom
	definitions to replace the defaults supplied with the package. When
	you're done editing, it will create a file called COLORS.DEF in the
	current directory. You need to rename this file to GRAFFITI.DEF and
	place it in the same directory with the GRAFFITI executable for it
	to be recognized and used by the package.

USAGE
	Here's what the prompts mean and what they expect:

	Colors in this entry (min-max):

		Enter the number of colors to use for this definition. This
		is the number of color values that you will be expected to
		enter later. If the value you enter is less than min, min
		will be forced. If it is greater than max, max will be forced.
		A value of 1 here will create a template with only one color.
		This is the most efficient definition for displaying, but it
		is also very boring.

	Restart indexing on words? (y/n)

		If you want to start from the beginning of the color table for
		each word, then say 'Yes'. Otherwise, 'No'. Restarting at the
		beginning of each word will let you create patterns that do not
		span across multiple words. If you don't restart, the palette
		will simply cycle through the color table. Note that all word
		separators are printed in the last color used.

	Do you need help with color values? (y/n)

		'Yes' will display a table of color values and some brief
		instructions on how to use them. You should read this at least
		once. I always display it before entering the colors since I
		don't really want to remember numbers for the additions.

	Enter 1 value
	Enter num values, comma-separated

		Depending on the number you gave for the first question, you
		will be expected to enter a list of certain color vaules. The
		color values should be separated by a comma (and, optinally,
		whitespace), if there's more than one entry. Color values are
		obtained by adding the foreground and background numbers. You
		can get a quick reference by answering 'Do you need help...'
		with 'Yes'. This will keep the values on screen: handy.

	Save this entry? (y/n)

		Well, 'Yes' saves this entry to the color definition file. A
		brief summary for the entry will be displayed before that
		prompt so that you can verify that the correct information
		will be saved. 'No' will... not save it. ;-)

	Enter another color definition? (y/n)

		'Yes', you will be able to define another color template.
		'No' ends the program.

	Do you want to test the colors? (y/n)

		'Yes' will display a test string using all current color
		definitions. Do this once in a while to make sure all is Ok.
		'No' will skip the test.

FILES
	MKCOL.EXE		the executable
	COLORS.DEF		created by the program

ERRORS
	All errors are of the form mkcol.exe: message.

	mkcol.exe: couldn't create color definition file.

		Self-explanatory. You ran out of disk space or you have a
		read-only COLORS.DEF in the current directory.

	mkcol.exe: error writing color definition.

		A disk error occurred trying to save data entry. Disk full?

	mkcol.exe: cannot save more colors. This was last.

		The entry just saved was the last one. The color definition
		file is currently limited to 18 entries (only those will be
		recognized by GRAFFITI). The program will end.

	mkcol.exe: parse error: no tokens

		You didn't enter any recognizable color values. Try again.

	mkcol.exe: parse error at token 'num'

		A parser error occurred. You have to separate color values
		with commas (and optional whitespace). If there weren't enough
		token supplied, this error will be generated. 'num' is the
		token number where the parsing failed.

IDENTIFICATION
	Author: Branislav L. Slantchev
	Revision Number: 1.0
	Release Date: May 09, 1995
	Copyright (C) 1995 by Branislav L. Slantchev

LIMITS
	Very crude interface and take-no-prisoners approach. This utility
	was developed for home use and was included in the package only as
	an afterthought. Sorry for that. Crude but usable. ;-)

BUGS
	Don't try pressing Control+Break or Control+C, this will probably
	crash your computer. This has something to do with the way getch()
	handles input. Just fail the color values or say 'No' when prompted
	whether you want to enter another color definition if you want to
	quit early.

	The test does not show strings quite like Physical Graffiti. The
	only word separators are the whitespace characters, whereas GRAFFITI
	recognizes punctuation and non-alphanumerics too. This is not a real
	bug, it shouldn't matter at all.

LEGALITIES
	MKCOL is Copyright 1995 by Branislav L. Slantchev.
	GRAFFITI is Copyright 1995 by Branislav L. Slantchev.

	MKCOL should be direstributed with the GRAFFITI package.

	Compiled with Borland's C++ 3.1 and compressed with PKWare's PKLITE.

	MKCOL (all executables, source and documentation files) are
	copyrighted material of Branislav L. Slantchev.

	This program is free software. You can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation, version 2. This
	software is released under the terms of that license. Please
	read the included file COPYING for the full text.

	You should have received a copy of the GNU General Public License
	along with this program (file COPYING). If not, write to the Free
	Software Foundation, Inc., 675 Mass Ave, Campbridge, MA 02139, USA.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	Branislav L. Slantchev will not be liable for any special, incidental,
	consequential, indirect or similar damages due to loss of data or
	any other reason.

	If you find this program useful, drop me a post card at the mail
	address (see file SUPPORT). I will really appreciate that.

SEE ALSO
	README				for quick installation instructions
	GRAFFITI.MAN		for Physical Graffiti User's Manual
