/*
 FileNav, File Library Navigator
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of FileNav.

 FileNav is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 FileNav is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with FileNav; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined( __USERD_H )
	#include "userd.h"
#endif

static char _userd_path[MAXPATH] = "\0";

/*
 * Creates a USERDOES-compatible drop file.
 * On success, returns 0, otherwise: -1
*/
	int
userd_creat( const char *fmt, ... )
{
	va_list arg;
	int uHnd;
	char buf[BUFSIZ];

#if defined( PB_SDK )
	sprintf( _userd_path, "%s/USERDOES.%d", SysPath, NodeNumber );
#else
	char *p = getenv( "PROBOARD" );
	if( !p ) strcpy( _userd_path, "USERDOES.1" );
	else strcat( strcpy(_userd_path,p), "/USERDOES.1" );
#endif

	va_start( arg, fmt );
	vsprintf( buf, fmt, arg );
	va_end( arg );

	/* line should not be longer than 22 characters */
	buf[USERDOES_LEN] = '\0';

	if( -1 == (uHnd = creat( _userd_path, S_IWRITE )) ){
		_userd_path[0] = '\0';
		return -1;
	}

	if( -1 == write( uHnd, buf, USERDOES_LEN ) ){
		_userd_path[0] = '\0';
		close( uHnd );
		return -1;
	}

	close( uHnd );
	return 0;
}

/*
 * Removes the dropfile created by userd_creat
*/
	int
userd_unlink( void )
{
	if( '\0' == _userd_path[0] ) return 0;
	return unlink( _userd_path );
}