/*
 FileNav, File Library Navigator
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of FileNav.

 FileNav is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 FileNav is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with FileNav; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#pragma warn -ofp

#if !defined( __TIMER_H )
	#include "timer.h"
#endif

static dword _timerStart;
static dword _timerStop;
bool  _timerIdle;

#define __TIMER *(dword far *)0x46c

/*
 * Starts the timer.
*/
	void
timer_start( void )
{
	_timerIdle = FALSE;
	_timerStart = __TIMER;
}

/*
 * Stops the timer.
*/
	void
timer_stop( void )
{
	_timerIdle = TRUE;
	_timerStop = __TIMER;
}

/*
 * Returns elapsed ticks (does not stop the timer)
*/
	dword
timer_diff( void )
{
	if( FALSE == _timerIdle )
		_timerStop = __TIMER;

	return _timerStop - _timerStart;
}

/*
 * Suspends program execution for wait number of ticks
*/
	void
timer_sleep( wait )
	dword wait;
{
	timer_start();

	while( wait > timer_diff() )
		;
}
