/*
 fls MS-DOS Standard Executable
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of the fls.

 fls is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 fls is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with fls; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "listarea.h"

#if !defined( __FAIL_H )
	#include "fail.h"
#endif

#if !defined( __CTYPE_H )
	#include <ctype.h>
#endif

#if !defined( __TIME_H )
	#include <time.h>
#endif

#if !defined( __STRING_H )
	#include <string.h>
#endif

#if !defined( __STAT_H )
	#include <sys/stat.h>
#endif

#if !defined( __DIR_H )
	#include <dir.h>
#endif

#define SECS_DAY  20864

	int
listarea( int num, const FILEAREA *fa, FILE *fp_list )
{
	FILE  *fp_fbbs;
	char   buf1[255], buf2[255], timebuf[9], *ptr, *descr;
	char   fname[15], date[9];
	long   size, bytes_area = 0L;
	struct stat statbuf;
	time_t today_time;
	int    in_listing = 0;

	/* open the listing file */
	if( !(fp_fbbs = fopen( fa->listpath, "r" )) )
		fail( "%s: couldn't access listfile for area '%d'",	progname, num );

	area_kbytes = 0;
	area_files  = 0;

	today_time = time(NULL);

	for( ;; ){
		if( NULL == fgets( buf1, BUFSIZ, fp_fbbs ) ) break;

		/* skip empty lines */
		for( ptr = buf1; isspace(*ptr); ptr++ )
			;
		if( '\0' == *ptr ) continue;

		/* see other restrictions */
		if( exclude_lines && strchr( "!;", buf1[0] ) ) continue;

		/* description line, see if we want single line description */
		if( strchr( " \t!;+", buf1[0] ) ){
			if( !single_line && in_listing ){
				for( ptr = &buf1[1]; isspace(*ptr); ++ptr )
					;
				if( '\0' == ptr ) continue;
				sprintf( buf2, "                               %s", ptr );
				fputs( buf2, fp_list );
				if( '\n' != buf2[strlen(buf2) - 1] )
					fputc( '\n', fp_list );
			}
			continue;
		}

		/* cdrom areas are copied verbatim, date and size are here */
		/* no check for days_old is done on cdrom areas            */
		if( fa->cdrom ){
			sscanf( buf1, "%s %ld %s %*s %[\x20-\xff]", fname, &size, date, buf2 );
			sprintf( buf1, "%-12s %8ld %s %s", fname, size, date, buf2 );
			bytes_area += size;
			strcpy( buf2, buf1 );
		}
		/* normal area, must get file size and date */
		else{
			if( !(ptr = strtok( buf1, " \t" )) ) continue;

			/* get description, skipping file counters */
			if( !(descr = strtok( NULL, "]" )) )
				descr = "description missing";
			else descr = strtok( NULL, "\0" );

			while( isspace(*++descr) ) ;

			strcpy( buf2, fa->filepath );
			if( '\\' != buf2[strlen(buf2) - 1] ) strcat( buf2, "\\" );
			strcat( buf2, ptr );
			if( -1 == stat( buf2, &statbuf ) ) continue;

			/* see if file is newer */
			if( days_old && (days_old < (difftime(today_time, statbuf.st_ctime) / SECS_DAY )) )
				continue;

			strftime( timebuf, 9, "%m/%d/%y", localtime(&statbuf.st_ctime) );
			sprintf( buf2, "%-12s %8ld %s %s", ptr, statbuf.st_size,
				timebuf, descr  );
			bytes_area += statbuf.st_size;
		}

		fputs( buf2, fp_list );
		if( '\n' != buf2[strlen(buf2) - 1] )
			fputc( '\n', fp_list );
		in_listing = 1;
		area_files++;
	}

	fclose( fp_fbbs );
	area_kbytes = (unsigned int)(bytes_area / 1024);
	return area_files;
}
