/*
 fls MS-DOS Standard Executable
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of the fls.

 fls is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 fls is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with fls; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *************************************************************************
 NOTE:
	 This file has been modified by Branislav L. Slantchev. The original
	 version is included in the file ORIGINAL.ZIP.
 *************************************************************************
*/

extern char *optarg;
extern int optind;
extern int opterr;

/* Describe the long-named options requested by the application.
   _GETOPT_LONG_OPTIONS is a vector of `struct option' terminated by an
   element containing a name which is zero.

   The field `has_arg' is:
   0 if the option does not take an argument,
   1 if the option requires an argument,
   2 if the option takes an optional argument.

   If the field `flag' is nonzero, it points to a variable that is set
   to the value given in the field `val' when the option is found, but
   left unchanged if the option is not found.

   To have a long-named option do something other than set an `int' to
   a compiled-in constant, such as set a value from `optarg', set the
   option's `flag' field to zero and its `val' field to a nonzero
   value (the equivalent single-letter option character, if there is
   one).  For long options that have a zero `flag' field, `getopt'
   returns the contents of the `val' field.  */

struct option
{
  char *name;
  int has_arg;
  int *flag;
  int val;
};

extern const struct option *_getopt_long_options;
extern int _getopt_long_only;
extern int option_index;

int getopt (int argc, char **argv, const char *shortopts);
int getopt_long (int argc, char **argv, const char *shortopts,
		 const struct option *longopts, int *longind);
int getopt_long_only (int argc, char **argv, const char *shortopts,
		      const struct option *longopts, int *longind);
void envopt(int *pargc, char ***pargv, char *optstr);
