
FLS								User's Manual						FLS
						Last revision date: May 19, 1995


NAME
	fls - creates a listing of file areas for ProBoard

SYNOPSIS
	fls -f listpath [-xesvch] [-g num,num... or [min-max] ]
		[-r header]	[-o footer] [-t areahead] [-p areafoot]
		[-m min] [-M max] [-n days]

VERSION
	fls version 1.0.1

DESCRIPTION
	fls will process the ProBoard file configuration database and will
	list all files in all areas it finds. Several options are available
	to customize its behavior and output. The PROBOARD environment must
	be set or fls will not be able to locate the data file. Refer to
	your ProBoard User's Guide for more information.

	The FA_???.CTL mechanism of specifying multiple directories per file
	area is fully supported.

	CD-ROM areas are processed from the listings only, all the information
	is extracted from them. If you have the listings on your hard drive,
	the CD-ROM will not be accessed at all. This means that the shared
	directories won't be checked (as they should be flagged as CD-ROM).

OPTIONS
	Running fls without any options displays a brief overview.

	Options are separated by space, order doesn't matter. You can use
	either the long or short version.

	+listing=listpath
	-f	'listpath' is the file where you want your output to be stored.
		This option must be given or fls will refuse to run. If you want
		to force an onscreen display (with possible redirection), you can
		specify -f con as the file.

	+group=num,num
	+group=[min-max]
	-g  group number(s) or [range]. List of groups whose areas you want to
		include in the listing. There are two ways of specifying those:
		comma-separated (and no spaces!), like this: 1,23,25,34,37,100
		or as a range, like this: [23-67]. Only areas that belong to those
		groups (or all groups) will be included.

	+min=level
	-m	'level' is the minimum security level for an area to be included
		in the list, this number inclusive.

	+max=level
	-M	'level' is the maximum security level for an area to be included
		in the list, this number inclusive.

	+days=num
	-n	'days'. Include files that are newer than 'days' only.

	+header=file
	-r	'file' is the general header which will be included at the start
		of the listing. Several key characters are available. See
		METACHARACTERS.

	+footer=file
	-o	'file' is the general footer file which will be appended at the
		end of the listing. See METACHARACTERS for available keys.

	+template=file
	-t	'file' is the header that will be included at the start of each
		file area. See METACHARACTERS.

	+post=file
	-p	'file' is the footer that will be included at the end of each
		file area. See METACHARACTERS.

	+exclude
	-x	exclude lines that begin with '!' and ';' in the file listings.

	+nocdrom
	-e	exclude cdrom areas. Very useful for newfiles listings.

	+single
	-s	single line descriptions. This is very good and makes the listings
		a lot more readable.

	+version
	-v	display program version and compilation date.

	+copying
	-c	display program copyright information.

	+help
	-h	display brief help screen and option summary.

EXAMPLES
	Execute the example BUILD.BAT for a sample run.

FILES
	fls.exe
	header/footers (optional)

METACHARACTERS
	Several metacharacters are available which you can place in your
	header and footer files. Note: '^' means the [Ctrl] key, so ^A
	will read Control+A (which is the same as ASCII 0x01).

	^A     : current time ( hh:mm:ss )
	^B     : current date ( dd:mm:yy )
	^C     : Kbytes in this area (1) (8 characters)
	^D	   : number of files in this area (1) (8 characters)
	^E	   : current file area name (2) (40 characters)
	^F     : current file area number (2) (7 characters)
	^K	   : total number of files (3) (8 characters)
	^N	   : total KBytes (3) (8 characters)
	^O	   : total areas (3) (7 characters)
	^P	   : days old (with the -n switch) (6 characters)

	Note: 	metacharacters that are marked with (1) can be only used in
			area footer files, those which are marked with (2) can only
			be used in area header/footer files. The ones marked with
			(3) can only be used in the general footer file. All others
			can used in all header/footer files. If you use any of the
			characters where you're not supposed to, erroneous results
			will probably plague you. If you don't specify the -d switch,
			then the ^P will display 0.

ERRORS
	All errors are of the form fls: message.

	fls: syntax error: wrong [] range.
		Your -g switch syntax is bad, check for whitespace. This will be
		acceptable: -g[1-23] or -g [1-23]. Anythig else won't.

	fls: syntax error: unbalanced [].
		Again, you messed up the -g switch. See the example above.

	fls: unrecognized option 's'.
		Well, obvious. Sometimes, you might get a misleading 's', so
		check your command-line carefully.

	fls: environment variable PROBOARD is not set.
		Refer to your ProBoard User's Manual. This should point to your
		system directory (no trailing backslash!)

	fls: could not read from 'file'
		Your ProBoard filebase is probably inaccessible. Check the path
		that the program displays and make sure it's looking in the
		right place.

	fls: you must use the -f [listing] to specify output.
		You didn't specify where to write the file listings. The -f
		option is not an option, it is required.

	fls: couldn't create file 'file'
		For some reason the program could not create the output file.
		Check the name displayed and see if you have a read-only file
		there or a directory with the same name.

	fls: error reading the area definition file.
		Your ProBoard filebase is corrupt. Check your FILECFG.PRO file
		by running ProCFG FA and see what it does.

	fls: couldn't access listfile for area 'n'.
		The listing file for area n could not be found. Check your ProCFG
		settings. If this program can't find it, the ProBoard can't find
		it either.


IDENTIFICATION
	Author: Branislav L. Slantchev
	Revision Number: 1.0.1
	Release Date: May 19, 1995
	Copyright (C) 1995 by Branislav L. Slantchev

LIMITS
	Disk space.

BUGS
	Not enough testing. Only a couple of satisfactory runs. As it
	stands now, the routines eat the whitespace in front of all
	descriptions. This shouldn't usually be a problem and avoids
	the ugly non-aligned columns that result otherwise. If you
	don't like this feature, just edit the source code. Sorry, no
	command-line switch to do that.

	Long file descriptions are simply truncated. If needed, they
	will be shifted and aligned properly (hopefully).

	When entering the group numbers, no whitespace is allowed in
	between commas and numbers. Why? strtok() should be able to
	deal with more than one delimeter. I edited this out of the
	source code, but the call strtok( string, " ," ) didn't quite
	work as I expected. Oh, well.

	Even though files from simple HDD areas are all checked for their
	size and date, the CD-ROM aren't. In fact, if your listings are
	on the hard-drive, the CD-ROM will not be accessed at all. This
	speeds things up considerably, but also prevents the areas with
	multiple directories from being processed as HDD (which they may
	be, but not necessarily). They will be treated as CD-ROM and the
	file info will be extracted from the listing files only.

LEGALITIES
	fls is Copyright 1995 by Branislav L. Slantchev.

	GETOPT.C, GETOPT1.C, GETOPT.H are derived from the files with
	same names (included in ORIGINAL.ZIP) and are copyright (C) by
	the Free Software Foundation. These versions have been stripped
	down to the bare bones necessary for DOS. The ORIGINAL.ZIP file
	includes the full versions.

	The comma-formatting routine is public domain (slightly altered
	by myself --B.L.S.), but I can't remember where I got it from and
	who the author is. If anybody knows, the info will be appreciated.

	ProBoard is copyright (C) by Philippe Leybaert.

	fls (all executables, source and documentation files) are
	copyrighted material of Branislav L. Slantchev.

	This program is free software. You can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation, version 2. This
	software is released under the terms of that license. Please
	read the included file COPYING for the full text.

	You should have received a copy of the GNU General Public License
	along with this program (file COPYING). If not, write to the Free
	Software Foundation, Inc., 675 Mass Ave, Campbridge, MA 02139, USA.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	Branislav L. Slantchev will not be liable for any special, incidental,
	consequential, indirect or similar damages due to loss of data or
	any other reason.

	If you find this program useful, drop me a post card at the mail
	address (see file SUPPORT). I will really appreciate that.


SEE ALSO
	HEADER.*	sample header files
	FOOTER.*	sample footer files
