/***********************************************************************
*                                                                      *
*  Definition file for INPUT.CPP                                       *
*                                                                      *
*  Purpose : Input functions for edit                                  *
*                                                                      *
*  Author  : Peter Bloemendaal                                         *
*            Brainbox systems +31-70-3523661                           *
*  eMail   : internet -> bloemendaal@rullf2.LeidenUniv.nl              *
*            fidonet  -> 2:281/908                                     *
*                                                                      *
*----------------------------------------------------------------------*
*                                                                      *
*                                                                      *
* $Log: input.hpv $
// Revision 1.3  1995/05/27  11:32:58  BRAINBOX
// Created a instream class
//
// Revision 1.2  1994/08/25  20:05:18  BRAINBOX
// 1. Input now derives from Terminal
//
*                                                                      *
************************************************************************
*/

#define INPUT_NONE     0x00
#define INPUT_KEYBOARD 0x01
#define INPUT_COM1     0x02
#define INPUT_COM2     0x04
#define INPUT_COM3     0x08
#define INPUT_COM4     0x10
#define INPUT_PEXUSER  0x20
#define INPUT_FILE     0x40

class Instream : public Terminal
{
   protected:
      static int nr ;               // Instance count

      char filename[MAXPATH] ;      // Filename for input
      long lastpos ;                // last position in openfile
      FILE *fpIn ;                  // one character keybuffer
      int  keybuf ;
      unsigned short inputmode;

   public:

      Instream() ;
      ~Instream() ;

      unsigned short peekbuffer() ;
      int  getkey() ;
      char *getInputFile(void) ;
      void setInput(unsigned int) ;
      unsigned int getInput(void) ;
      int  setInputFile(char *fileName) ;
} ;

int Instream::nr ;
