/***********************************************************************
*                                                                      *
*  Abbreviation example derived from edit                              *
*                                                                      *
*  Purpose : Input functions for edit                                  *
*                                                                      *
*  Author  : Peter Bloemendaal                                         *
*            Brainbox systems +31-70-3523661                           *
*  eMail   : internet -> bloemendaal@rullf2.LeidenUniv.nl              *
*            fidonet  -> 2:281/908                                     *
*                                                                      *
*----------------------------------------------------------------------*
*                                                                      *
*                                                                      *
* $Log: abbrev.cpv $
// Revision 1.1  1994/08/23  21:58:41  BRAINBOX
// Initial revision
//                                                                *
*                                                                      *
************************************************************************
*/
#ifndef _ABBREV_CPP
#define _ABBREV_CPP

#ifndef _PB_SDK_H
#include <ctype.h>
#endif

#include "EDIT.CPP"
#include "ABBREV.HPP"

AbbreviationEdit::~AbbreviationEdit(void)
{
   register int i;

   for (i=0 ; i<nr ; i++)
   {
      free(abbrev[i]) ;
      free(abbext[i]) ;
   }
	 if ( nr > 0 )
	 {
		 free(abbrev) ;
	   free(abbext) ;
	 }
}

int AbbreviationEdit::loadAbbreviation(char *filename)
{
   int  i, lines ;
   FILE *in ;
   char st[_MAX_WORD_LENGTH] ;
   
   // first count the lines
   lines = 0 ;
   if ( (in=fopen(filename,"rt")) == NULL)
      return 1;
   while (fgets(st,_MAX_WORD_LENGTH,in))
      lines++ ;
   fclose(in) ;


   if (nr != 0)
   {
      // Free previously allocated memory
      for (i=0 ; i<nr ; i++)
      {
         free(abbrev[i]) ;
         free(abbext[i]) ;
      }
      free(abbrev) ;
      free(abbext) ;
   }


   if (lines % 2 != 0)
      lines-- ;

   nr = lines / 2 ;


   if ( (abbrev = (char **) malloc(nr * sizeof(char*))) == NULL)
      err = TRUE ;
   if ( (abbext = (char **) malloc(nr * sizeof(char*))) == NULL)
      err = TRUE ;

   in=fopen(filename,"rt") ;
#if 0
   for (i = 0 ; i < nr ; i++)
   {
      fgets(st,_MAX_WORD_LENGTH,in) ;
      if (st[strlen(st)-1] == '\n')
         st[strlen(st)-1] = '\0' ;
      if ( (abbrev[i] = (char*) malloc(strlen(st) + 1)) == NULL)
         err = TRUE ;
      strcpy(abbrev[i],st) ;
      fgets(st,_MAX_WORD_LENGTH,in) ;
      if (st[strlen(st)-1] == '\n')
         st[strlen(st)-1] = '\0' ;
      if ( (abbext[i] = (char*) malloc(strlen(st) + 1)) == NULL)
         err = TRUE ;
      strcpy(abbext[i],st) ;
   }
#else
   for (i = 0 ; i < nr ; i++)
   {
      register int l;

      fgets(st,_MAX_WORD_LENGTH,in) ;

			l = strlen(st)-1;
      if (st[l] == '\n')
        st[l--] = '\0' ;

       // I_A: yes! l+2 as l == strlen(st)-1 *ever*!
      if ( (abbrev[i] = (char*) malloc(l+2)) == NULL)
         err = TRUE ;
      strcpy(abbrev[i],st) ;

      fgets(st,_MAX_WORD_LENGTH,in) ;
      l = strlen(st)-1;
      if (st[l] == '\n')
         st[l--] = '\0' ;
      if ( (abbext[i] = (char*) malloc(l+2)) == NULL)
         err = TRUE ;
      strcpy(abbext[i],st) ;
   }
#endif
   fclose(in) ;


   return 0 ;
}


#if 0
void AbbreviationEdit::addchar(char ch)
{
   char l_sWord[_MAX_WORD_LENGTH] ;
   char l_sHelp[2];
   register int  i, j ;

   if (status)
   {
      l_sHelp[0] = ch ;
      l_sHelp[1] = '\0' ;
      if (strstr(stopchar,l_sHelp) != NULL)  // Stop char found
      {
         for ( i = curpos - 1 ; curpos - i < _MAX_WORD_LENGTH
            && i >= 0 ; i--)
         {
            // Scan the txtstring back
            l_sHelp[0] = txt[i] ;
            if (strstr(stopchar,l_sHelp) != NULL)
               break ;
         }
         if (curpos != i)
         {
            strncpy(l_sWord,txt + i + 1,curpos - i);  // l_sWord now contains the last word typed
            l_sWord[curpos - i - 1] = '\0' ;
            for ( i = 0 ; i < nr ; i++)
               if (strcmpi(l_sWord,abbrev[i]) == 0)
               {
                  // There is an abbreviation found. Process it
                  for (j = 0 ; j < strlen(abbrev[i]) ; j++ )
                     this->backspace() ;
                  if (strlen(abbext[i]) == 0)
                     this->backspace() ;
                  for (j = 0 ; j < strlen(abbext[i]) ; j++ )
                     if ( j == 0 && isupper(l_sWord[0]) )
                        Edit::addchar(toupper(abbext[i][j])) ;
                     else
                        Edit::addchar(abbext[i][j]) ;
                  break ;
               }
         }
      }

   }
   Edit::addchar(ch) ;
}
#else
void AbbreviationEdit::addchar(char ch)
{
   char l_sWord[_MAX_WORD_LENGTH] ;
   char l_sHelp;
   register int  i, j ;

   if (status)
   {
      l_sHelp = ch ;
      if (strchr(stopchar,l_sHelp) != NULL)  // Stop char found
      {
         for ( i = curpos - 1 ; curpos - i < _MAX_WORD_LENGTH
            && i >= 0 ; i--)
         {
            // Scan the txtstring back
            l_sHelp = txt[i] ;
            if (strchr(stopchar,l_sHelp) != NULL)
               break ;
         }
         if (curpos != i)
         {
            strncpy(l_sWord,txt + i + 1,curpos - i);  // l_sWord now contains the last word typed
            l_sWord[curpos - i - 1] = '\0' ;
            for ( i = 0 ; i < nr ; i++)
               if (stricmp(l_sWord,abbrev[i]) == 0)
               {
                  // There is an abbreviation found. Process it
                  for (j = 0 ; j < strlen(abbrev[i]) ; j++ )
                     backspace() ;

                  if (strlen(abbext[i]) == 0)
                     backspace() ;
                  for (j = 0 ; j < strlen(abbext[i]) ; j++ )
                     if ( j == 0 && isupper(l_sWord[0]) )
                        Edit::addchar(toupper(abbext[i][j])) ;
                     else
                        Edit::addchar(abbext[i][j]) ;
                  break ;
               }
         }
      }

   }
   Edit::addchar(ch) ;
}
#endif


void AbbreviationEdit::setAbbrevStatus(int flag)
{
   status = flag ;
}


#endif
