/***************************************************************************/
/*** Ethereal Library                                 For ProBoard v2.0x ***/
/***  ***/
/*** File Base Configuration Editor 1.01                                ***/
/***************************************************************************/
/*** FreeWare - Part of PB-GNU                    (C) 1995 Alvin Brinson ***/
/***************************************************************************/

#include "pb_sdk.h"

/* Defines */

#define FLAGS   " ABCDEFGHIJKLMNOPQRSTUVWXYZ123456"


/* Routines */

void main(void);        /* Does Nada                     */
void menu(void);        /* Dis baby, she do all de work  */
void readfa(void);      /* Read file areas               */
void writefa(void);     /* Write file areas              */
void headers(void);     /* Show the headers...           */
void chgarea(void);     /* Cheapy change area function   */
void show(void);        /* Show The Stuff!               */
void clr_topscr(void);  /* Clear Main Display Area       */
void clr_window(void);  /* Clear print window            */
void anykey(void);      /* Hit any key ...               */
void clear_rec(void);   /* Append an area onto FILECFG   */
void clone_area(void);  /* Clone existing area           */

/* Global Vars */

    int f ;             /* File handle for FILECFG.PRO */

    char fname[80];         /* Path and filename of FILECFG.PRO */
    FILEAREA *fa;           /* assigns fa to structure FILEAREA */
    long cur_rec;           /* Current record pointer */
    char tempvar[80];       /* temporary var storage (for manip'ing) */
    int num_recs;           /* Number of records in FILEAREA */
    int clone_to;        /* Area # passed to clone_area funct. */

/* The Actual Stuff */

void readfa(void)
{
    strcpy(fname,SysPath);
    strcat(fname,"FILECFG.PRO");

    f = open(fname,O_RDWR | O_DENYNONE);

    fa = malloc(sizeof(FILEAREA));

    num_recs = (l_div(filelength(f) , sizeof (FILEAREA))) - 1;
        /* Determines number of available records */

    lseek (f , l_mul(cur_rec,sizeof(FILEAREA)),SEEK_SET);
        /* Sets location to current record */

    read(f , fa , sizeof(FILEAREA));
        /* Reads current record into pointer 'fa' */

    close(f);
}

void writefa(void)
{
    strcpy(fname,SysPath);
    strcat(fname,"FILECFG.PRO");

    f = open(fname,O_RDWR | O_DENYNONE);

    lseek (f , l_mul(cur_rec,sizeof(FILEAREA)),SEEK_SET);
        /* Sets current record */

    write(f , fa , sizeof(FILEAREA));
        /* Writes record in 'fa' back to file pointed to by 'f' */

    close(f);
}

void chg_area(void)     /* Not properly working right now */
{
    MenuFunction(MENU_SET_FILEAREA,"*");
    cur_rec = (CurUser->fileArea - 1);
    printf("\f");
    headers();
}

void anykey(void)
{
        printf("\007Hit Any Key ...");
        WaitKey();
}

void clr_topscr()                               /* Clear Display Area */
{
    int x;
    GotoXY(1,4);
    for (x=0; x<=14; ++x)
       printf("                                                                               \n");
}

void clr_window()                               /* Clear text window*/
{
    GotoXY(1,21); ClrEol();
    GotoXY(1,22); ClrEol();
    GotoXY(1,23); ClrEol();
}

void headers(void)
{
    printf("\f");
    printf("\001.------.\n");
    printf("                         \007Ethereal Filebase Config 1.01                        \n");
    printf("\001.------.\n");
    GotoXY(1,20);
    printf("\001");
    GotoXY(1,24);
    printf("\001");
}

void clear_rec(void)
{
            strcpy(fa->name,"");
            strcpy(fa->listpath,"");
            strcpy(fa->filepath,"");
            fa->level = 0;
            fa->flags=0;
            fa->cdrom = FALSE;
            fa->maxfiles=0;
            fa->maxkb=0;
            fa->notops = FALSE;
            fa->free   = FALSE;
            fa->groups[0]=0;
            fa->groups[1]=0;
            fa->groups[2]=0;
            fa->groups[3]=0;
            fa->allGroups = FALSE;
            fa->minAge = 0;
            fa->flagsNot = 0;
            strcpy(fa->extra,"");
            writefa();
}

void clone_area(void)
{
    readfa();
    cur_rec = clone_to;
    writefa();
    Log(LOG_SUSPICIOUS,"Area %u cloned into area %u",cur_rec,clone_to);
}

/*      ---->>>> The BIG Parts - All the above was FLUFF! <<<<---- */

void show(void)
{
    int x;

    clr_topscr();

    GotoXY(1,4);
    printf("\002(\006N\002) \007Name of Area: \n\005%s",fa->name);

    GotoXY(1,6);
    printf("\002(\006L\002) \007Path for files list: \n\005%s",fa->listpath);

    GotoXY(1,8);
    printf("\002(\006P\002) \007Path for files: \n\005%s",fa->filepath);

    GotoXY(1,10);
    printf("\002(\006A\002) \007Level for Access: \005%u",fa->level);

    GotoXY(50,10);
    if (fa->cdrom == TRUE) {
        printf("\002(\006C\002) \007CD-Rom Area: \005Yes");
    }
    else {
        printf("\002(\006C\002) \007CD-Rom Area: \005No ");
    }

    GotoXY(1,11);
    printf("\002(\006F\002) \007Flags: ");
	for (x=1; x<=32; ++x) {
        if (GetFlag(fa->flags,x) == TRUE)
            printf("\005%c",FLAGS[x]);
		else
            printf("\004-");
	}
    printf("\n");

    GotoXY(1,12);
    printf("\002(\006M\002) \007Max # of Files: \005%u",fa->maxfiles);

    GotoXY(50,12);
    printf("\002(\006K\002) \007Max Kilobytes : \005%u",fa->maxkb);

    GotoXY(1,13);
    if (fa->notops == TRUE) {
        printf("\002(\006T\002) \007Top Lists: \005Disabled");
    }
    else {
        printf("\002(\006T\002) \007Top Lists: \005Enabled");
    }

    GotoXY(50,13);
    if (fa->free == TRUE) {
        printf("\002(\006R\002) \007Free File Area: \005Yes");
    }
    else {
        printf("\002(\006R\002) \007Free File Area: \005No");
    }

    GotoXY(1,14);
    if (fa->allGroups == TRUE) {
        printf("\002(\006G\002) \007All Groups: \005Yes");
    }
    else {
        printf("\002(\006G\002) \007All Groups: \005No");
    }

    GotoXY(1,15);
    printf("\002(\0061\002) \007Group #1: \005%u",fa->groups[0]);

    GotoXY(25,15);
    printf("\002(\0062\002) \007Group #2: \005%u",fa->groups[1]);

    GotoXY(1,16);
    printf("\002(\0063\002) \007Group #3: \005%u",fa->groups[2]);

    GotoXY(25,16);
    printf("\002(\0064\002) \007Group #4: \005%u",fa->groups[3]);

}

void menu(void)
{
    char choice, flag, asc_value[2];
    int flag_num;

	do {
        readfa();
        show();
        clr_window();
        GotoXY(1,21);
		SetColor(CYAN);
        printf("Current File Base : #\006%u, ", cur_rec + 1);
        printf("\007%s",fa->name);
        GotoXY(1,23);
        printf("\007(Press ? for Help) Command : ");
		choice = WaitKey();
		switch (toupper(choice)) {

        case KEY_CTLR : {
            printf("\f");
            headers();
            break;
            }

        case '[' : {           /* could use a while name="" do increment */
         if (cur_rec == 0) {
            clr_window();
            GotoXY(1,21);
            printf("\001Cannot move backwards.");
            GotoXY(1,23);
            anykey();
            clr_window();
        }
        else
            --cur_rec;
            break;
        }

        case ']' : {
            if (cur_rec == num_recs) {
                clr_window();
                GotoXY(1,21);
                printf("\001Cannot move forward.\n\007Use 'I' to append a new base.");
                GotoXY(1,23);
                anykey();
                clr_window();
            }
            else
                ++cur_rec;
                break;
            }

        case '?' : {
            clr_topscr();
            GotoXY(1,4);
            printf("                        \003   I   \006- \007Append New Base.\n");
            printf("                        \003   O   \006- \007Clone Current Base.\n\n");
            printf("                        \003   [   \006- \007Next Base.\n");
            printf("                        \003   ]   \006- \007Previous Base.\n");
            printf("                        \003CTRL-B \006- \007First Base.\n");
            printf("                        \003CTRL-E \006- \007Last Base.\n");
            printf("                        \003CTRL-J \006- \007Jump to Area.\n\n");
            printf("                        \003CTRL-D \006- \007Delete Base.\n\n");
            printf("                        \003CTRL-R \006- \007Redraw Screen.\n\n");
            printf("        \002(\007C\002) \007 1995 \004 Alvin Brinson");
            printf("                   \0071\002:\007106\002/\0077008 \006 FidoNet");

            clr_window();
            anykey();
            clr_topscr();
            break;
        }

        case KEY_CTLJ : {
            clr_window();
            GotoXY(1,22);
            printf("\007Jump to WHICH Area (\0061\007-\006%u\007) \004: ",num_recs+1);
            Input(tempvar,5,INPUT_DIGITS);
            if (atoi(tempvar) <= (num_recs +1)) {
                cur_rec = (atoi(tempvar) -1);
            }
            break;
        }

        case KEY_CTLL : {
            printf("\f");
            chg_area();
            break;
        }

        case KEY_CTLB : {
            cur_rec = 0;
            break;
        }

        case KEY_CTLE : {
            cur_rec = num_recs;
            break;
        }

        case KEY_CTLD : {
            clear_rec();
            Log(LOG_NORMAL,"Area %u deleted!",cur_rec);
            break;
        }

        case 'N' : {
            GotoXY(1,5);
            Input(tempvar,79,INPUT_ALL);
            if (strlen(tempvar) != 0) {
               strcpy(fa->name,tempvar);
            }
            writefa();
            break;
        }

        case 'L' : {
            GotoXY(1,7);
            Input(tempvar,79,INPUT_UPALL);
            if (strlen(tempvar) != 0) {
                strcpy(fa->listpath,tempvar);
            }
            writefa();
            break;
        }

        case 'P' : {
            GotoXY(1,9);
            Input(tempvar,79,INPUT_UPALL);
            if (strlen(tempvar) != 0) {
                strcpy(fa->filepath,tempvar);
            }
            writefa();
            break;
        }

        case 'A' : {
            GotoXY(23,10);
            Input(tempvar,5,INPUT_DIGITS);
            if (strlen(tempvar) != 0) {
                fa->level = atol(tempvar);
            }
            writefa();
            break;
        }

        case 'F' : {
            clr_window();
            GotoXY(1,21);
            printf("\006Edit Area Flags.");
            GotoXY(1,23);
            printf("\007Enter Flag to Toggle ([\003Enter\007] to Abort) : ");
            flag = WaitKey();
            if (strchr("ABCDEFGHIJKLMNOPQRSTUVWXYZ123456",toupper(flag)) == NULL)
                break;

            sprintf(asc_value,"%d",toupper(flag));

            if ((atoi(asc_value) >= 49) && (atoi(asc_value) <= 54))
                flag_num = atoi(asc_value) - 22;
            else
                flag_num = atoi(asc_value)-64;

            if (GetFlag(fa->flags,flag_num) == TRUE) {
                    ClearFlag(fa->flags,flag_num)
                }
            else {
                SetFlag(fa->flags,flag_num)
            }
            writefa();
            break;
        }

        case 'C' : {
            if (fa->cdrom == TRUE) {
                fa->cdrom = FALSE;
            }
            else {
                fa->cdrom = TRUE;
            }
            writefa();
            break;
        }

        case 'M' : {
            GotoXY(21,12);
            Input(tempvar,5,INPUT_DIGITS);
            fa->maxfiles = atoi(tempvar);
            writefa();
            break;
        }

        case 'K' : {
            GotoXY(70,12);
            Input(tempvar,5,INPUT_DIGITS);
            fa->maxkb = atoi(tempvar);
            writefa();
            break;
        }

        case 'R' : {
            if (fa->free == TRUE) {
                fa->free = FALSE;
            }
            else {
                fa->free = TRUE;
            }
            writefa();
            break;
        }

        case 'T' : {
            if (fa->notops == TRUE) {
                fa->notops = FALSE;
            }
            else {
                fa->notops = TRUE;
            }
            writefa();
            break;
        }

        case 'G' : {
            if (fa->allGroups == TRUE) {
                fa->allGroups = FALSE;
            }
            else {
                fa->allGroups = TRUE;
            }
            writefa();
            break;
        }

        case 'I' : {
            clr_window();
            GotoXY(1,21);
            printf("Append new record? ");
            if (Ask(TRUE) == TRUE) {
                num_recs = num_recs + 1;
                printf("Appending record at position %u...",num_recs);
                cur_rec = num_recs;
                clear_rec();;
            }
            break;
        }

        case 'O' : {
            clr_window();
            GotoXY(1,21);
            printf("\007Clone Current Area? ");
            if (Ask(TRUE) == TRUE) {
                GotoXY(1,22);
                printf("\007Clone into which area? ");
                Input(tempvar,5,INPUT_DIGITS);
                if (strlen(tempvar) != 0) {
                    if (atoi(tempvar)-1 <= num_recs) {
                        clone_to = atoi(tempvar)-1;
                        clone_area();
                    }
                    else {
                        clr_window();
                        GotoXY(1,21);
                        printf("\007Cannot clone into non-existant area. Use 'I' to append new areas.");
                        GotoXY(1,23);
                        anykey();
                    }
                }
            }
            break;
        }

        case '1' : {
            GotoXY(15,15);
            Input(tempvar,3,INPUT_DIGITS);
            if (strlen(tempvar) != 0) {
                if (atoi(tempvar) < 255) {
                    fa->groups[0] = atoi(tempvar);
                }
            }
            writefa();
            break;
        }

        case '2' : {
            GotoXY(39,15);
            Input(tempvar,3,INPUT_DIGITS);
            if (strlen(tempvar) != 0) {
                if (atoi(tempvar) < 255) {
                    fa->groups[1] = atoi(tempvar);
                }
            }
            writefa();
            break;
        }


        case '3' : {
            GotoXY(15,16);
            Input(tempvar,3,INPUT_DIGITS);
            if (strlen(tempvar) != 0) {
                if (atoi(tempvar) < 255) {
                    fa->groups[2] = atoi(tempvar);
                }
            }
            writefa();
            break;
        }

        case '4' : {
            GotoXY(39,16);
            Input(tempvar,3,INPUT_DIGITS);
            if (strlen(tempvar) != 0) {
                if (atoi(tempvar) < 255) {
                    fa->groups[3] = atoi(tempvar);
                }
            }
            writefa();
            break;
        }


        } /* End of SWITCH statement*/
    } while (toupper(choice) != 'Q');
} /* End of FUNCTION*/

void main(void)
{
    Log(LOG_FRIEND,"File Base Editor --> Start");
    cur_rec=0;
    headers();
    menu();
    Log(LOG_FRIEND,"File Base Editor --> End");
}
