
PB-GNU BULETMAN					User's Manual				PB-GNU BULETMAN
						Last revision date: June 23, 1995


NAME
	PB-GNU BULETMAN - bulletin manager for ProBoard 2.0x

SYNOPSIS
	BULETMAN [-mn] [-f path]

VERSION
	PB-GNU BULETMAN version 1.15

DESCRIPTION
	PB-GNU BULETMAN	a full-featured Bulletin Manager for ProBoard 2.0x
	Allows auto-display of updated bulletins or a menu mode. Lists
	all new or updated bulletins. Customizable prompts with colour
	support. Download bulletins, view same or only new and updated
	bulletins. Other options controllable through the configuration
	file. Supports unlimited sets of bulletins with one executable
	and different configuration files. Can be used as a WELCOMEx.PEX
	to display new bulletins. Automatically recognizes new and
	updated files. Fully supports ProBoard control codes in the
	menu screen and all bulletins. Allows for different directories
	where bulletins are stored.

OPTIONS
	The options must be preceeded by a dash '-'. You can group the options
	together with one dash as long as the '-f' option is the last in the
	list. You can have spaces between the '-f' option and the path parameter
	it expects. Below is a list of valid command lines.

	-m    	force the Bulletin Manager to operate in menu mode,
			regardless of the setting of AutoRead in the configuration
			file. Useful if you want to have a WELCOMEx.PEX and only
			one configuration file, but use BULETMAN as a menu entry
			with its own menu screen.

	-f path	'path' is the full file path of an alternative configuration
			file. The default has the same file name as the PEX file with
			extension INI and resides in the same directory. The alternate
			configuration file can have any name you want and reside
			anywhere on the disk. Be sure to specify the complete path to
			that file including drive, path, name and extension. It is a
			good idea to use the -m parameter when you're using this one.

	-n		No copyright text is shown at the end, regardless of the baud
			rate. The default is: if the baud is >= 9600, then show the
			text and skip it otherwise. This will bypass the closing
			screen altogether.

VALID COMMAND LINES
	buletman
		This will cause BULETMAN to look for a configuration file
		called 'BULETMAN.INI' in the directory where the PEX resides.

	buletman -m
		This will force BULETMAN to operate in menu mode regardless of
		the setting in the configuration file. The expected configuration
		file is the same as above.

	buletman -n
		This will cause BULETMAN to skip the closing screen. The expected
		config file is same as above.

	buletman -f c:\pb\alt\myconfig.cfg
		This will cause BULETMAN to use the alternate configuration file
		'C:\PB\ALT\MYCONFIG.CFG'. Note that you have to give it the path.

	buletman -mnf c:\pb\cfg\bulet.ini
		This will cause BULETMAN to use the alternate configuration file
		'C:\PB\CFG\BULET.INI'. It will ignore the setting of AutoRead and
		will force menu mode. Also, the closing screen will be skipped.

BULLETINS
	If the RootName entry in the configuration file is not specified, all
	bulletins should reside in your ProBoard TXTFILES directory as defined
	in ProCFG. You can create a subdirectory for your bulletins. The only
	restriction is that it has to be in the TXTFILES directory. See the
	.INI file for more information. All bulletins should have a root name
	(which can include a parent directory). The file name itself should
	not exceed 5 characters. Thus,

			RootName = BLTN
			RootName = SUB\BULET

	are valid choices and RootName = BULLET is not. The actual bulletins
	should be named RootName<n>.ANS/ASC, where "RootName" is the name you
	specified in the configuration file (or the default) and <n> is the
	number of the bulletins (no leading zeroes). For example, bulletin
	number 34 with root name BUL\BLTN will require two files in the
	..\TXTFILES\BUL subdirectory: BLTN34.ANS and BLTN34.ASC: one version
	for your ANSI callers and the other for the ASCII callers.

EXAMPLES
	You want to have two sets of bulletins. One for news that are only
	displayed during login and another, permanent with rules and
	regulations of the board. First, rename BULETMAN.PEX to WELCOME1.PEX
	and place it in your PEX directory. Then, rename BULETMAN.INI to
	WELCOME1.INI and place it in the same directory. Edit the INI file,
	making sure you set AutoRead and NewOnly to True. Also, set the
	RootName to NEWS-. Next, create your news bulletins in the Text
	Files directory (as in ProCFG). Name them NEWS-nnn.ANS and
	NEWS-nnn.ASC where nnn is the number of the bulletin (no leading
	zeroes). Next copy the WELCOME1.INI file to a new name: BULETMNU.INI.
	Edit the new INI file, setting AutoRead to False and RootName to
	BULL-. Next, create your permanent bulletins in the Text Files
	directory and give them names like BULL-1.ANS, BULL-3.ASC, etc. It's
	a good idea to have both ANSI and ASCII versions. Next, in ProCFG's
	Menu Editor, create a menu entry with Function 60, Run ProBoard SDK
	File. In the data field put: WELCOME1 -f C:\PB\PEX\BULETMNU.INI
	(this assumes your PEX directory is C:\PB\PEX). Finally, create
	your menu screen (up to 21 lines), name it according to the ShowFile
	entry in the configuration file and place it in your Text Files
	directory (both ANSI and ASCII version). That should be it.
	Now, every time you want to add some news, just create/update one
	of the NEWS-???.A?? files. It will be shown to the user when he/she
	logs on. Of course, you can add more BULL- files too. The Bulletin
	Manager will find them directly.

	If you wish to keep the same set of bulletins for your login sequence
	and the menu mode, delete the BULETMNU.INI file and edit the data
	line to read: WELCOME1 -m


FILES
	BULETMAN.PEX	main executable
	BULETMAN.INI	configuration file
	BLT-????.A??	bulletins
	????????.A??	menu screen

DIAGNOSTICS
	No logging is performed.

ERRORS
	Error reading INI file: 'varname'

		an error occurred while trying to read value for 'varname'
		from the configuration file. This might be due to a missing
		or corrupted file. This also might mean that you commented
		out a variable that must be present. Check the .INI file.

	File not found: 'filename'

		File was not found. If you see NOFILE as an entry for the
		'filename', this means that your menu screen could not be
		found. Check your Text Files directory for .ANS/.ASC file
		with root name as specified in your configuration file.

	Bulletin number exceeds max ('maximum'): 'filename'

		BULETMAN located a possible bulletin file whose number exceeds
		the maximum number of allowable bulletins. 'maximum' is the
		highest bulletin number allowed (currently 999), and 'filename'
		is the offending filename. Rename the file.

	Bulletin 'number' doesn't exist. Press [Enter] to continue...

		Generic catch-all message. Displayed when the user requested
		to view or download a bulletin that doesn't exist. This error
		will not abort the program.

IDENTIFICATION
	Author: Branislav L. Slantchev
	Revision Number: 1.15
	Release Date: June 29, 1995
	Copyright (C) 1995 by Branislav L. Slantchev

CHANGES
	1.0		Initial version, limited features, no menu mode
	1.10	Added menu mode
	1.12	Added support for multiple configuration files, fixed bugs
	1.14	Added support for subdirectories
	1.15    Redesigned prompts, new INI file format, new options

BUGS
	Well, see NOTES.

LEGALITIES
	PB-GNU BULETMAN is Copyright 1995 by Branislav L. Slantchev.

	PB-GNU BULETMAN was written with Borland C++ 3.1 compiler and
	ProBoard SDK 2.01.

	PB-GNU BULETMAN (all executables, source and documentation files) are
	copyrighted material of Branislav L. Slantchev.

	This program is free software. You can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation, version 2. This
	software is released under the terms of that license. Please
	read the included file COPYING for the full text.

	You should have received a copy of the GNU General Public License
	along with this program (file COPYING). If not, write to the Free
	Software Foundation, Inc., 675 Mass Ave, Campbridge, MA 02139, USA.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	Branislav L. Slantchev will not be liable for any special, incidental,
	consequential, indirect or similar damages due to loss of data or
	any other reason.

	If you find this program useful, drop me a post card at the mail
	address above. I will really appreciate that.


SEE ALSO
	BULETMAN.INI for configurable options and parameters
	README for quick installation and trouble-shooting
	NOTES for revision log
	SOURCE for source code availability
