(*
                        __
        ___  __________/  |________
        \  \/  / ____/\   __\_  __ \
         >    < <_|  | |  |  |  | \/
        /__/\_ \__   | |__|  |__|
              \/  |__|
-------------------------------------------------
    XFiles for Mystic BBS 1.12+ (2nd Edition)     
-------------------------------------------------
An easy way to create file areas on your BBS.

Features:
  - Create Directories on the fly
  - Create/Edit Text files with internal editor
  - Immediate Download
  - View text files or ANSI files
  - Add descriptions for the files on the fly
  - Extract file_id.diz files
  - Add and download files from the Internet

Compatible with Linux/Raspberry Pi. With some
modifications runs also on Windows.
-------------------------------------------------
                            .oO0( xqtr )0Oo.


   _            _   _              ___          _    _
  /_\  _ _  ___| |_| |_  ___ _ _  |   \ _ _ ___(_)__| |               8888
 / _ \| ' \/ _ \  _| ' \/ -_) '_| | |) | '_/ _ \ / _` |            8 888888 8
/_/ \_\_||_\___/\__|_||_\___|_|   |___/|_| \___/_\__,_|            8888888888
                                                                   8888888888
         DoNt Be aNoTHeR DrOiD fOR tHe SySteM                      88 8888 88
                                                                   8888888888
    .o HaM RaDiO    .o ANSi ARt!       .o MySTiC MoDS              "88||||88"
    .o NeWS         .o WeATheR         .o FiLEs                     ""8888""
    .o GaMeS        .o TeXtFiLeS       .o PrEPardNeSS                  88
    .o TuTors       .o bOOkS/PdFs      .o SuRVaViLiSM          8 8 88888888888
    .o FsxNet       .o SurvNet         .o More...            888 8888][][][888
                                                               8 888888##88888
   TeLNeT : andr01d.zapto.org:9999 [UTC 11:00 - 20:00]         8 8888.####.888
   SySoP  : xqtr                   eMAiL: xqtr.xqtr@gmail.com  8 8888##88##888
                            
*)


Uses Cfg
Uses User

Const 
  sysop = 's255';
  fext = 'zip;txt;pdf;doc;arj;rar;gba;nes;rom;lha;7z';
  max_Items = 200;
  list_left = 4;
  list_top = 7;
  list_width = 20;
  list_on = '|15|17';
  list_off = '|07';
  list_on_dir = '|15|17';
  list_off_dir = '|07';
  list_max = 16;
  morex = 9;
  morey = 23;
  cx = 29;
  cy = 7;
  cwidth = 48;
  cheight = 16;
  cch = ' ';

  scrollheight = 14;
  scroll_maxlines = 50;
  scroll_width = 48;
  scrollx = 29;
  scrolly = 9;

  searchx = 1;
  searchy = 25;
  searchcol = '|08';
  max_dirdepth = 20;


Type 
  Rec = Record
    Name : String;
    typ  : byte;
  End;

Var 
  ListFile      : File;
  OutFile       : File;
  OutName       : String;
  tmpfile       : string;
  tmpstring     : String;
  buffer        : byte;
  Datapath      : string;
  basedir       : string;
  TotalItems    : byte;
  Temp          : byte;
  Temp2         : byte;
  DirDepth      : array[1..max_dirdepth] Of String;
  DirIndex      : byte;
  Item          : array[1..max_Items] Of Rec;
  Idx           : Array[1..max_Items] Of byte;
  TopPage       : byte;
  BarPos        : byte;
  Done          : Boolean;
  Ch            : Char;
  Ch2           : Char;
  More          : byte;
  LastMore      : byte;
  CurDir        : string;
  scrolltext    : array[1..scroll_maxlines] Of string;
  scrollidx     : byte;
  scrolllines   : byte;
  ti            : integer;
  kk            : Char;
  fff           : integer = 0;
  search        : string;
  search_idx    : integer;

Procedure ClearArea;
Var o: byte;
Begin
  For o:=1 To cheight Do
    Begin
      GotoXY(cx,cy+o);
      Write(strrep(cch,cwidth));
    End;
End;

Procedure XWindow(H1:String;T,X1,Y1,X2,Y2:Integer);
Var T1,A1,A2,B1,B2  : String;
Begin
  A1 := Int2Str(X1);
  A2 := Int2Str(X2);
  B1 := Int2Str(Y1);
  B2 := Int2Str(Y2);
  T1 := Int2Str(T);
  Write('|#X#'+T1+'#'+H1+'#'+A1+'#'+B1+'#'+A2+'#'+B2+'#');
End;

Procedure Center(s:String; line:byte);
Begin
  GotoXY(40-(length(stripmci(s)) / 2),line);
  Write(s);
End;

Procedure MsgBox(t,s:String);
Begin
  XWindow(t,1,20,10,60,12);
  Center(s,11);
End;

Function GetString(title:string):String;
Var
  Cat : String;
Begin
  XWindow(title ,1,40,12,60,14);
  GotoXY(42,13);
  Cat := '';
  Cat := Input(17,30,11, Cat);
  If Cat <> '' Then GetString:=cat Else GetString:='';
End;

Procedure BarON;
Begin
  GotoXY (list_left, list_top + BarPos - TopPage);
  If item[BarPos].typ = 0 Then
    Write (list_on_dir+' ' + PadRT(StripMCI(item[BarPos].Name), list_width, ' ') + '|16');
  Else
    Write (list_on+' ' + PadRT(StripMCI(item[BarPos].Name), list_width, ' ') + '|16');
End;

Procedure BarOFF;
Begin
  GotoXY (list_left, list_top + BarPos - TopPage);
  If item[BarPos].typ = 0 Then
    Write (list_off_dir+' ' + PadRT(item[BarPos].Name, list_width, ' '));
  Else
    Write (list_off+' ' + PadRT(item[BarPos].Name, list_width, ' '));
End;

Function GetXRLInfo(filename:String;mode:byte):String;
Var
  fp: File;
  b : Byte;
  s : String;
  res : string;
  inf : string[5];
Begin
  fAssign(fp,filename,66);
  fReset(fp);
  Case mode of
    1: inf :='NAME';
    2: inf :='SIZE';
    3 :inf :='LINK';
  End;
  res := '-';
  While Not fEOF(fp) Do Begin
    fReadLn(fp,s);
    If StripB(Upper(WordGet(1,S,'=')),' ') = inf Then
    Begin
      //res:=StripB(Copy(S,b+5,Length(s)-b+1),' ');
      res := StripB(WordGet(2,S,'='),' ');
      Break;
    End;
  End;
  fClose(fp);
  GetXRLInfo := res;
End;

Function EditFile(FX,Subject:String):Boolean;
Var
  Lines    : Integer = 10;
  WrapPos  : Integer = 80;
  MaxLines : Integer = 200;
  Forced   : Boolean = False;
  Template : String  = 'msg_editor';
  Count	   : Integer;
  i        : Integer;
  S        : String;
  fptr     : file;
  k        : Char;
Begin
	If Not FileExist(FX) Then Begin
		For  i := 0 To MaxLines Do MsgEditSet(i,'');
	End Else Begin
    fAssign(fptr,FX,66);
    fReset(fptr);
    i := 1;
    While (Not feof(fptr)) Do
      Begin
        fReadLn(fptr,s);
        MsgEditSet(i,s);
        i := i + 1;
        If i>=MaxLines Then break;
      End;
    fClose(fptr);
    Lines:=i+1;
    MaxLines:=Lines+200;
  End;
  EditFile := True;
	
  SetPromptInfo(1, '');  

	If MsgEditor(0,Lines,WrapPos,MaxLines,Forced,Template, Subject) Then Begin
    MenuCMD('GT','|#V#1#20#10# Actions #S-Save            ,A-Abort          #');
    k := ReadKey;
    If Upper(k)='S' Then Begin
      fAssign(fptr,FX,66);
      fReWrite(fptr);
      For Count := 1 to Lines Do Begin
        fWriteLn(fptr,MsgEditGet(Count));
      End;
      fClose(fptr);
    End;
  End Else EditFile:=False;
End;

Procedure ClearItems;
Var i: integer;
Begin
  For i:=1 To max_Items Do
    Begin
      Item[i].Name := '';
      Item[i].typ := 255;
    End;
  TopPage  := 1;
  BarPos   := 1;
  Done     := False;
  More     := 0;
  LastMore := 0;
End;

Procedure ClearScrollList;
Var 
  cnt : Integer;
Begin
  ScrollIdx := 1;
  For cnt:=1 To scrolllines Do
    Begin
      scrolltext[cnt] := '';
    End;
End;

Procedure LoadDiz(filenm:String);
Var 
  tmpf  : string;
  fsc   : file;
  count : byte;
Begin
  tmpf := filenm+'.diz';
  if FileExist(filenm+'.diz') Then tmpf:=filenm+'.diz' Else
    if FileExist(filenm+'.dix') Then tmpf:=filenm+'.dix' Else Exit;
  
  fassign(fsc,tmpf,66);
  freset   (fsc);;
  count := 0;
  ClearScrollList;
  While Not feof(fsc) And count<scroll_maxlines Do
    Begin
      count := count+1;
      freadln(fsc,scrolltext[count]);
      scrolltext[count] := copy(scrolltext[count],1,scroll_width);
    End;
  fclose(fsc);
  scrolllines := count;
End;

Procedure DisplayDiz;
Var 
  cnt: byte;
Begin
  cleararea;
  cnt := 0;
  gotoxy(1,1);
  TextColor(3);
  If scrolllines<=scrollheight Then
    Begin
      For cnt:=1 To scrolllines Do
        Begin
          gotoxy(scrollx,scrolly+cnt-1);
          write(scrolltext[cnt]);
        End
    End
  Else
    Begin
      While scrollidx+cnt <= scrolllines And wherey<scrolly+scrollheight Do
        Begin
          gotoxy(scrollx,scrolly+cnt);
          write(scrolltext[scrollidx+cnt]);
          cnt := cnt+1;
        End;
    End;
End;

Procedure DisplayFile;
Var
  S : String;
Begin
  If FileExist(curdir+item[BarPos].Name) Then
    Begin
      FindFirst(curdir+item[barpos].Name,16)
      If DOSError = 0 Then
        Begin
          gotoxy(cx,7);
          write(padrt('',cwidth,' '));
          gotoxy(cx,7);
          s:='|03Date: |11'+datestr(DirTime,1)+' '+'|03Size: |11'+int2str(dirsize/1024)+' |03Kb   ';
          Write(s);
          gotoxy(scrollx,6);
          write('|11'+padrt(item[barpos].Name,34,' '));
        End;
      FindClose;
      ClearScrollList;
      LoadDiz(CurDir + Item[BarPos].Name);
      DisplayDiz;
    End Else
  If FileExist(curdir+item[BarPos].Name+'.xrl') Then
    Begin
      gotoxy(cx,7);
      write(padrt('',cwidth,' '));
      gotoxy(cx,7);
      s:='|03Type: |11Remote File  '+'|03Size: |11'+GetXRLInfo(curdir+item[BarPos].Name+'.xrl',2);
      Write(s);
      gotoxy(scrollx,6);
      write('|11'+padrt(GetXRLInfo(curdir+item[BarPos].Name+'.xrl',1),34,' '));
      ClearScrollList;
      LoadDiz(CurDir + Item[BarPos].Name);
      DisplayDiz;
    End;
  If DirExist(curdir+item[BarPos].Name) Then
    Begin
      LoadDiz(CurDir + Item[BarPos].Name);
      DisplayDiz;
    End;
End;

Procedure DrawPage;
Begin
  Temp2 := BarPos;
  For Temp := 0 To List_Max - 1 Do
    Begin
      BarPos := TopPage + Temp;
      BarOFF;
    End;
  BarPos := Temp2;
  BarON;
End;

Procedure MainScreen;
Begin
  ClrScr;
  DispFile (CfgMPEPath + 'xq-xfiles' + PathChar + 'xq-xfiles.ans');
  GotoXY(34,24);
  Center('|15[ / ] |08: |07Scroll Txt - |15CTRL-Z |07For Help',25);
End;

Procedure HelpScreen;
Begin
  ClrScr;
  if ACS(sysop) Then xwindow(' Keys ',1,20,7,60,23); Else xwindow(' Keys ',1,20,7,60,20);
  GotoXY(22,8);
  Write('|15CTRL-A    : |07Search Again');
  GotoXY(22,9);
  Write('|15CTRL-Y    : |07Clear Search');
  GotoXY(22,10);
  Write('|15Enter     : |07Select');
  GotoXY(22,11);
  Write('|15End       : |07Bottom List');
  GotoXY(22,12);
  Write('|15Home      : |07Top List');
  GotoXY(22,13);
  Write('|15Up/Down   : |07Move Selection');
  GotoXY(22,14);
  Write('|15Escape    : |07Exit');
  GotoXY(22,15);
  Write('|15Any Key   : |07Search List');
  GotoXY(22,16);
  Write('|15CTRL-D    : |07Download File');
  GotoXY(22,17);
  Write('|15CTRL-V    : |07View File');
  GotoXY(22,18);
  Write('|15[         : |07Scroll Info Up');
  GotoXY(22,19);
  Write('|15]         : |07Scroll Info Down');
  If ACS(sysop) Then Begin
    GotoXY(22,20);
    Write('|15CTRL-I    : |07Edit Description');
    GotoXY(22,21);
    Write('|15CTRL-C    : |07Create File/Dir.');
    GotoXY(22,22);
    Write('|15CTRL-E    : |07Edit File');
  End;
  center(searchcol+'Press Any Key To Continue...',24);
  GotoXY(1,25);
  Pause;
  mainscreen;
  DrawPage;
End;

Procedure fuckSort;
// a very simple and slow method For Item sorting
Var 
  i, j: integer;
  temp1 : rec;
Begin
  For j:=1 To totalItems Do
    For i := 2 To totalItems Do
      Begin
        If Item[i-1].Name>Item[i].Name Then
          Begin
            temp1 := Item[i-1];
            Item[i-1] := Item[i];
            Item[i] := temp1;
          End;
      End;
End;

Procedure GetDir(dir:String);
Var 
  i: integer;
Begin
  i := 1;
  Item[1].Name  := '..';
  Item[1].Typ   := 0;
  FindFirst (dir+'*', 63);
  While DosError = 0 Do
    Begin
      If direxist(dir+dirname) Then
        If dirname<>'.' And dirname<>'..'Then
          Begin
            i := i+1;
            Item[i].Name := DirName;
            Item[i].Typ := 0;
          End;
      FindNext;
    End;
  FindClose;
  totalItems := i;
  fucksort;
End;

Procedure GetFiles(dir:String);
Var 
  i: integer;
Begin
  i := 1;
  Item[1].Name := '..';
  Item[1].Typ := 0;
  FindFirst (dir+'*.*', 63);
  While DosError = 0 Do
    Begin
      If dirname<>'.' And dirname<>'..' Then
        If pos(upper(justfileext(dirname)),upper(fext))>0 Then
          Begin
            i := i+1;
            Item[i].Name := DirName;
            Item[i].Typ := 1;
          End Else
        if upper(justfileext(dirname))='XRL' Then Begin
            i := i+1;
            Item[i].Name := JustFilename(DirName);
            Item[i].Typ := 1;
        End;
      FindNext;
    End;
  FindClose;
  totalItems := i;
End;

Procedure GetNewDir(s:String);
Var i: byte;
Begin
  DirIndex := DirIndex+1;
  DirDepth[DirIndex] := s;
  curdir := '';
  For i:=1 To DirIndex Do
    curdir := curdir+DirDepth[i]+pathchar;
  curdir := basedir+curdir;
End;

Procedure GetPreDir;
Var i: byte;
Begin
  DirIndex := DirIndex-1;
  DirDepth[DirIndex+1] := '';
  curdir := '';
  For i:=1 To DirIndex Do
    curdir := curdir+DirDepth[i]+pathchar;
  curdir := basedir+curdir;
End;

Procedure ResetSearch;
Begin
  gotoxy(searchx,searchy);
  write(strrep(' ',length(search)));
  search := '';
  search_idx := 0;
End;

Procedure RefreshItems;
Begin
  ClearItems;
  If FileExist(curdir+'folder') Then GetFiles(curdir) Else GetDir(CurDir);
End;

//Main Block
Begin
  ClrScr;
  
  If ParamStr(1) = '' Then Begin
    XWindow(' System Error ',1,20,10,60,15);
    Center('|15Directory Not specified!',12);
    kk := ReadKey;
    Halt;
  End Else Begin
    BaseDir := ParamStr(1);
    If BaseDir[Length(BaseDir)]=PathChar Then 
      Delete(BaseDir, Length(BaseDir),1);
  End;

  If Not DirExist(BaseDir) Then
    Begin
      XWindow(' System Error ',1,20,10,60,15);
      Center('|15External Drive Not Connected!',12);
      Center('|07Aborting|08...',13);
      kk := ReadKey;
      Halt;
    End;

  If Graphics = 0 Then
    Begin
      WriteLn('|16|15No Graphics support. Exiting... |PA');
      Halt;
    End;

  For ti:=1 To max_dirdepth Do DirDepth[ti] := '';
  DirIndex := 1;

  GetThisUser;
  tmpfile := CfgTempPath + outname;
  ClearItems;
  CurDir := BaseDir + PathChar;
  GetDir(curdir);

  If TotalItems = 0 Then
    Begin
      WriteLn ('No files or directories To display');
      WriteLn('|PA');
      Halt;
    End;

  TopPage  := 1;
  BarPos   := 1;
  Done     := False;
  More     := 0;
  LastMore := 0;

  MainScreen;
  DrawPage;

  Repeat
    More := 0;
    Ch   := ' ';
    Ch2  := ' ';

    If TopPage > 1 Then
      Begin
        More := 1;
        Ch   := Chr(244);
      End;

    If TopPage + List_Max - 1 < TotalItems Then
      Begin
        Ch2  := Chr(245);
        More := More + 2;
      End;

    If More <> LastMore Then
      Begin
        LastMore := More;
        GotoXY (5, 23);
        Write (' |08(|07' + Ch + Ch2 + ' |15m|07ore|08) ');
      End;

    Ch := ReadKey;
    If IsArrow Then
      Begin
        ClearArea;
        ClearScrollList
        If Ch = Chr(72) Then
          Begin
          ClearArea;
            If BarPos > TopPage Then
              Begin
                BarOFF;
                BarPos := BarPos - 1;
                BarON;
              End
            Else
              If TopPage > 1 Then
                Begin
                  TopPage := TopPage - 1;
                  BarPos  := BarPos  - 1;
                  DrawPage;
                End;
            If Item[BarPos].Name<>'..' Then DisplayFile
            Else
              Begin
                WriteXY(cx,6,7,StrRep(' ',cwidth));
                WriteXY(cx,7,7,StrRep(' ',cwidth));
                ClearScrollList;
                
              End;
          End;

        If Ch = Chr(73) Then
          Begin
          ClearArea;
            If TopPage - List_Max > 0 Then
              Begin
                TopPage := TopPage - List_Max;
                BarPos  := BarPos  - List_Max;
                DrawPage;
              End
            Else
              Begin
                TopPage := 1;
                BarPos  := 1;
                DrawPage;
              End;
            If Item[BarPos].Name<>'..' Then DisplayFile
            Else
              Begin
                WriteXY(cx,6,7,StrRep(' ',cwidth));
                WriteXY(cx,7,7,StrRep(' ',cwidth));
                ClearScrollList;
              End;
          End;

        If Ch = Chr(80) Then
          Begin
          ClearArea;
            If BarPos < TotalItems Then
              If BarPos < TopPage + List_Max - 1 Then
                Begin
                  BarOFF;
                  BarPos := BarPos + 1;
                  BarON;
                End
            Else
              If BarPos < TotalItems Then
                Begin
                  TopPage := TopPage + 1;
                  BarPos  := BarPos  + 1;
                  DrawPage;
                End;
            If Item[BarPos].Name<>'..' Then DisplayFile
            Else
              Begin
                WriteXY(cx,6,7,StrRep(' ',cwidth));
                WriteXY(cx,7,7,StrRep(' ',cwidth));
                ClearScrollList;
              End;
          End
        Else
          If Ch = Chr(81) Then
            Begin
            ClearArea;
              If TotalItems > List_Max Then
                If TopPage + List_Max < TotalItems - List_Max Then
                  Begin
                    TopPage := TopPage + List_Max;
                    BarPos  := BarPos  + List_Max;
                    DrawPage;
                  End
              Else
                Begin
                  TopPage := TotalItems - List_Max + 1;
                  BarPos  := TotalItems;
                  DrawPage;
                End
              Else
                Begin
                  BarOFF;
                  BarPos := TotalItems;
                  BarON;
                End;
              If Item[BarPos].Name<>'..' Then DisplayFile
              Else
                Begin
                  WriteXY(cx,6,7,StrRep(' ',cwidth));
                  WriteXY(cx,7,7,StrRep(' ',cwidth));
                  ClearScrollList;
                End;
            End;
        If ch = chr(71) Then
          Begin
            ClearArea;
            TopPage := 1;
            BarPos  := 1;
            DrawPage;
            If Item[BarPos].Name<>'..' Then DisplayFile
            Else
              Begin
                WriteXY(cx,6,7,StrRep(' ',cwidth));
                WriteXY(cx,7,7,StrRep(' ',cwidth));
                ClearScrollList;
              End;
          End
        Else
          If ch = chr(79) Then
            Begin
            ClearArea;
              If totalItems > List_Max Then
                Begin
                  TopPage := TotalItems - List_Max + 1;
                  BarPos  := TotalItems;
                End
              Else
                Begin
                  BarPos  := TotalItems;
                End;
              DrawPage;
              If Item[BarPos].Name<>'..' Then DisplayFile
              Else
                Begin
                  WriteXY(cx,6,7,StrRep(' ',cwidth));
                  WriteXY(cx,7,7,StrRep(' ',cwidth));
                  ClearScrollList;
                End;
            End;
      End
    Else
      If Ch =chr(23) Then
        Begin
          //CTRL-W Delete File
          If Not ACS(sysop) Then Exit;
          MenuCMD('GT','|#V#1#20#10# Delete?          #Y-Yes             ,N-No             #');
          kk := ReadKey;
          If Upper(kk)='Y' Then Begin
          If FileExist(curdir+Item[barpos].name) Then FileErase(curdir+Item[barpos].name);
          If FileExist(curdir+Item[barpos].name) Then FileErase(curdir+Item[barpos].name+'.diz');
          If FileExist(curdir+Item[barpos].name) Then FileErase(curdir+Item[barpos].name+'.dix');
          RefreshItems;
          MainScreen;
          DrawPage;
          End;
        End
    Else
      If Ch =chr(3) Then
        Begin
          //CTRL-C Create File/Dir
          If Not ACS(sysop) Then Exit;
          MenuCMD('GT','|#V#1#20#10# Create           #D-Directory       ,F-File           #');
          kk := ReadKey;
          If Upper(kk)='F' Then Begin
            tmpstring := GetString(' Filename ');
            If tmpstring <>'' Then EditFile(curdir+tmpstring,'');
          End;
          If Upper(kk)='D' Then Begin
            tmpstring := GetString(' Dir. Name ');
            If tmpstring <>'' Then MenuCMD('DD','mkdir '+curdir+tmpstring);
            AppendText(curdir+tmpstring+PathChar+'folder','');
          End;
          RefreshItems;
          MainScreen;
          DrawPage;
          
        End
    Else
      If Ch =chr(4) Then
        Begin
          //CTRL-D for Download
          If FileExist(curdir+Item[barpos].name) Then
            Begin
              MenuCMD('GT','|#V#1#20#10# Download Package #Y-Yes             ,N-No             #');
              kk := ReadKey;
              If Upper(kk)='Y' Then MenuCMD ('F3', curdir+Item[barpos].name);
              MainScreen;
              DrawPage;
            End;
        End
    Else
      If Ch =chr(9) Then
        Begin
          //CTRL-I Edit/Create Description
          If FileExist(curdir+Item[barpos].name) or DirExist(curdir+Item[barpos].name) or FileExist(curdir+Item[barpos].name+'.xrl') Then Begin
            EditFile(curdir+Item[barpos].name+'.dix','');
            MainScreen;
            DrawPage;
          End;
            
        End
    Else
      If Ch =chr(5) Then
        Begin
          //CTRL-E Edit File
          If FileExist(curdir+Item[barpos].name) Then EditFile(curdir+Item[barpos].name,'');
          If FileExist(curdir+Item[barpos].name+'.xrl') Then EditFile(curdir+Item[barpos].name+'.xrl','');
          MainScreen;
          DrawPage;
        End;
    Else
      If Ch =chr(22) Then
        Begin
          // CTRL-V for Viewing file
          If FileExist(curdir+Item[barpos].name) Then
            Begin
              MenuCMD('GV','ansiviewtxt;ansiviewh;0;'+curdir+Item[barpos].name);
              MainScreen;
              DrawPage;
            End;
        End
    Else
      If Ch = Chr(26) Then
        Begin
          // CTRL-Z for Help Screen
          HelpScreen;
          Ch := ReadKey;
          MainScreen;
          DrawPage;
        End
    Else
      If Ch = Chr(13) Then
        Begin
          ResetSearch;
          If Item[barpos].name='..' Then
            Begin
              If DirIndex>1 Then
                Begin
                  GetPreDir;
                  ClearItems;
                  GetDir(curdir);
                End
            End
          Else
            Begin
              If FileExist(curdir+Item[barpos].name+pathchar+'folder') Then
                Begin
                  GetNewDir(Item[barpos].name);
                  ClearItems;
                  ClearScrollList;
                  getfiles(curdir);
                End
              Else If FileExist(curdir+Item[barpos].name) Then
                     Begin
                       MenuCMD('GT',
                     '|#V#1#20#10# Select #D-Download        ,V-View           ,C-Cancel          #');
                       kk := ReadKey;
                       If Upper(kk)='D' Then MenuCMD ('F3', curdir+Item[barpos].name);
                       If Upper(kk)='V' Then MenuCMD('GV','ansiviewtxt;ansiviewh;0;'+curdir+Item[barpos].name);
                       MainScreen;
                     End
              Else If FileExist(curdir+Item[barpos].name+'.xrl') Then
                     Begin
                       MenuCMD('GT',
                     '|#V#1#20#10# Select #D-Download        ,C-Cancel          #');
                       kk := ReadKey;
                       If Upper(kk)='D' Then Begin
                          tmpstring := GetXRLInfo(curdir+Item[barpos].name+'.xrl',3);
                          If FileExist(tmpstring) Then MenuCMD ('F3', tmpstring)
                          Else Begin
                            tmpfile := CfgSysPath  + 'temp' + Int2Str(NodeNum) + PathChar + Item[barpos].name;
                            //MsgBox('Info','Please Wait... Downloading File...');
                            TextColor(7);
                            ClrScr;
                            WriteLn('|15Please wait... Downloading file...');
                            WriteLn('|07Press CTRL-C to abort.');
                            WriteLn(Strrep(Chr(240),80));
                            MenuCmd('DD','wget '+tmpstring+' -O '+tmpfile)
                            If Not FileExist(tmpfile) Then Begin
                              MsgBox('Error','File not retrieved...');
                              Exit;
                            End;
                            MenuCmd ('F3', tmpfile);
                            FileErase (tmpfile);
                          End;
                          MainScreen;
                          DrawPage;
                       End;
                       MainScreen;
                     End
              Else If direxist(curdir+Item[barpos].name) Then
                     Begin
                       GetNewDir(Item[barpos].name);
                       ClearItems;
                       ClearScrollList;
                       GetDir(curdir);
                     End;
            End;
          //MainScreen;
          DrawPage;
        End
    Else
      If Ch = Chr(27) Then
        Begin
          Done := True;
        End
    Else
      If Ch = '[' Then
        Begin
          If scrolllines>scrollheight Then
            Begin
              scrollidx := scrollidx-1;
              If scrollidx<=1 Then scrollidx := 1;
            End;
          displaydiz;
        End
    Else
      If Ch = ']' Then
        Begin
          If scrolllines>scrollheight Then
            Begin
              scrollidx := scrollidx+1;
              If scrollidx+scrollheight> scrolllines Then scrollidx := scrolllines-scrollheight;
            End;
          displaydiz;
        End
    Else
      If ch = chr(1) Then Begin
        For ti:=search_idx+1 To max_items Do Begin
          If pos(search,upper(Item[ti].name))>0 then Begin
            TopPage := ti;
            BarPos  := ti;
            search_idx:=ti;
            DrawPage;
            Break;
          End;
        End	;
      End
     Else 
      If ch = chr(25) Then
        Begin
          gotoxy(searchx,searchy);
          write(strrep(' ',length(search)));
          search := '';
          search_idx := 0;
        End
    Else
      If ch>=chr(32) And ch<=chr(128) Then
        Begin
          search := search+upper(ch);
          gotoxy(searchx,searchy);
          write(searchcol+upper(search));
          For ti:=1 To max_items Do
            Begin
              If pos(search,upper(item[ti].name))>0 Then
                Begin
                  TopPage := ti;
                  BarPos  := ti;
                  search_idx := ti;
                  DrawPage;
                  break;
                End;
            End;
        End;

  Until Done;

  TextColor(0);
  ClrScr;

End;
