(*
                       __
        ___  __________/  |________
        \  \/  / ____/\   __\_  __ \
         >    < <_|  | |  |  |  | \/
        /__/\_ \__   | |__|  |__|
              \/  |__|
-------------------------------------------------
         AmiCaller for Mystic BBS v1.12+         
-------------------------------------------------
A LastCallers script that imitates an old famous
one, from the era of Amiga BBSes. This script
was requested from Zero Reader of Alcoholiday
BBS.

Features:
 - Display Last Callers (obviously...)
 - Track Online Time of Users
 - Track Upload/Donwload traffic of user
 - Display if a user is new
 - Total stats for Today/Yesterday (calls,
   posts, Upload/Download traffic, total users)
 - Flags. Track users movement inside the BBS,
   if they downloaded any files, if they made a
   post end more.
 - Make your own custom flags.

The script is compatible with Linux/RPi and
tested. Works also in Windows, but its not
tested.
-------------------------------------------------
                            .oO0( xqtr )0Oo.


   _            _   _              ___          _    _
  /_\  _ _  ___| |_| |_  ___ _ _  |   \ _ _ ___(_)__| |               8888
 / _ \| ' \/ _ \  _| ' \/ -_) '_| | |) | '_/ _ \ / _` |            8 888888 8
/_/ \_\_||_\___/\__|_||_\___|_|   |___/|_| \___/_\__,_|            8888888888
                                                                   8888888888
         DoNt Be aNoTHeR DrOiD fOR tHe SySteM                      88 8888 88
                                                                   8888888888
    .o HaM RaDiO    .o ANSi ARt!       .o MySTiC MoDS              "88||||88"
    .o NeWS         .o WeATheR         .o FiLEs                     ""8888""
    .o GaMeS        .o TeXtFiLeS       .o PrEPardNeSS                  88
    .o TuTors       .o bOOkS/PdFs      .o SuRVaViLiSM          8 8 88888888888
    .o FsxNet       .o SurvNet         .o More...            888 8888][][][888
                                                               8 888888##88888
   TeLNeT : andr01d.zapto.org:9999 [UTC 11:00 - 20:00]         8 8888.####.888
   SySoP  : xqtr                   eMAiL: xqtr.xqtr@gmail.com  8 8888##88##888
                            
*)

Uses Cfg;

Const
  NewUserCalls = 10;

Type
  RecHistory = Record                        // From records.pas 1.10
    Date       : LongInt;
    Emails     : Word;
    Posts      : Word;
    Downloads  : Word;
    Uploads    : Word;
    DownloadKB : LongInt;
    UploadKB   : LongInt;
    Calls      : LongInt;
    NewUsers   : Word;
    Telnet     : Word;
    FTP        : Word;
    POP3       : Word;
    SMTP       : Word;
    NNTP       : Word;
    HTTP       : Word;
    Hourly     : Array[1..24] of Byte;
    Reserved   : Array[1..2] of Byte;
  End;

Type
  RecLastOn = Record                                            // CALLERS.DAT
    DateTime1  : LongInt;
    NewUser    : Boolean;
    PeerIP     : String[15];
    PeerHost   : String[50];
    Node       : Byte;
    CallNum    : LongInt;
    Handle     : String[30];
    City       : String[25];
    Address    : String[30];
    Gender     : Char;
    EmailAddr  : String[35];
    UserInfo   : String[30];
    OptionData : Array[1..10] of String[60];
                          // Reserved Block Additions
    ExitTime   : LongInt; // 4 : Exit Time to get duration
    
    Reserved   : Array[1..33] of Byte; 
                          // Actual size is 53. Minus 4 for the added fields
                          // equals 49 for the rest of the block.
                          
                          // 1 : Hacked           - 1 = True - 0 = False
                          // 2 : Drop Carrier     - 1 = True - 0 = False
                          // 3 : Downloaded Files - 0 = None
                          // 4 : Uploaded Files   - 0 = None
                          // 5 : Posted Msgs      - 0 = None
    PostsToday  : LongInt;
    LoginTime   : LongInt;
    UpFiles     : LongInt;
    UpkFiles    : LongInt;
                  
  End;

Type
  RecUser = Record                                         // USERS.DAT
    PermIdx      : Array[1..8] Of Byte;    
    Handle       : String[30];                             // Handle
    Various      : Array[1..1013] Of Byte;    
    
    Calls        : LongInt;                                // Number of calls to BBS
    CallsToday   : Word;                              // Number of calls today
    DLs          : Word;                              // # of downloads
    DLsToday     : Word;                              // # of downloads today
    DLk          : LongInt;                                // # of downloads in K
    DLkToday     : LongInt;                                // # of downloaded K today
    ULs          : LongInt;                                // total number of uploads
    ULk          : LongInt;                                // total number of uploaded K
    Posts        : LongInt;                                // total number of msg posts
    Emails       : LongInt;                                // total number of sent email
    TimeLeft     : LongInt;
    Various2     : Array[1..446] Of Byte;
  End;
  
Var HistFile		: String = CfgDataPath+'history.dat'
Var CallersFile	: String = CfgDataPath+'callers.dat'
Var UsersFile	: String = CfgDataPath+'users.dat'
Var DataPath  : String;

Function Str2KB(Size:LongInt; Suf:Boolean):String;
Var
  V : Real;
Begin
  V := Size / 1000;
  If V > 1 Then 
    If Suf Then Str2KB := Real2Str(V,0)+'M' Else Str2KB := Real2Str(V,0)
  Else
    If Suf Then Str2KB := Real2Str(Size,0)+'K' Else Str2KB := Real2Str(Size,0);
End;

(*Function Str2KB(Size:LongInt; Suf:Boolean):String;
Var
  V : Real;
Begin
  V := Size / 1000;
  If V > 1 Then 
    If Suf Then Str2KB := Int2Str(V)+'M' Else Str2KB := Int2Str(V)
  Else
    If Suf Then Str2KB := Int2Str(Size)+'K' Else Str2KB := Int2Str(Size);
End;*)

Procedure ReadDay;
Var Ret	: Boolean = False;
Var Fp	: file;
Var ToDay     : RecHistory;
Var YesterDay : RecHistory;
Begin
	fAssign(Fp,HistFile,66);
	fReset(Fp);
	If IoResult <> 0 Then Exit;
  While Not fEOF(Fp) Do Begin
    fReadRec(Fp,ToDay);
    fReadRec(Fp,YesterDay);
  
  End;
  fClose(Fp);
  
  GotoXY(20,16);  Write('|07|17' + PadLt(Int2Str(ToDay.Calls),5,' '));
  GotoXY(51,16);  Write('|07|17' + PadLt(Int2Str(ToDay.Downloads),5,' '));
  GotoXY(31,16);  Write('|07|17' + PadLt(Int2Str(ToDay.Uploads),5,' '));
  GotoXY(59,16);  Write('|07|17' + PadLt(Str2KB(ToDay.DownloadKB,True),6,' '));
  GotoXY(39,16);  Write('|07|17' + PadLt(Str2KB(ToDay.UploadKB,True),6,' '));
  
  GotoXY(20,17);  Write('|07|17' + PadLt(Int2Str(YesterDay.Calls),5,' '));
  GotoXY(51,17);  Write('|07|17' + PadLt(Int2Str(YesterDay.Downloads),5,' '));
  GotoXY(31,17);  Write('|07|17' + PadLt(Int2Str(YesterDay.Uploads),5,' '));
  GotoXY(59,17);  Write('|07|17' + PadLt(Str2KB(YesterDay.DownloadKB,True),6,' '));
  GotoXY(39,17);  Write('|07|17' + PadLt(Str2KB(YesterDay.UploadKB,True),6,' '));
  
End;



Procedure GetUserInfo(Handle:String; Var rec:RecUser);
Var Fp	 : file
Var ii   : Integer;
Var User : RecUser;
Begin
	fAssign(Fp,UsersFile,66);
	fReset(Fp);
  FillChar(User, SizeOf(User), #0);
  ii:=0;
	If IoResult = 0 Then Begin
		While Not fEof(fp) Do Begin
			fReadRec(Fp,User);
      If User.Handle = Handle Then Begin
        rec := User;
        Break;
      End;
      ii := ii + 1;
    End;
		fClose(Fp);
	End;
End;

Function Time2Sec(D:LongInt):String;
Var
  m : Byte;
  s : Byte;
Begin
  If D < 0 Then Begin
    Time2Sec := '00:00';
    Exit;
  End;
  m := D / 60;
  s := D % 60;
  If m > 60 Then Begin
    m := m / 60;
    Time2Sec := PadLt(Real2Str(m,0),2,' ')+'hr';
  End Else
    Time2Sec := PadLt(Int2Str(m),2,'0')+':'+PadLt(Int2Str(s),2,'0')
End;

Procedure GetLastCallers;
Var Ret	 : Boolean = False;
Var Fp	 : file;
Var Names: Array[1..10] Of String[30];
Var OneUser     : RecLastOn;
Var UserInfo : RecUser;
Var ii   : Byte;
Var Str  : String;
Begin
	fAssign(Fp,CallersFile,66);
	fReset(Fp);
  ii:=1;
	If IoResult = 0 Then Begin
		While Not fEof(fp) Do Begin
			fReadRec(Fp,OneUser);
      GetUserInfo(OneUser.Handle, UserInfo);
			GotoXY(2,4+ii);
      Str := '|07'+PadLt(Int2Str(OneUser.Node),1,'0');
      If UserInfo.Calls < NewUserCalls Then Str := Str + '*' Else Str := Str + ' ';
      Str := Str +  '|10' +PadRt(StripMCI(OneUser.Handle),15,' ') + '|06'+PadRt(Upper(StripMCI(OneUser.City)),24,' ') + '|01'+PadLt(DateStr(OneUser.DateTime1,1),10,' ');
      Str := Str + ' |13[';
      if UserInfo.DLsToday > 0  Then Str := Str + 'D' Else Str := Str + '-';
      if OneUser.UpFiles > 0  Then Str := Str + 'U' Else Str := Str + '-';
      if OneUser.PostsToday > 0  Then Str := Str + 'P' Else Str := Str + '-';
      If OneUser.Reserved[1] = 1 Then Str := Str + 'H' Else Str := Str + '-';
      If OneUser.Reserved[2] = 1 Then Str := Str + 'C' Else Str := Str + '-';

            
      Str := Str + ']';

      Str:= Str + ' |03' + Time2Sec(OneUser.ExitTime - OneUser.LoginTime)
      Write(Str);
      
      GotoXY(68,4+ii);
      Write('|04'+PadLt(Str2KB(OneUser.UpkFiles,True),5,' ') + ' '+ PadLt(Str2KB(UserInfo.DLkToday,True),5,' '))
      ii := ii + 1;
      
		End;
		fClose(Fp);
	End;  
End;

Procedure GetTotals;
Var Fp	 : file;
Var ii   : Integer;
Var User        : RecUser
TotalPosts : Integer;
TotalEmail : Integer;
TotalCalls : Integer;
TotalDL : Integer;
TotalUL : Integer;
TotalDLk : Integer;
TotalULk : Integer;
TotalDLs          : Word;                              // # of downloads
TotalDLsToday     : Word;                              // # of downloads today
TotalDLkToday     : LongInt;                                // # of downloaded K today
TotalULs          : LongInt;                                // total number of uploads
Begin
	fAssign(Fp,UsersFile,66);
	fReset(Fp);
  ii:=0;
	If IoResult = 0 Then Begin
		While Not fEof(fp) Do Begin
			fReadRec(Fp,User);
      TotalPosts:=TotalPosts+User.Posts;
      TotalEmail:=TotalEmail+User.Emails;
      
      TotalUL:=TotalUL+User.ULs;
      TotalDLk:=TotalDLk+User.DLk;
      TotalULk:=TotalULk+User.ULk;
      TotalCalls:=TotalCalls+User.Calls;
      TotalDLs      := TotalDLs + User.DLs;
      TotalDLsToday := TotalDLsToday + User.DLsToday;
      TotalDLkToday := TotalDLkToday + User.DLkToday
      TotalULs      := TotalULs + User.ULs;      
      
      ii := ii + 1;
    End;
		fClose(Fp);
	End;
  
  GotoXY(68,16);   Write('|04|17Users:|07'+PadLt(Int2Str(ii),5,' '));
  GotoXY(68,17);   Write('|04|17Posts:|07'+PadLt(Int2Str(TotalPosts),5,' '));
 (* GotoXY(20,22);  Write('|08Emails    :|07 '+PadLt(Int2Str(TotalEmail),5,' '));
  GotoXY(20,23); Write('|08Calls     :|07 '+PadLt(Int2Str(TotalCalls),5,' '));
  GotoXY(40,22);  Write('|08UP :|07 '+PadLt(Int2Str(TotalULs),5,' ')+'/'+PadLt(Str2KB(TotalULk,True),10,' '));
  
  
  GotoXY(60,23);  Write('|08DN :|07 '+PadLt(Int2Str(TotalDLs),5,' ')+ '/' +PadLt(Str2KB(TotalDLk,True),10,' '));
  GotoXY(60,22);  Write('|08DN :|07 '+PadLt(Int2Str(TotalDLsToday),5,' ')+'/'+PadLt(Str2KB(TotalDLkToday,True),10,' '));
  *)
End;

// Main Block
Begin
  
  If Graphics = 0 Then
    Begin
      WriteLn('|16|15No Graphics support. Exiting... |PA');
      Halt;
    End;
    
  Datapath := AddSlash(addslash(cfgmpepath)+'amicaller'+PathChar);
  
  ClrScr;
  DispFile(DataPath + 'lastcaller.ans');
  GetLastCallers;
  GetTotals;
  ReadDay;
  
  GotoXY(1,25);
  Pause;
  TextColor(0);
  //ClrScr;
  
End;
