#!/usr/bin/python

# TwitGram v0.1
# by Zarnock
# The Zone BBS - zonebbs.net

### To use, call '/path/to/twitgram.py "String to post." <arg>
### <arg> can be either /g for Telegram, /t for Twitter, or /b for both.
###
### &T can be put in the string to insert the time in HH:MM:SS format for
### Twitter but it will also prepend with " at" and append with "."
### In Telegram it will be replaced with a "." as there is no need to have
### time sent in Telegram as all the messages are time stamped anyway.
###
### Twitter: "Zarnock logged in&T" -> "Zarnock logged in at 12:34:56. <tags>"
### Telegram:"Zarnock logged in&T" -> "Zarnock logged in."
### Note there is no space ....^


###### This is the information for Telegram ######
bot_api = ''      #bot id here
user_id = ''      #user id numer bot will send messages to

###### This is the information for Twitter #######
consumer_key = ''
consumer_secret = ''
access_token = ''
access_token_secret = ''

# String of tags you want to append to Tweets set to "" for none.
tags = "#bbs #sysop #mysticbbs"





#############################################################################
#                       Do not edit below this point!                       #
#############################################################################

import telepot  #this is the Telegram API
import tweepy   #this is the Twitter API
import sys      #this is needed to send arguments
import datetime #needed for date/time display


# Check for correct command line call of twitgram.py, else exit w/ message.
if len(sys.argv) == 1:
    print "Usage: twitgram.py \"String goes here\" <arg>"
    print "/g = message is sent to Telegram"
    print "/t = message is sent to Twitter"
    print "/b = message is sent to both"
    sys.exit()
if len(sys.argv) == 2:
    print "You must provide an argument, either /g, /t, or /b."
    sys.exit()
else:
    message = sys.argv[1]   #message passed via call as string in arg1
    switch = sys.argv[2]    #switch is either /g /t or /b


# Send a Telegram message, and work &T replacement magic if needed.
def gram (message):
    bot = telepot.Bot(bot_api)

    if "&T" in message:
	message = message.replace("&T",".")
    bot.sendMessage(user_id, message)
    return

# Tweet a message, and work &T replacement magic if needed.
def tweet (message):
    auth = tweepy.OAuthHandler(consumer_key, consumer_secret)
    auth.set_access_token(access_token, access_token_secret)
    api = tweepy.API(auth)

    if "&T" in message:
        message = message.replace("&T", datetime.datetime.now().strftime(" at %H:%M:%S."))
    api.update_status(message + " " + tags)
    return


# Determine if going to Twitter, Telegram, or both then send message to
# appropriate function.  Technically any other argument would execute
# sending a message to both, and I'm ok with this.

if switch.endswith('/g'):
    gram(message)
elif switch.endswith('/t'):
    tweet(message)
else:
    gram(message)
    tweet(message)
