(*
   Copyright (c)2021 RCS Development Team <rcs@castlerockbbs.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.
   
   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   This MPL is inspired by:
   ZO-TPCAL.MPS : zTopCallers v2 by zoob
   (C) 1999 By Zoob.  All Rights Reserved.
 
   Program: RCS Top Callers
      Date: 05 Jan 2021
    Author: RCS Development Team
   Contact: RCS Development Team <rcs@castlerockbbs.com>
   
   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
 *)

Uses User

Const
  PROG_NAME = 'RCS Top Callers'
  PROG_VER  = '1.0'
  SYSOP_SL  = 200

// To change colors just change the numbers below. No pipe codes nor quotes.  
// If its 1-9, please make sure to add a 0 first, so 01-09. If you change the 
// color codes, you'll have to modify the ANSI key within the .ans file.  If 
// you do so, do so at your own risk and be sure to remove sauce and do not add
// pause or clear screens.  All pause and clear screens are built into the 
// code.
// Lastly, to install simply pick a menu to place it in with menu command:
// GX:  rcstpcal
// place script file within your scripts directory
// place all .ans files within your text directory
// this mode will auto detect the users terminal size and display the 
// appropriate version.

  C1        = 09        // 1st place "top dog"
  C2        = 10        // 2nd place 
  C3        = 12        // 3rd place
  C4        = 08        // 4th through 10th for 16:9 or 4th and 5th for 4:3.

// *** DO NOT EDIT ANYTHING BELOW THIS LINE!!! ***

Type
  CallRec = Record
  Alias   : String[30]
  NumCall : Integer
  Posts   : Integer
  DLs     : Integer
  ULs     : Integer
  PCRatio : Integer
  UDRatio : Integer
End

Var
  Count    : Integer
  Calls    : Array[1..1000] of CallRec
  UserCnt  : Integer

 
Procedure SortUsers(type:Char)
Var
  x,y,z,temp  : Integer=1
Begin
  z:=UserCnt
  temp:=UserCnt+1
  Case type Of
    'C' : Begin
            For x:=1 to UserCnt Do
            Begin
              For y:=1 to (UserCnt) Do
              Begin
                if Calls[x].NumCall > Calls[y].NumCall Then
                Begin
                  Calls[temp]:=Calls[x]
                  Calls[x]:=Calls[y]
                  Calls[y]:=Calls[temp]
                End
              End
            End
            Calls[temp].Alias:=''
            Calls[temp].NumCall:=0
          End
    'P' : Begin
            For x:=1 to UserCnt Do
            Begin
              For y:=1 to UserCnt Do
              Begin
                if Calls[x].Posts > Calls[y].Posts Then
                Begin
                  Calls[temp]:=Calls[x]
                  Calls[x]:=Calls[y]
                  Calls[y]:=Calls[temp]
                End
              End
            End
            Calls[temp].Alias:=''
            Calls[temp].Posts:=0
          End
    'U' : Begin
            For x:=1 to UserCnt Do
            Begin
              For y:=1 to UserCnt Do
              Begin
                if Calls[x].ULs > Calls[y].ULs Then
                Begin
                  Calls[temp]:=Calls[x]
                  Calls[x]:=Calls[y]
                  Calls[y]:=Calls[temp]
                End
              End
            End
            Calls[temp].Alias:=''
            Calls[temp].ULs:=0
          End
    'D' : Begin
            For x:=1 to UserCnt Do
            Begin
              For y:=1 to UserCnt Do
              Begin
                if Calls[x].DLs > Calls[y].DLs Then
                Begin
                  Calls[temp]:=Calls[x]
                  Calls[x]:=Calls[y]
                  Calls[y]:=Calls[temp]
                End
              End
            End
            Calls[temp].Alias:=''
            Calls[temp].DLs:=0
          End
    'R' : Begin
            For x:=1 to UserCnt Do
            Begin
              For y:=1 to UserCnt Do
              Begin
                if Calls[x].PCRatio > Calls[y].PCRatio Then
                Begin
                  Calls[temp]:=Calls[x]
                  Calls[x]:=Calls[y]
                  Calls[y]:=Calls[temp]
                End
              End
            End
            Calls[temp].Alias:=''
            Calls[temp].PCRatio:=0
          End
    'F' : Begin
            For x:=1 to UserCnt Do
            Begin
              For y:=1 to UserCnt Do
              Begin
                if Calls[x].UDRatio > Calls[y].UDRatio Then
                Begin
                  Calls[temp]:=Calls[x]
                  Calls[x]:=Calls[y]
                  Calls[y]:=Calls[temp]
                End
              End
            End
            Calls[Temp].Alias:=''
            Calls[Temp].UDRatio:=0
          End
  End
End


Procedure init
Begin
  PurgeInput
  write('|16')
  Count := 1
  While (GetUser(Count)) Do
  Begin
    If UserSec<SYSOP_SL Then
    Begin
      Calls[Count].Alias:=UserAlias
      Calls[Count].NumCall:=UserCalls
      Calls[Count].Posts:=UserPosts
      Calls[Count].DLs:=UserDL
      Calls[Count].ULs:=UserUL
      If Calls[Count].NumCall>0 Then
        Calls[Count].PCRatio:=(Calls[Count].Posts/Calls[Count].NumCall)*100
      Else Calls[Count].PCRatio:=0
      If Calls[Count].DLs>0 THen
        Calls[Count].UDRatio:=(Calls[Count].ULs/Calls[Count].DLs)*100
    End
    Count := Count + 1
  End
  UserCnt:=Count
End

Procedure DisplayCalls
Begin
  SortUsers('C')
  Count:=0
  Repeat
    Count:=Count+1
    if Count = 1 then
    begin
    WriteXY(6,7+Count,C1,Calls[Count].Alias)
    WriteXY(24,7+Count,C1,Int2Str(Calls[Count].NumCall))
    End
    else if Count = 2 then 
    begin
    WriteXY(6,7+Count,C2,Calls[Count].Alias)
    WriteXY(24,7+Count,C2,Int2Str(Calls[Count].NumCall))
    End
    else If Count = 3 then 
    Begin
    WriteXY(6,7+Count,C3,Calls[Count].Alias)
    WriteXY(24,7+Count,C3,Int2Str(Calls[Count].NumCall))
    End
    else
    Begin
    WriteXY(6,7+Count,C4,Calls[Count].Alias)
    WriteXY(24,7+Count,C4,Int2Str(Calls[Count].NumCall))
    End
  Until Count = 5
End

Procedure DisplayCalls132
Begin
  SortUsers('C')
  Count:=0
    gotoXY(1,8) 
    Repeat
    Count:=Count+1
    if Count = 1 then
    begin
    WriteXY(10,9+Count,C1,Calls[Count].Alias)
    WriteXY(30,9+Count,C1,Int2Str(Calls[Count].NumCall))
    end
    else if Count = 2 then 
    begin
    WriteXY(10,9+Count,C2,Calls[Count].Alias)
    WriteXY(30,9+Count,C2,Int2Str(Calls[Count].NumCall))
    End
    else If Count = 3 then 
    Begin
    WriteXY(10,9+Count,C3,Calls[Count].Alias)
    WriteXY(30,9+Count,C3,Int2Str(Calls[Count].NumCall))
    End
    else
    Begin
    WriteXY(10,9+Count,C4,Calls[Count].Alias)
    WriteXY(30,9+Count,C4,Int2Str(Calls[Count].NumCall))
    End
  Until Count = 10
End

Procedure DisplayPosts
Begin
  SortUsers('P')
  Count:=0
  Repeat 
    Count:=Count+1
    if Count = 1 then 
    begin
    WriteXY(31,7+Count,C1,Calls[Count].Alias)
    WriteXY(49,7+Count,C2,Int2Str(Calls[Count].Posts))
    end
    else if Count = 2 then 
    begin
    WriteXY(31,7+Count,C2,Calls[Count].Alias)
    WriteXY(49,7+Count,C2,Int2Str(Calls[Count].Posts))
    end
    else if Count = 3 then 
    begin
    WriteXY(31,7+Count,C3,Calls[Count].Alias)
    WriteXY(49,7+Count,C3,Int2Str(Calls[Count].Posts))
    End
    else
    Begin
    WriteXY(31,7+Count,C4,Calls[Count].Alias)
    WriteXY(49,7+Count,C4,Int2Str(Calls[Count].Posts))
    End
  Until Count = 5
End

Procedure DisplayPosts132
Begin
  SortUsers('P')
  Count:=0
  Repeat
    Count:=Count+1
    if Count = 1 then
    begin
    WriteXY(55,9+Count,C1,Calls[Count].Alias)
    WriteXY(75,9+Count,C1,Int2Str(Calls[Count].Posts))
    end
    else if Count = 2 then 
    begin
    WriteXY(55,9+Count,C2,Calls[Count].Alias)
    WriteXY(75,9+Count,C2,Int2Str(Calls[Count].Posts))
    end
    else if Count = 3 then 
    begin
    WriteXY(55,9+Count,C3,Calls[Count].Alias)
    WriteXY(75,9+Count,C3,Int2Str(Calls[Count].Posts))
    End
    else
    Begin
    WriteXY(55,9+Count,C4,Calls[Count].Alias)
    WriteXY(75,9+Count,C4,Int2Str(Calls[Count].Posts))
    End
  Until Count = 10
End

Procedure DisplayPCRatio
Begin
  SortUsers('R')
  Count:=0
  Repeat
    Count:=Count+1
    if Count = 1 then
    begin
    WriteXY(56,7+Count,C1,Calls[Count].Alias)
    WriteXY(73,7+Count,C1,Int2Str(Calls[Count].PCRatio))
    end
    else if Count = 2 then 
    begin
    WriteXY(56,7+Count,C2,Calls[Count].Alias)
    WriteXY(73,7+Count,C2,Int2Str(Calls[Count].PCRatio))
    end
    else if Count = 3 then 
    begin
    WriteXY(56,7+Count,C3,Calls[Count].Alias)
    WriteXY(73,7+Count,C3,Int2Str(Calls[Count].PCRatio))
    End
    else
    Begin
    WriteXY(56,7+Count,C4,Calls[Count].Alias)
    WriteXY(73,7+Count,C4,Int2Str(Calls[Count].PCRatio))
    End
  Until Count = 5
End

Procedure DisplayPCRatio132
Begin
  SortUsers('R')
  Count:=0
  Repeat
    Count:=Count+1
    if Count = 1 then
    begin
    WriteXY(95,9+Count,C1,Calls[Count].Alias)
    WriteXY(115,9+Count,C1,Int2Str(Calls[Count].PCRatio))
    end
    else if Count = 2 then 
    begin
    WriteXY(95,9+Count,C2,Calls[Count].Alias)
    WriteXY(115,9+Count,C2,Int2Str(Calls[Count].PCRatio))
    end
    else if Count = 3 then 
    begin
    WriteXY(95,9+Count,C3,Calls[Count].Alias)
    WriteXY(115,9+Count,C3,Int2Str(Calls[Count].PCRatio))
    End
    else
    Begin
    WriteXY(95,9+Count,C4,Calls[Count].Alias)
    WriteXY(115,9+Count,C4,Int2Str(Calls[Count].PCRatio))
    End
  Until Count = 10
End

Procedure DisplayULs
Begin
  SortUsers('U')
  Count:=0
  Repeat
    Count:=Count+1
    if Count = 1 then
    begin
    WriteXY(6,15+Count,C1,Calls[Count].Alias)
    WriteXY(24,15+Count,C1,Int2Str(Calls[Count].ULs))
    end
    else if Count = 2 then 
    begin
    WriteXY(6,15+Count,C2,Calls[Count].Alias)
    WriteXY(24,15+Count,C2,Int2Str(Calls[Count].ULs))
    End
    else If Count = 3 then 
    Begin
    WriteXY(6,15+Count,C3,Calls[Count].Alias)
    WriteXY(24,15+Count,C3,Int2Str(Calls[Count].ULs))
    End
    else
    Begin
    WriteXY(6,15+Count,C4,Calls[Count].Alias)
    WriteXY(24,15+Count,C4,Int2Str(Calls[Count].ULs))
    End
  Until Count = 5
End

Procedure DisplayULs132
Begin
  SortUsers('U')
  Count:=0
    gotoXY(1,22) 
    Repeat
    Count:=Count+1
    if Count = 1 then
    begin
    WriteXY(10,22+Count,C1,Calls[Count].Alias)
    WriteXY(30,22+Count,C1,Int2Str(Calls[Count].ULs))
    end
    else if Count = 2 then 
    begin
    WriteXY(10,22+Count,C2,Calls[Count].Alias)
    WriteXY(30,22+Count,C2,Int2Str(Calls[Count].ULs))
    End
    else If Count = 3 then 
    Begin
    WriteXY(10,22+Count,C3,Calls[Count].Alias)
    WriteXY(30,22+Count,C3,Int2Str(Calls[Count].ULs))
    End
    else
    Begin
    WriteXY(10,22+Count,C4,Calls[Count].Alias)
    WriteXY(30,22+Count,C4,Int2Str(Calls[Count].ULs))
    End
  Until Count = 10
End

Procedure DisplayDLs
Begin
  SortUsers('D')
  Count:=0
  Repeat
    Count:=Count+1
    if Count = 1 then
    begin 
    WriteXY(31,15+Count,C1,Calls[Count].Alias)
    WriteXY(48,15+Count,C1,Int2Str(Calls[Count].DLs))
    end
    else if Count = 2 then 
    begin
    WriteXY(31,15+Count,C2,Calls[Count].Alias)
    WriteXY(48,15+Count,C2,Int2Str(Calls[Count].DLs))
    End
    else If Count = 3 then 
    Begin
    WriteXY(31,15+Count,C3,Calls[Count].Alias)
    WriteXY(48,15+Count,C3,Int2Str(Calls[Count].DLs))
    End
    else
    Begin
    WriteXY(31,15+Count,C4,Calls[Count].Alias)
    WriteXY(48,15+Count,C4,Int2Str(Calls[Count].DLs))
    End
  Until Count = 5
End

Procedure DisplayDLs132
Begin
  SortUsers('D')
  Count:=0
  Repeat
    Count:=Count+1
    if Count = 1 then
    begin
    WriteXY(55,22+Count,C1,Calls[Count].Alias)
    WriteXY(75,22+Count,C1,Int2Str(Calls[Count].DLs))
    end
    else if Count = 2 then 
    begin
    WriteXY(55,22+Count,C2,Calls[Count].Alias)
    WriteXY(75,22+Count,C2,Int2Str(Calls[Count].DLs))
    End
    else If Count = 3 then 
    Begin
    WriteXY(55,22+Count,C3,Calls[Count].Alias)
    WriteXY(75,22+Count,C3,Int2Str(Calls[Count].DLs))
    End
    else
    Begin
    WriteXY(55,22+Count,C4,Calls[Count].Alias)
    WriteXY(75,22+Count,C4,Int2Str(Calls[Count].DLs))
    End
  Until Count = 10
End

Procedure DisplayUDRatio
Begin
  SortUsers('F')
  Count:=0
  Repeat
    Count:=Count+1
    if Count = 1 then
    begin
    WriteXY(56,15+Count,C1,Calls[Count].Alias)
    WriteXY(73,15+Count,C1,Int2Str(Calls[Count].UDRatio))
    end
    else if Count = 2 then 
    begin
    WriteXY(56,15+Count,C2,Calls[Count].Alias)
    WriteXY(73,15+Count,C2,Int2Str(Calls[Count].UDRatio))
    end
    else if Count = 3 then 
    begin
    WriteXY(56,15+Count,C3,Calls[Count].Alias)
    WriteXY(73,15+Count,C3,Int2Str(Calls[Count].UDRatio))
    End
    else
    Begin
    WriteXY(56,15+Count,C4,Calls[Count].Alias)
    WriteXY(73,15+Count,C4,Int2Str(Calls[Count].UDRatio))
    End
  Until Count = 5
End

Procedure DisplayUDRatio132
Begin
  SortUsers('F')
  Count:=0
  Repeat
    Count:=Count+1
    if Count = 1 then
    begin
    WriteXY(95,22+Count,C1,Calls[Count].Alias)
    WriteXY(115,22+Count,C1,Int2Str(Calls[Count].UDRatio))
    end
    else if Count = 2 then 
    begin
    WriteXY(95,22+Count,C2,Calls[Count].Alias)
    WriteXY(115,22+Count,C2,Int2Str(Calls[Count].UDRatio))
    end
    else if Count = 3 then 
    begin
    WriteXY(95,22+Count,C3,Calls[Count].Alias)
    WriteXY(115,22+Count,C3,Int2Str(Calls[Count].UDRatio))
    End
    else
    Begin
    WriteXY(95,22+Count,C4,Calls[Count].Alias)
    WriteXY(115,22+Count,C4,Int2Str(Calls[Count].UDRatio))
    End
  Until Count = 10
End

Begin
  init
  ClrScr
  dispfile('rcstopusers')
  write('[0;39 D');
  If TermSizeX=80 Then
  Begin
    DisplayCalls
    DisplayPosts
    DisplayPCRatio
    DisplayULs
    DisplayDLs
    DisplayUDRatio
    GotoXY(1,24)
  End
  Else If TermSizeX=132 Then
  Begin
    DisplayCalls132
    DisplayPosts132
    DisplayPCRatio132
    DisplayULs132
    DisplayDLs132
    DisplayUDRatio132
    GotoXy(1,36)
  End
  write('[0;0 D');
  WriteLn('|PA')
End
