(*                              RCS Callers
                     (c)2021 - RCS Development Team

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.
   
------------------------------------------------------------------------------

This has been a fun project!  Here's what this "thing" does.
1.  Displays last 10 callers and displays who's online, for up to 5 nodes,
    all on the same screen.
2.  Works in 4:3 and 16:9 (80x25 and 132x37 terminal modes)
3.  Colors can be customized at the top of the mod without digging through 
    the code.
4.  Includes "Security Level Descriptions" that you will want to change to
    whatever your BBS uses, or if you currently don't, nows time to add 
    some fun!  I put ridiculous examples in so you're sure to (hopefully)
    change them.
5.  Security level Descriptions can (mostly) be changed at the top of the code 
    without, again, digging through code.  However, there are two locations
    security number will need to be changed if they do not match what I've
    included.  The code has comments reflecting where and what line numbers
    to change.  It's two simple locations within the script.
 
------------------------------------------------------------------------------
Quick Installation instructions because you guys are champions and don't need 
------------------------------------------------------------------------------
1.  Copy rcsc.mps to your /mystic/themes/default/scripts directory.  Or where
    ever the heck your scripts. 
2.  Copy all ansi files to your /mystic/themes/default/text directory.  Or 
    whereever the heck your text.
    rcschead.ans and rcscfoot.ans are the 4:3 ansi header and footer 
        files.
    rcschead.c132.ans and rcscfoot.c132.ans are your 16:9 header and 
        footer files.
3.  Add where you like:  prelogin, who's online and/or last caller main menu, 
    or some odd ball place.  Nothing more then a simple 
    MenuCMD:  GX  
    Data   :  rcscal menu/data command
4.  To change colors, and security levels to match your BBS, please follow the 
    commented instructions within the MPL below.
5.  At times there can be a difference between Linux and Windows in how it 
    displays ANSI files.  You may need to make adjustments within an editor to 
    make it work for your BBS.
    The only file that is true ANSI is the header files, and the footer file 
    for c132.ans 16:9.  The ANSI file for 4:3 is ascii.
6.  If you choose to make an ASCII header and footer, you will need to add the 
    topez font within the header AND footer, and a codepage switch at the end 
    of the header.  This mod has the Topez and Code Page hard coded into the 
    mod so that it does not need added to any ANSI everytime you make changes.

*)


Uses CFG
Uses User

(*
  To change the security level name, do so below.  If your security level 
  numbers differ please keep the following in mind:
  
  First, delete those below you don't use if you use less.  
  You can then renumber the Sec## to whatever those are that you use.
  Just make sure that see comment on line 128.  
  Lines below 128 will need to match up.
  Nothing else should need to be customized other then your own ansi header 
    and footer.  
  Feel free to do more, just do so at your desire and risk, and share with the
    group what you added that's cool or different!
*)

Const
  Sec10='Newbie'
  Sec20='Regular User'
  Sec30='Not a Lame User'
  Sec50='Porn Lover User'
  Sec60='Visiting BBS SysOp'
  Sec70='Moderator of some area'
  Sec100='Visiting Sysop'
  Sec150='VIP Sysop'
  Sec200='Co-SysOp I'
  Sec250='Co-SysOp II'
  Sec255='SysGod!'

(*
To change the colors of the text below the header and above the footer, change them below 
*)

  Title='|20|15'   // are the titles of each column, i.e. Node, user, location, security level, date, time, call#
  TitleOff= '|16'  // Title off resets the background color back to black.  Shouldn't need to touch this at all.
  Bar='|08'    // is the color of the line before and after each title name
  C1='|09'     // C1-C7 are the columns of last callers 1-10, there are 7 total 
  C2='|11'
  C3='|03'
  C4='|09'
  C5='|03'
  C6='|03'
  C7='|07'
  C8='|09'     // C8-13 are the columes for who's online, there are 6 total.  C13 is the last column, *invisible* which will only appear if the user is invisible, and only visible to 
  C9='|11'         // security levels you've given access to view invisible users online.
  C10='|03'
  C11='|12'
  C12='|13'
  C13='|14' // 16:9 invisible text
  C14='|09' // 4:3 invisible text

Type   RecLastOn = Record                 // CALLERS.DAT
  MDateTime  : LongInt;
  NewUser    : Boolean;
  PeerIP     : String[15];
  PeerHost   : String[50];
  Node       : Byte;
  CallNum    : LongInt;
  Handle     : String[30];
  City       : String[25];
  Address    : String[30];
  Gender     : Char;
  EmailAddr  : String[35];
  RUserInfo  : String[30];
  OptionData : Array[1..10] of String[60];
  Reserved   : Array[1..53] of Byte;
End;

Type  UserRecord = Record
  Active     :Boolean
  Name       :String[30]
  Action     :String[40]
  Location   :String[30]
  Gender2    :Char
  Age        :Byte
  Baud       :String[6]
  Invisible  :Boolean
  Available  :Boolean
  InChat     :Boolean
  Room       :Byte
  Paged      :Boolean
  ServType   :Byte
  ServerSlot :Integer
  ClienSlot  :Integer
  Updated    :LongInt
  ProcessID  :LongInt
End;

Var
  Callersdat :String
  Call       :array[1..10] of RecLastOn
  maxnodes   :Byte
  loop       :Byte
  Fptr       :File
  Listnodes  :UserRecord
  Path       :String[50]
  syslevel   :Byte=200 
  TimeStart  :LongInt

Procedure CheckTimeOut
Begin
  If CfgTimeOut>0 Then
  Begin
    If Timer-TimeStart>CfgTimeOut Then
    Begin
      WriteLn(GetPrompt(136))
      Write('|[1')
      HangUp
    End
  End
End

Function ReadCallersDat:Boolean
Var
  Ret   : Boolean = False
  counter:Byte=1
Begin
  Callersdat:=CFGDataPath+'callers.dat'
  fAssign(Fptr,Callersdat,66)
  fReset(Fptr)
  If IOResult = 0 Then Begin
    For counter:=1 to 10 do
    Begin
      If Not fEof(Fptr) Then
        fReadRec(Fptr,Call[counter])
    End
    Ret:=True
    fClose(Fptr)
  End
  ReadCallersdat:=Ret
End

Procedure progexit
Begin
  Write('|[1')
  Halt
End

Procedure Init
Begin
  PurgeInput
  if (ReadCallersDat=false) then progexit
End

Function SecurityDesc(handle:string):string
Var
  count  : integer=1
  Result : String
Begin
  While GetUser(count) do
  Begin
    If UserAlias=handle Then
    Begin

//  Whatever your security level numbers are in mystic config, must match up below.  So if you use 10, 20, 40, and 80, then below needs to reflec those numbers instead of 10, 20, 30, 50, etc..
//  Result:=Sec## should match.  So if you have a SL40, one of the below needs to be 40  : Result:=Sec40

      Case UserSec of
        10  : Result:=Sec10
        20  : Result:=Sec20
        30  : Result:=Sec30
        50  : Result:=Sec50
        60  : Result:=Sec60
        70  : Result:=Sec70
       100  : Result:=Sec100
       150  : Result:=Sec150
       200  : Result:=Sec200
       250  : Result:=Sec250
       255  : Result:=Sec255
      End
    End
    count:=count+1
  End
  SecurityDesc:=Result
End

Procedure LastCallers
Var count : integer = 1
Y   : byte
Begin
  dispfile('rcschead')
  Y:=WhereY
  write('[0;40 D');
  If TermSizeX = 132 then
  Begin
    gotoxy(1,Y); 
    WriteLn('|CR'+Bar+'--'+Title+'Node'+TitleOff+Bar+'------'+Title+'Last Callers'+TitleOff+Bar+'----------'+Title+'Location'+TitleOff+Bar+'-------------------'+Title+'Security Level'+TitleOff+Bar+'-----------------'+Title+'Date'+TitleOff+Bar+'---------'+Title+'Time'+TitleOff+Bar+'---------'+Title+'Call#'+TitleOff+Bar+'--')
    for count:=1 to 10 do              
    Begin
      GotoXY(1,Y+1+count)
      WriteLn('  '+C1+Int2Str(Call[count].Node)+'         '+C2+PadRt(Call[count].Handle,22,' ')+C3+PadRt(Call[count].City,25,' ')+'  '+C4+PadRt(SecurityDesc(Call[count].handle),30,' ')+' '+C5+DateSTR(Call[count].MDateTime,1)+'     '+C6+TimeStr(Call[count].MDateTime,False)+'        '+C7+Int2Str(Call[count].CallNum))
    End
    gotoxy(1,Y+13); 
    WriteLn(Bar+'--'+Title+'Node'+TitleOff+Bar+'------'+Title+'Who''s Online'+TitleOff+Bar+'----------'+Title+'Location'+TitleOff+Bar+'-------------------'+Title+'Mafia Rank'+TitleOff+Bar+'---------------------'+Title+'Action'+TitleOff+Bar+'---------------------------')
  End
  Else
  Begin
    gotoxy(1,Y+1);
    WriteLn(Title+'  Last Callers  '+TitleOff+Bar+'---------'+Title+' Node '+TitleOff+Bar+'------'+Title+'  Location  '+TitleOff+Bar+'----------'+Title+'  Date  '+TitleOff+Bar+'----'+Title+'  Time  '+TitleOff)
    //gotoxy(1,Y+7);
    for count:=1 to 10 do
      WriteLn('  '+C2+PadRt(Call[count].Handle,25,' ')+C1+Int2Str(Call[count].Node)+'         '+C3+PadRt(Call[count].City,21,'  ')+C4+' '+DateSTR(Call[count].MDateTime,1)+'     '+C5+TimeStr(Call[count].MDateTime,False))
    gotoxy(1,Y+12);
    WriteLn(Title+'  Who''s Online  '+TitleOff+Bar+'---------'+Title+' Node '+TitleOff+Bar+'------'+Title+'   Action    '+TitleOff+Bar+'--------'+Title+' Chat Status '+TitleOff+Bar+'--------')
  End
End

Function FindMaxNodes():Byte
Begin
  maxnodes := CFGTNNODES
End

Procedure Read(node:Byte):Boolean
Begin
  Read:=False
  Path:=CfgDataPath+'chat'+Int2Str(node)+'.dat'
  if fileExist(Path) then
  Begin
    fAssign(Fptr,Path,66)
    fReset(Fptr)
    If IOResult = 0 then 
    Begin
      fReadRec(Fptr,Listnodes)
  // This causes security level under who's on to dissapear   Listnodes.Name:='|11'+Listnodes.Name
      fClose(Fptr)
      if (not Listnodes.Active) or (not Listnodes.Available) or (Listnodes.Invisible) then
      Begin
        if UserSec < syslevel then
          Begin
            Listnodes.Name:='|09Waiting for caller...'
            Listnodes.Action:=''
            Listnodes.Location:=''
          End
      End
      Read:=True
    End
    Else If IOResult <> 0 then
    Begin
      Listnodes.Name:='|09Waiting for caller...'
      Listnodes.Action:=''
      Listnodes.Location:=''
      Read:=False
    End
  End
End

Procedure ListPrint132
Var
  x :Byte
  y :Byte
Begin
  x:=3
  y:=WhereY
  maxnodes := 10 
  gotoxy(x,y)
  For loop:=1 to maxnodes do
  Begin
    If Read(loop)=True then
    Begin
      if (not Listnodes.Active) or (not Listnodes.Available) or (Listnodes.Invisible) then
      Begin
        if UserSec<=syslevel then
          Begin
            Listnodes.Name:='|09Waiting for caller...'
            Listnodes.Action:=''
            Listnodes.Location:=''
          End
      End
    End
    Else If Read(loop)=False then
    Begin
      Listnodes.Name:='|09Waiting for caller...'
      Listnodes.Action:=''
      Listnodes.Location:=''
    End
    write(C8+'|[X03'+int2str(loop)+C9+'|[X13'+Listnodes.Name+C10+'|[X34 '+Listnodes.Location+C11+'|[X62'+SecurityDesc(Listnodes.Name)+C12+'|[X93'+Listnodes.Action)
    GetThisUser
    if (Listnodes.Invisible) and (Listnodes.Name<>'|09Waiting for caller...') and (UserSec>=syslevel) then write(C13+'|[X112*Invisible*')
    Else If Listnodes.Available and (Listnodes.Name<>'|09Waiting for caller...') Then Write(C13+'|[X112Available')
    Else If Listnodes.Available=False and (Listnodes.Name<>'|09Waiting for caller...') Then Write(C13+'|[X112Not Available')
    gotoxy(x,y+loop)
  End 
End

Procedure ListPrint43
var
  x :Byte
  y :Byte
begin
  x:=1
  y:=WhereY
  maxnodes := 5
  gotoxy(x,y)
  For loop:=1 to maxnodes do 
  Begin
    If Read(loop)=True then
    Begin
      if (not(Listnodes.Active) or not(Listnodes.Available) or (Listnodes.Invisible)) then
      Begin
        if UserSec<=syslevel then
          Begin
            Listnodes.Name:='|09Waiting for caller...'
            Listnodes.Action:=''
          End
      End
    End
    If Read(loop)=False then
    Begin
      Listnodes.Name:='|09Waiting for caller...'
      Listnodes.Action:='' 
    End
    write(C9+'|[X03'+Listnodes.Name+C8+'|[X28'+int2str(loop)+C10+'      |[X38'+Listnodes.Action)
    if Listnodes.Invisible and Listnodes.Name<>'|09Waiting for caller...' and UserSec>=syslevel then write(C14+'|[X60*Invisible*')
    Else If Listnodes.Available and (Listnodes.Name<>'|09Waiting for caller...') Then Write(C14+'|[X60Available')
    Else If Listnodes.Available=False and (Listnodes.Name<>'|09Waiting for caller...') Then Write(C14+'|[X60Not Available')
    gotoxy(x,y+loop)
  End
End  

Procedure Sparkle
Var
  X,Y,A    : Byte
  X1,Y1,A1 : Byte
  Ch       : Char
  Ch1      : Char
 Begin
  X:=Random(TermSizeX)
  X1:=Random(TermSizeX)
  Y:=Random(TermSizeY)
  Y1:=Random(TermSizeY)
  Ch:=GetCharXY(X,Y)
  Ch1:=GetCharXY(X1,Y1)
  A:=GetAttrXY(X,Y)
  A1:=GetAttrXY(X1,Y1)
  WriteXY(X,Y,15,Ch)
  WriteXY(X1,Y1,15,Ch1)
  GotoXY(1,TermSizeY)
  Delay(150)
  WriteXY(X,Y,A,Ch)
  WriteXY(X1,Y1,A1,Ch1)
  GotoXy(1,TermSizeY)
  Delay(100)
End

Begin
  getThisUser   
  TimeStart:=Timer
  ClrScr
  Init
  LastCallers
  FindMaxNodes()
  GetThisUser
  if TermSizeX=132 Then
    ListPrint132
  else
    ListPrint43
  write('[0;0 D');
  dispfile('rcscfoot')
  GotoXY(1,TermSizeY)
  Write('|[0')
  Repeat
    //Sparkle
    Delay(100)
    CheckTimeOut
  Until Keypressed
  progexit
End
