(*
   RCS ATM Time Bank 
   
   Copyright 2020 RCS Development Team <rcs@castlerockbbs.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.
*)

(*
2020-11-07  Black Panther(RCS)  <dan@castlerockbbs.com>

 * Fixed a few minor bugs
 * Added second PIN number confirmation entry

2020-12-09  RCS Development Team  <rcs@castlerockbbs.com>

 * Added support for 132x37 screen size

*)


Uses User
Uses Cfg

Const
  PROG_NAME = 'RCS Time Bank ATM'
  PROG_VER  = '1.3'

Type UserInfoDat = Record
  user : String[30]
  pin  : String[7]
End

Var
  User    : UserInfoDat
  datfile : String=JustPath(ProgName)+'rcstime.dat'
  Count   : Byte=1
  ScrSize : Byte
  
Procedure CenterText(text:String;y:byte)
Begin
  GotoXY(1,y)
  Write(PadCT(text,ScrSize,' '))
End

Procedure FatalEnd
Var
  temp   : String
Begin
  write('|03')
  CenterText('Sorry, your PIN number is incorrect',16)
  temp:=PROG_NAME+' v'+PROG_VER+'  '
  CenterText(temp,20)
  GotoXY(1,23)
  Delay(1500)
  Halt
End

Procedure BankEnd
Var
  temp  : String
Begin
  write('|03')
  temp:=StrMci('Thank you for using |BN Time Bank')
  CenterText(temp,18)
  temp:=PROG_NAME+' v'+PROG_VER+'  '
  CenterText(temp,20)
  GotoXY(1,23)
  Delay(1500)
  Halt
End

Function CheckUserPin(pin:String):Boolean
Var
  fptr    : File
  Result  : Boolean=False
Begin
  fAssign(fptr,datfile,66)
  fReset(fptr)
  If IOResult = 0 Then
  Begin
    While not fEof(fptr) Do
    Begin
      fReadRec(fptr,User)
      If Upper(User.user)=Upper(UserAlias) Then 
      Begin
        If User.pin=pin Then
        Begin
          Result:=True
          Break
        End
      End
    End
    fClose(fptr)
  End
  CheckUserPin:=Result
End

Function GetUserData:Boolean
Var
  fptr   : File
  Result : Boolean=False
Begin
  fAssign(fptr,datfile,66)
  If FileExist(datfile) Then fReset(fptr)
    Else fReWrite(fptr)
  If IOResult = 0 Then
  Begin
    While not fEof(fptr) Do
    Begin
      fReadRec(fptr,User)
      If Upper(User.user)=Upper(UserAlias) Then 
      Begin
        Result:=True
        Break
      End
    End
    fClose(fptr)
  End
  GetUserData:=Result
End

Procedure SaveUser(Userpin:String)
Var
  fptr   : File
  Found  : Boolean=False
Begin
  fAssign(fptr,datfile,66)
  fReset(fptr)
  If IOResult = 0 Then
  Begin
    While not fEof(fptr) Do
    Begin
      fReadRec(fptr,User)
      If Upper(User.user)=Upper(UserAlias) Then
      Begin
        User.User:=UserAlias
        User.pin:=Userpin
        fSeek(fptr,-SizeOf(User))
        fWriteRec(fptr,User)
        Found:=True
      End
    End
    If not Found Then
    Begin
      User.User:=UserAlias
      User.pin:=Userpin
      fWriteRec(fptr,User)
    End
    fClose(fptr)
  End
End

Procedure GetUserPin
Var
  Userpin  : String
Begin
  Repeat
    ClrScr
    DispFile('time')
    CenterText('|03',8)
    CenterText('Please enter the PIN to associate with your account.',9)
    CenterText('PIN numbers must be between 4 and 6 digits in length.',10)
    GotoXY((ScrSize/2)-2,12)
    UserPin:=Input(6,6,20,'')
  Until Length(UserPin)>3
  CenterText('|03',13)
  CenterText('Please enter your PIN number again for security.',13)
  GotoXY((ScrSize/2)-2,14)
  If (Upper(UserPin)=Input(6,6,16,'')) Then SaveUser(Userpin)
  Else FatalEnd
End

Procedure AccountBal
Begin
  ClrScr
  DispFile('time')
  CenterText('|03',8)
  CenterText('Your current account balance',9)
  CenterText('|TB Minute(s)',11)
  CenterText('Your maximum account balance',13)
  CenterText('|SB Minute(s)',15)
  GotoXY(1,23)
  ReadKey
End

Procedure DepositTime
Var
  Ch    : Char
Begin
  ClrScr
  DispFile('time')
  CenterText('|03',8)
  CenterText('Your current account balance',9)
  CenterText('|TB Minute(s)',11)
  CenterText('Your maximum account balance',13)
  CenterText('|SB minute(s)',15)
  CenterText('Would you like to deposit time into your account? (Y/N)',17)
  GotoXY(1,19)
  Ch:=Upper(ReadKey)
  If Ch='Y' then MenuCmd('TD','')
  AccountBal
End

Procedure WithDrawTime
Var
  Ch    : Char
Begin
  ClrScr
  DispFile('time')
  CenterText('|03',8)
  CenterText('Your current account balance',9)
  CenterText('|TB Minute(s)',11)
  CenterText('Your maximum account balance',13)
  CenterText('|SB minute(s)',15)
  CenterText('Would you like to withdraw time from your account? (Y/N)',17)
  GotoXY(1,19)
  Ch:=Upper(ReadKey)
  If Ch='Y' then MenuCmd('TW','')
  AccountBal
End

Procedure MainMenu
Var
  Ch   : Char
  Keys : String='ADWCQ'
Begin
  Repeat
    ClrScr
    DispFile('time')
    CenterText('|03',8)
    CenterText(StrMci('Welcome to |BN Time Bank'),9)
    CenterText('What can we help you with today?',11)
    CenterText(' A - Account Balance  ',13)
    CenterText(' D - Deposit Time     ',14)
    CenterText(' W - Withdraw Time    ',15)
    CenterText(' C - Change PIN number',16)
    CenterText(' Q - Quit             ',17)
    GotoXY(1,24)
    Ch:=OneKey(Keys,False)
    Case Ch of
      'A': AccountBal
      'D': DepositTime
      'W': WithDrawTime
      'C': GetUserPin
      'Q': BankEnd
    End
  Until Ch='Q'
End

Function PinEntry:Boolean
Begin
  ClrScr
  DispFile('time')
  CenterText('|03',8)
  CenterText(StrMci('Welcome to |BN Time Bank'),9)
  CenterText('Please enter your PIN number',11)
  GotoXY((ScrSize/2)-2,13)
  If (not CheckUserPin(Input(6,6,16,''))) Then
  Begin
    If Count>=3 Then FatalEnd
    Else
    Begin
      Count:=Count+1
      PinEntry
    End
  End
  Else MainMenu
End

Begin
  GetThisUser
  ClrScr
  ScrSize:=TermSizeX
  DispFile('time')
  CenterText('|03',8)
  If not GetUserData Then GetUserPin
  PinEntry
End.
