(*
   RCS One Liners
    
   Copyright 2020 Black Panther(RCS) <dan@castlerockbbs.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.

*)
   
(*
 ---------------------------------------------------------------------------
 zOneliners (C) 1999 By Zoob.  All Rights Reserved.
 RCS Oneliners (C) 2020 By Black Panther(RCS).  All Rights Reserved.
 ---------------------------------------------------------------------------
 Feel free to modify this, but give credit to me if you release it.
 ---------------------------------------------------------------------------
 Updated by Black Panther(RCS) to use with Mystic v1.12A46+
*)

uses cfg
uses user

Const
  PROG_NAME = 'RCS One Liners'
  PROG_VER  = '4.3(RCS)'
  PROG_AUTH = 'Black Panther'

var
  Twriters  :array[1..10] of string
  Toneliner :array[1..10] of string
  S         :string
  Foneline  :string
  C1        :string
  C2        :string
  Count     :byte
  Count2    :byte
  fptr      :file

Procedure show
Var
  temp   : String
Begin
  clrscr
  dispFile('oneliner')
  writeln(' ')
  WriteLn(StrMci('               |09'+PROG_NAME+' |03v|09'+PROG_VER+' |09b|03y |09B|03lack Panther|01(|09R|03CS|01)'))
  writeln(' ')
  For Count := 1 To 10 do
  Begin
    write  (c1+'('+c2)
    write  (padRT(Twriters[count], 13, ' '))
    write  (c1+') - '+c2)
    writeln(padRT(Toneliner[count], 60, ' '))
  End
  write ('|CR')
End

procedure init
Begin
  Case Upper(ParamStr(1)) of
    'BLUE'   : 
      Begin
        c1 :='|01'
        c2 :='|03'
      End
    'GREEN'  :
      Begin
        c1 :='|02'
        c2 :='|10'
      End
    'CYAN'   :
      Begin
        c1 :='|03'
        c2 :='|11'
      End
    'RED'    :
      Begin
        c1 :='|04'
        c2 :='|12'
      End
    'MAGENTA':  
      Begin
        c1 :='|05'
        c2 :='|13'
      End
    'YELLOW' :
      Begin
        c1 :='|06'
        c2 :='|14'
      End
    'GREY'   :
      Begin
        c1 :='|07'
        c2 :='|15'
      End
  Else
      Begin
        c1 :='|01'
        c2 :='|09'
      End 

GetThisUser
Foneline := CfgMPEPath+'rcs1line.lst'
if not fileExist(fOneLine) then
Begin
  fAssign(fptr,fOneLine,66)
  fReWrite(fptr)
  For count := 1 To 10 do
  Begin
    fWriteLn(fptr, '|11'+PROG_AUTH)
    fWriteLn(fptr, PROG_NAME+' v'+PROG_VER)
  End
End
fClose(fptr)
fAssign(fptr,Foneline,66)
fReset(fptr)
For Count := 1 To 10 do
Begin
  fReadLn(fptr, Twriters[count])
  fReadLn(fptr, Toneliner[count])
End
fClose(fptr)
End

Begin
init
Show
If InputNY('|09W|03ould |09y|03ou |09l|03ike |09t|03o |09a|03dd |09a o|03neliner? ')=false then halt
  WriteLn('|CR|09E|03nter |09y|03our |09t|03ext |09h|03ere.  |09P|03ress |11Enter |09t|03o |09a|03bort.')
  Write  (C1+':')
  s := Input(60, 60, 11, '')
  If s = '' then 
  Begin
    WriteLn(c2+'|09a|03borted')
    Halt
  End
  For Count := 1 To 9 do
  Begin
    Count2 := Count + 1
    Twriters[count]  := Twriters[count2]
    Toneliner[count] := Toneliner[count2]
  end
  tWriters[10]  := userAlias
  tOneliner[10] := S
  fAssign(fptr,Foneline,66)
  fReWrite(fptr)
  For Count := 1 To 10 do
  Begin
    fWriteLn(fptr, tWriters[count])
    fWriteLn(fptr, tOneliner[count])
  End
  fClose(fptr)
  Show
  Write('|PA')
End
