# .-------------------------.
# | GO-NMSG.MPS : RELEASE 2 |------------------------------------------------
# `-------------------------'
#  
#  This mod is written for use with Mystic BBS v1.07 under all platforms.
#
#  You may modify this program for your own personal use.  You are *NOT*
#  granted permission to distribute this file in any type of modified form.
#  You may not use this source code as a base for any mods you plan to
#  release. If you feel you've made changes which are beneficial, e-mail me
#  and I will consider either adding them or giving you permission to release
#  your modified version.  As long as this goes well, I will continue to
#  write and distribute most of my MPL addons that i've written with full
#  source code.
#
#  You can contact me at mysticbbs@geocities.com
# ---------------------------------------------------------------------------

Uses CFG
Uses USER

Const
  StartStr = '|CR|14Sending account info to SysOp ... ',
  EndStr   = 'Done.'

Var
  SysopMsg  Boolean,
  UserMsg   Boolean,
  SysopName String,
  ToUser    String,
  A         Byte,
  TempFile  String

Begin
  If ParamCount < 2 Then
    WriteLn ('|CRGO-NMSG ERROR: Invalid command line options.')
    Halt
  EndIf

  GetCFG
  GetThisUser

  ToUser := UserAlias

  While Pos(' ', ToUser) > 0
    A := Pos(' ', ToUser)
    Delete (ToUser, A, 1)
    Insert ('_', ToUser, A)
  Wend

  SysopMsg  := False
  UserMsg   := False
  SysopName := ParamStr(1)

  For A := 2 to ParamCount
    If Pos('/S', Upper(ParamStr(A))) > 0 Then
      SysopMsg  := True
    ElseIf Pos('/U', Upper(ParamStr(A))) > 0 Then
      UserMsg := True
    EndIf
  Fend

  Write (StartStr)

  If SysopMsg Then
    TempFile := CfgSysPath + 'temp' + Int2Str(NodeNum) + PathChar + 'go-nmsg.tmp'

    fOpen    (1, Text, ReWrite, TempFile)
    fWriteLn (1, 'New user account created on ' + DateStr(DateTime, 1) + ' at ' + TimeStr(DateTime, 1))
    fWriteLn (1, '')
    fWriteLn (1, 'New user handle    -> ' + UserAlias)
    fWriteLn (1, 'New user real name -> ' + UserName)
    fWriteLn (1, 'New user location  -> ' + UserCity)
    fClose   (1)

    MenuCmd ('D-', CfgSysPath + 'mbbspost 0 ' + SysopName + ' ' + SysopName + ' New_user_account ' + TempFile)
    fErase  (TempFile)
  EndIf

  If UserMsg Then
    MenuCmd ('D-', CfgSysPath + 'mbbspost 0 ' + SysopName + ' ' + ToUser + ' Welcome ' + CfgTextPath + 'welcome.msg')
  EndIf

  WriteLn (EndStr)
End
