#!/usr/bin/env python3

import sys
from collections import defaultdict

# todo
# interval based summary
# tall vs wide vs super wide output

def help():
    print("flatten.py input.csv")
    print("turns any rtl_power csv into a more compact summary")
    sys.exit()

if len(sys.argv) <= 1:
    help()

if len(sys.argv) > 2:
    help()

path = sys.argv[1]

sums = defaultdict(float)
counts = defaultdict(int)



def rep(s, m):
    a, b = divmod(m, len(s))
    return s * a + s[:b]

def frange(start, stop, step):
    i = 0
    f = start
    while f <= stop:
        f = start + step*i
        yield f
        i += 1

for line in open(path):
    line = line.strip().split(', ')
    low = int(line[2])
    high = int(line[3])
    step = float(line[4])
    weight = int(line[5])
    dbm = [float(d) for d in line[6:]]
    for f,d in zip(frange(low, high, step), dbm):
        sums[f] += d*weight
        counts[f] += weight

ave = defaultdict(float)
for f in sums:
    ave[f] = sums[f] / counts[f]

print("|15Frequency      db")
for f in sorted(ave):
    print(' '.join(["|07{:.2f}".format(f), "|08{:.2f}".format(abs(ave[f]))]), "|07 ",rep("#",int(60 - abs(60 * ave[f] / 100))), sep="")
    #print("{:.2f}".format(f), "{:.2f}".format(abs(ave[f])))
    
