(*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.



  Author          : xqtr
  Date            : 17/01/2017
  Description     : A frontend to use RTLSDR with Mystic BBS 
  Version         : 1.0
  Usage           : xq-sdr
  
  Notes    
  * Needs RTLSDR Software Installed
  * SOX
  * Python3
  * Linux/RPi Compatible
   
*)


Uses cfg;
Uses User;

Const
  max_list  = 20;
  searchx   = 28;
  searchy   = 15;
  searchcol = '|09|17';
  morecol   = '|09|17';


Var TotalAreas: byte;
Var Temp      : byte;
Var Temp2     : byte; 
Var Area      : array[1..max_list] of String;
Var url       : array[1..max_list] of String;
Var options   : array[1..max_list] of String;
Var Idx       : Array[1..max_list] of byte;
Var TopPage   : byte;
Var BarPos    : byte;
Var Done      : Boolean;
Var Ch        : Char;
Var Ch2       : Char;
Var More      : byte;
Var LastMore  : byte;
Var IniFile		: String;
Var baronc    : string;
Var baroffc   : string;
Var command   : string;
Var optionsc  : string;
var search    : string;
var search_idx: integer;
var ii        : integer;
var Datapath 	: string;
var TmpStr    : String;


//Display a nice box, based on BBS theme
Procedure XWindow(H1:String;T,X1,Y1,X2,Y2:Integer);
  Var T1,A1,A2,B1,B2  : String;
Begin
  A1:=Int2Str(X1);
  A2:=Int2Str(X2);
  B1:=Int2Str(Y1);
  B2:=Int2Str(Y2);
  T1:=Int2Str(T);
  Write('|#X#'+T1+'#'+H1+'#'+A1+'#'+B1+'#'+A2+'#'+B2+'#');
End;

//Read Configuration File
Procedure ReadIni;
Var Fptr	: File;
VAr Tag,Opt,S			: String;
var i:integer;
Begin
	If FileExist(IniFile) Then Begin
		fAssign(Fptr,IniFile,66);
		fReset(Fptr);
		While Not fEof(Fptr) Do Begin
			fReadLn(Fptr,S);
			Tag:=Upper(WordGet(1,S,'~'));
			Opt:=WordGet(2,S,'~');
			Case Tag Of
				'BARON' : baronc:=opt;
				'BAROFF' : baroffc:=opt;
				'COMMAND' : command:=opt;
				'TOTAL_ITEMS' : totalareas := Str2Int(Opt);
			End;
		End;
		fClose(Fptr);
		fAssign(Fptr,IniFile,66);
		fReset(Fptr);
		i:=1;
		While Not fEof(Fptr) Do Begin
			fReadLn(Fptr,S);
			Tag:=Upper(WordGet(1,S,'~'));
			Opt:=WordGet(2,S,'~');
			Case Tag Of
				'DESCRIPTION'+int2str(i) : area[i]:=opt;
				'CMD'+int2str(i) : url[i]:=opt;
				'OPTIONS'+int2str(i) : begin
											options[i]:=opt;
											i:=i+1;
										End;
			End;
		end	;
		fClose(Fptr);
	End;
End;

Procedure BarON;
begin
  GotoXY (27, 7 + BarPos - TopPage);
  Write (baronc +Chr(240)+ ' '+ PadRT(StripMCI(Area[BarPos]), 32, ' ') + '|02');
End;

Procedure BarOFF
begin
  GotoXY (27, 7 + BarPos - TopPage);
  Write (baroffc +'  '+ PadRT(Area[BarPos], 32, ' '));
  Write (StrREP(' ', 61 - WhereX));
End;

Procedure Center(s:string; line:byte);
begin
  GotoXY(40-(length(stripmci(s)) / 2),line);
  Write(s);
End;

Procedure DrawPage;
begin
  Temp2 := BarPos;
  For Temp := 0 to 8 Do Begin 
    BarPos := TopPage + Temp;
    BarOFF;
  End;
  BarPos := Temp2;
  BarON;
  GotoXY(searchx,searchy);
  Write(search);
End;

Procedure MainScreen;
begin
  TextColor(15);
  ClrScr;
  DataPath := JustPath(ProgName)+ AddSlash('xq-sdr');
  DispFile(DataPath +'bg.ans');
  GotoXY(35,23);
  Write('|11|17Press CTRL-Z for Help');
End;

Procedure HelpScreen;
begin
  ClrScr;
  BufFlush;
  DataPath := JustPath(ProgName)+ AddSlash('xq-sdr');
  xwindow(' Keys ',1,20,7,60,17);
  GotoXY(22,8);
  Write('|15CTRL-A    : |11Search Again');
  GotoXY(22,9);
  Write('|15CTRL-Y    : |11Clear Search');
  GotoXY(22,10);
  Write('|15Enter     : |11Select');
  GotoXY(22,11);
  Write('|15End       : |11Bottom List');
  GotoXY(22,12);
  Write('|15Home      : |11Top List');
  GotoXY(22,13);
  Write('|15Up/Down   : |11Move Selection');
  GotoXY(22,14);
  Write('|15Escape    : |11Abort / Go Back');
  GotoXY(22,15);
  Write('|15Any Key   : |11Search List');
  Center('|11|17Frequency Format as in rtl_power. Ex: 137M, 128k, 144500000 etc.',20);
  Center(searchcol+'Press Any Key to Continue...|PN',24);
  BufFlush;
  MainScreen;
  DrawPage;
End;

//Main Loop

Begin
//No ANSI? Then Exit
If Graphics = 0 Then Begin
  WriteLn('|16|15No Graphics support. Exiting... |PA');
  Halt;
End;

//Read Settings File
IniFile:=JustPath(ProgName)+AddSlash('xq-sdr')+'xq-sdr.ini';
ReadIni;
  
GetThisUser;
MainScreen;

//Init Variables
TopPage  := 1;
BarPos   := 1;
Done     := False;
More     := 0;
LastMore := 0;
search:='';
search_idx:=0;

DrawPage;

//Check Keypressed, Draw Menu and react to keypresses
Repeat
  More := 0;
  Ch   := ' ';
  Ch2  := ' ';
  

  If TopPage > 1 Then Begin
    More := 1;
    Ch   := Chr(244);
  End;

  If TopPage + 8 < TotalAreas Then Begin
    Ch2  := Chr(245);
    More := More + 2;
  End;

  If More <> LastMore Then Begin
    LastMore := More;
    GotoXY (37, 6);
    Write (morecol+' (' + Ch + Ch2 + ' more) ');
  End;

  Ch := ReadKey;
  If IsArrow Then Begin
    
    //HOME key
    if ch = chr(71) Then Begin
      Search_idx:=1;
      TopPage := 1;
      BarPos  := 1;
      DrawPage;
    End;
    
    //END Key
    If ch = chr(79) Then Begin
      Search_idx:=1;
      If TotalAreas > 9 Then Begin
        TopPage := TotalAreas - 8;
        BarPos  := TotalAreas;
      End Else Begin
        BarPos  := TotalAreas;
      End;
      DrawPage;
    End;
  
    //Up Key
    If Ch = Chr(72) Then Begin
    Search_idx:=1;
      If BarPos > TopPage Then Begin
        BarOFF;
        BarPos := BarPos - 1;
        BarON;
        End
      Else
      If TopPage > 1 Then Begin
        TopPage := TopPage - 1;
        BarPos  := BarPos  - 1;
        DrawPage;
      End;
    End;
    
    //PageUp Key
    If Ch = Chr(73) Then Begin
      Search_idx:=1;
      If TopPage - 12 > 0 Then Begin
        TopPage := TopPage - 9;
        BarPos  := BarPos  - 9;
        DrawPage;
      End Else begin
        TopPage := 1;
        BarPos  := 1;
        DrawPage;
      End;
    End;
    
    //Down Key
    If Ch = Chr(80) Then Begin
      Search_idx:=1;
      If BarPos < TotalAreas Then
        If BarPos < TopPage + 8 Then Begin
          BarOFF;
          BarPos := BarPos + 1;
          BarON;
        End Else
        If BarPos < TotalAreas Then Begin
          TopPage := TopPage + 1;
          BarPos  := BarPos  + 1;
          DrawPage;
        End;
    End;     
  
    //PageDn Key
    If Ch = Chr(81) Then Begin
      Search_idx:=1;
      If TotalAreas > 9 Then
        If TopPage + 9 < TotalAreas - 9 Then Begin
          TopPage := TopPage + 9;
          BarPos  := BarPos  + 9;
          DrawPage;
        End Else Begin
          TopPage := TotalAreas - 8;
          BarPos  := TotalAreas;
          DrawPage;
        End Else Begin
          BarOFF;
          BarPos := TotalAreas;
          BarON;
        End;
    End; 
  ch:=#0;
  End Else
  //CTRL-Z Pressed
  If Ch = Chr(26) Then Begin
    HelpScreen;
    Ch := ReadKey;
    MainScreen;
    DrawPage;
    End Else
    if ch=chr(8) Then Begin
      Delete(search,length(search),1);
      GotoXY(searchx,searchy);
      Write(searchcol+upper(search)+' ');
      for ii:=1 to max_list Do Begin
        if pos(search,upper(area[ii]))>0 Then Begin
          TopPage := ii;
          BarPos  := ii;
          search_idx:=ii;
          DrawPage;
        End;
      End;
    End;
    //ENTER Pressed
    if Ch = Chr(13) Then Begin
      If BarPos = 1 Then Begin
        TextColor(15);
        ClrScr;
        MenuCmd('DD',DataPath+'flatten.py '+CfgTempPath+'rtlpower.dat > '+CfgTempPath+'preview.ans');
        MenuCmd('GV','ansiviewtxt;ansiviewh;0;'+CfgTempPath+'preview.ans')
      End Else If BarPos = 2 Then Begin
        TextColor(11+17*16);
        ClrScr;
        MenuCmd ('F3', CfgTempPath+'preview.ans')
      End Else If BarPos = 3 Then Begin
        GotoXY(29,16);
        Write('|09|17Enter Frequency: |15');
        TextColor(11+17*16);
        TmpStr := Input (15, 15, 1, '');
        If TmpStr <> '' Then Begin
          TextColor(11+17*16);
          ClrScr;
          If InputYN('|15|16This will last 1min. Continue?') Then Begin
            MenuCmd ('DD','timeout -s SIGTERM 60s rtl_fm -M fm -g 40 -f '+TmpStr+' -p 0 -s 60000 - | sox -t raw -r 60000 -e signed -b 32 - '+CfgTempPath+'preview.wav');
            //MenuCmd ('DD','timeout -s SIGTERM 60s rtl_fm -f '+TmpStr+' -s 60k -g 50 -p 65 -E wav -F 0 '+CfgTempPath+'preview.wav');
            //MenuCmd ('DD','sox -t wav '+CfgTempPath+'preview.wav '+CfgTempPath+'recording.wav rate 11025');
          End;
        End;
      End Else If BarPos = 4 Then Begin
        TextColor(11+17*16);
        ClrScr;
        MenuCmd ('F3', CfgTempPath+'preview.wav')
      End Else Begin
        GotoXY(1,25);
        If InputYN('|15|16This will last 1min. Continue?') Then Begin
          TextColor(11+17*16);
          ClrScr;
          TmpStr := Replace(options[barpos], '%dir%', CfgTempPath);
          MenuCmd(url[barpos],TmpStr);
        End;
    End;
    MainScreen;
    DrawPage;
  End Else 
  If ch = chr(1) Then Begin
    For ii:=search_idx+1 to max_list Do Begin
      If pos(search,upper(area[ii]))>0 Then Begin
        TopPage := ii;
        BarPos  := ii;
        search_idx:=ii;
        DrawPage;
        Break;
      End;
	 End;
  End Else
  If ch = chr(25) Then Begin
    GotoXY(searchx,searchy);
    Write(strrep(' ',length(search)));
    search:='';
    search_idx:=0;
  End Else
  //ESC Key
  If Ch = Chr(27) Then Begin
    Done := True;
  //Any other key  
  End Else If ch>=chr(32) And ch<=chr(128) Then Begin
    search:=search+upper(ch);
    GotoXY(searchx,searchy);
    Write(searchcol+upper(search));
    For ii:=1 to max_list Do Begin
      If pos(search,upper(area[ii]))>0 Then Begin
			TopPage := ii;
      BarPos  := ii;
      search_idx:=ii;
      DrawPage;
      Break;
		End;
	End;
  
  End;
Until Done;

GotoXY (1, 23);
TextColor(16);
//Erase Temporarily files
FileErase(CfgTempPath+'rtlpower.dat');
FileErase(CfgTempPath+'preview.ans');
FileErase(CfgTempPath+'preview.wav');
ClrScr;
End.
