# ---------------------------------------------------------------------------
# MPLDEMO.MPS : Mystic Programming Language (MPL) Demonstration Program
# ---------------------------------------------------------------------------
# Written by g00r00 for Mystic BBS Version 1.07.  Feel free to do whatever
# you want with this source code!  The MPE engine rox!  I will be adding
# more/better examples eventually.  This is just something quick I put
# together.
# ---------------------------------------------------------------------------

USES CFG
USES USER

Procedure FadeWrite (X Byte, Y Byte, S String)
Begin
  GotoXY (X, Y)
  Write  ('|08' + S)
  Delay  (250)
  GotoXY (X, Y)
  Write  ('|07' + S)
  Delay  (250)
  GotoXY (X, Y)
  Write  ('|15' + S)
  Delay  (250)
  GotoXY (X, Y)
  Write  ('|07' + S)  
Pend

Procedure Draw_M (X Byte)
Begin
  GotoXY (X - 1, 9)
  Write  (' |17|09|16|01')
  GotoXY (X - 1, 10)
  Write  (' |17|09|16|01   ')
  GotoXY (X - 1, 11)
  Write  (' |01   ')
Pend

Procedure Draw_P (Y Byte)
Begin
  GotoXY (39, Y - 1)
  Write  ('      ')
  GotoXY (39, Y)
  Write  ('|09|17|01|16')
  GotoXY (39, Y + 1)
  Write  ('|09|17|01|16')
  GotoXY (39, Y + 2)
  Write  ('')
Pend

Procedure Draw_L (X Byte)
Begin
  GotoXY (X, 9)
  Write  ('|09|17|01|16 ')
  GotoXY (X, 10)
  Write  ('|09|17|01|16 ')
  GotoXY (X, 11)
  Write  (' ')
Pend

Procedure Draw_Animated_Intro
Var
  Count Byte
Begin
  CLS
  For Count := 2 to 30
    Draw_M(Count)
    Delay(5)
  Fend

  For Count := 1 to 9
    Draw_P(Count)
    Delay(20)
  Fend

  For Count :=  74 DownTo 46
    Draw_L(Count)
    Delay(5)
  Fend

  FadeWrite (24, 13, 'The Mystic BBS Programming Language')
  FadeWrite (34, 15, 'Press Any Key')
  Write     ('|PN')
Pend

Procedure DrawHeader
Begin
  WriteLn('|CL')
  WriteLn('       |09|17|01|16            |09|17|01|16                    |09|17|01|16')
  WriteLn('       |09|17|01|16               |09|17|01|16                    |09|17|01|16')
  WriteLn('           |11y s t i c  |01 |11r o g r a m m i n g  |01 |11a n g u a g e')
  WriteLn('       |09 |01 |09|07')
  WriteLn('')
Pend

Procedure InputDemo
Var
  Str String
Begin
  DrawHeader

  WriteLn ('       This demonstrates some of the types of input functions which')
  WriteLn ('       are available within the Mystic Programming Language.|CR')

  Write ('       |09Regular input  ') Str := Input(30, 30, 11, '')
  Write ('       |09Caps input     ') Str := Input(30, 30, 12, '')
  Write ('       |09Proper input   ') Str := Input(30, 30, 13, '')
  Write ('       |09Phone input    ') Str := Input(12, 12, 14, '')
  Write ('       |09Date input     ') Str := Input(8,  8,  15, '')
  Write ('       |09Password input ') Str := Input(20, 20, 16, '')

  WriteLn ('|CR       |07Text can also be pushed into the input buffer:|CR')
  Write   ('|09       Regular Input  ') Str := Input(30, 30, 11, 'Default Text')

  WriteLn ('|CR       |07Input can be used without the input field:|CR')
  Write   ('|09       Regular Input  |11') Str := Input(30, 30, 1, 'Default Text')

  DrawHeader

  WriteLn ('|07       The input functions also make full use of ANSI editing.  Arrow')
  WriteLn ('       keys can be used to move around the field, as well as the HOME,')
  WriteLn ('       END, DEL, and CTRL-Y keys.')
  WriteLn ('|CR       Text longer than the input box can be entered in both ANSI and')
  WriteLn ('       non-ansi terminal modes.  For example: Type more than 30 characters')
  WriteLn ('       below, while experimenting with the other ANSI editing functions')
  WriteLn ('       mentioned above.')

  Write   ('|CR       |09Scroll Input   ') Str := Input(30, 255, 11, '')

  Write ('|CR       |PA')
Pend

Procedure UserListingHeader
Begin
  DrawHeader

  WriteLn ('       User Name                  Location                   SecLev   Sex')
  WriteLn ('       ------------------------------------------------------------------')
Pend

Procedure UserListing
Var
  Count Word,
  Done  Boolean
Begin
  UserListingHeader

  Done  := False
  Count := 1

  While GetUser(Count) And Not Done
    WriteLn ('       ' + PadRT(UserAlias, 25, ' ') + '  ' + PadRT(UserAddress, 25, ' ') + '  ' +
                         PadLT(Int2Str(UserSec), 6, ' ') + '    ' + UserSex)

    If Count MOD 10 = 0 Then
      Write ('       Continue? (Y/N): ')
      If OneKey('YN') = 'N' Then
        Done := True
      Else
        UserListingHeader
      EndIf
    EndIf
    Count := Count + 1
  Wend

  WriteLn ('|CR       Total of |15' + Int2Str(Count - 1) + ' |07users listed.|CR')
  Write   ('       |PA')
Pend

Procedure PlayNumberGame
Var
  GuessNum Byte,
  Answer   Integer,
  Temp     Integer
Begin
  DrawHeader
  WriteLn ('       |12Choose a number between 1 and 1000.  You have 10 guesses.')

  GuessNum := 0
  Answer   := Random(999) + 1

  Repeat
    GuessNum := GuessNum + 1
    Write ('|CR|03       Guess #' + Int2Str(GuessNum) + ': ')
    Temp := Str2Int(Input(4, 4, 12, ''))

    If Temp > Answer Then
      WriteLn ('|CR       |07The number is less than ' + Int2Str(Temp))
    ElseIf Temp < Answer Then
      WriteLn ('|CR       |07The number is greater than ' + Int2Str(Temp))
    Else
      GuessNum := 10
    EndIf
  Until GuessNum = 10

  If Temp = Answer Then
    WriteLn ('|CR       |12You won!  The number was: ' + Int2Str(Answer))
  Else
    WriteLn ('|CR       |12You lost.  The number was: ' + Int2Str(Answer))
  EndIf

  Write ('|CR       |PA')  
Pend

Function MainMenu : Byte
Var
  Ch   Char,
  Done Boolean,
  Bar  Byte,
  Ops  String Array(1..4)
Begin
  DrawHeader

  WriteLn ('       The Mystic BBS Programming Language (MPL for short) allows for the')
  WriteLn ('       ultimate in  flexibility.   With it''s  Pascal-like syntax, the MPL')
  WriteLn ('       provides an  easy  and flexible way to  modify internal Mystic BBS')
  WriteLn ('       functions, or  even create  your own online  games!  Check it out!')
  WriteLn ('|09|CR       |$D66|CR')

  WriteLn ('       |09(|101|09)  |03Input demo    |08-> |07See some example input functions')
  WriteLn ('       |09(|102|09)  |03User listing  |08-> |07See a list of user accounts')
  WriteLn ('       |09(|103|09)  |03Number game   |08-> |07Play a simple number game')
  WriteLn ('       |09(|10Q|09)  |03Quit Demo     |08-> |07Return to the BBS menu')

  WriteLn ('|09|CR       |$D66')
  Write ('       |07Select an option with arrow keys, or enter option number ')

  Done := False
  Bar  := 1

  Ops(1) := 'Input demo'
  Ops(2) := 'User listing'
  Ops(3) := 'Number game'
  Ops(4) := 'Quit Demo'

  Repeat
    If Graphics > 0 Then
      GotoXY (12, 13 + Bar)
      Write ('|01|23 ' + Ops(Bar) + ' |16')
    EndIf
    Ch := ReadKey
    If Graphics > 0 and IsArrow Then
      GotoXY (12, 13 + Bar)
      Write ('|03 ' + Ops(Bar) + ' ')
      If Ord(Ch) = 72 Then
        If Bar > 1 Then
          Bar := Bar - 1
        EndIf
      ElseIf Ord(Ch) = 80 Then
        If Bar < 4 Then
          Bar := Bar + 1
        EndIf
      EndIf
    Else
      If Ch = Chr(13) and Graphics > 0 Then
        MainMenu := Bar
        Done     := True
      ElseIf Upper(Ch) = 'Q' Then
        MainMenu := 4
        Done     := True    
      ElseIf Str2Int(Ch) > 0 and Str2Int(Ch) < 4 Then
        MainMenu := Str2Int(Ch)
        Done     := True
      EndIf
    EndIf
  Until Done
Pend

Var
  Selection Byte,
  Done      Boolean
Begin
  GetCFG

  Draw_Animated_Intro

  Done := False

  Repeat
    Selection := MainMenu

    If Selection = 1 Then
      InputDemo
    ElseIf Selection = 2 Then
      UserListing
    ElseIf Selection = 3 Then
      PlayNumberGame
    ElseIf Selection = 4 Then
      Done := True
    EndIf
  Until Done

  GotoXY (1, 20)
End
