'Copyright (c) 2016, Andrew Pamment
'All rights reserved.
'
'Redistribution and use in source and binary forms, with or without
'modification, are permitted provided that the following conditions are met:
'
'1. Redistributions of source code must retain the above copyright notice, this
'   list of conditions and the following disclaimer.
'2. Redistributions in binary form must reproduce the above copyright notice,
'   this list of conditions and the following disclaimer in the documentation
'   and/or other materials provided with the distribution.
'
'THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
'ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
'WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
'DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
'ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
'(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
'LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
'ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
'(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
'SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#include once "crt.bi"
#include once "vbcompat.bi"

const ESC = !"\27"
const FG_BLACK   = ESC + "[0;30m"
const FG_RED     = ESC + "[0;31m"
const FG_GREEN   = ESC + "[0;32m"
const FG_YELLOW  = ESC + "[0;33m"
const FG_BLUE    = ESC + "[0;34m"
const FG_MAGENTA = ESC + "[0;35m"
const FG_CYAN    = ESC + "[0;36m"
const FG_WHITE   = ESC + "[0;37m"

const FG_BRIGHT_BLACK   = ESC + "[1;30m"
const FG_BRIGHT_RED     = ESC + "[1;31m"
const FG_BRIGHT_GREEN   = ESC + "[1;32m"
const FG_BRIGHT_YELLOW  = ESC + "[1;33m"
const FG_BRIGHT_BLUE    = ESC + "[1;34m"
const FG_BRIGHT_MAGENTA = ESC + "[1;35m"
const FG_BRIGHT_CYAN    = ESC + "[1;36m"
const FG_BRIGHT_WHITE   = ESC + "[1;37m"

const FG_RESET   = ESC + "[0m"


Type DDKdoorInfoType
	UserAlias as String
	UserFirstName as String
	UserLastName as String
	TimeLeft as Integer
	Birthday as String
	SysopName as String
	Node as Integer
	Location as String
	SecLevel as Integer
End Type

private function str_replace(byref haystack as string, byref needle1 as string, byref needle2 as string) as string
   
    dim as integer len1 = len(needle1), len2 = len(needle2)
    dim as integer i
   
    dim as string haystack_ = haystack
   
    i = instr(haystack_, needle1)
    while i
       
        haystack_ = left(haystack_, i - 1) & needle2 & mid(haystack_, i + len1)
       
        i = instr(i + len2, haystack_, needle1)
       
    wend
   
    return haystack_
end function

Dim Shared DDKdoorInfo as DDKdoorInfoType
Dim Shared DDKgameOver as Double
Dim Shared DDKtimeLeft as Double

Public Function DoorKitGetLocation() As String
	return DDKdoorInfo.Location
End Function

Public Function DoorKitGetSysopName() As String
	return DDKdoorInfo.SysopName
End Function

Public Function DoorKitGetNode() As Integer
	return DDKdoorInfo.Node
End Function

Public Function DoorKitGetBirthday() As String
	return DDKdoorInfo.Birthday
End Function

Public Function DoorKitGetSecLevel() As Integer
	return DDKdoorInfo.SecLevel
End Function

Public Function DoorKitGetSecondsLeft() As Integer
	return DDKdoorInfo.TimeLeft
End Function

Public Function DoorKitGetUserAlias() As String
	return DDKdoorInfo.UserAlias
End Function

Public Function DoorKitGetFirstName() As String
	return DDKdoorInfo.UserFirstName
End Function

Public Function DoorKitGetLastName() As String
	return DDKdoorInfo.UserLastName
End Function

Public Function DoorKitPrintLn(s as String) as Integer
	s = str_replace(s, "`black`", FG_BLACK)
	s = str_replace(s, "`red`", FG_RED)
	s = str_replace(s, "`green`", FG_GREEN)
	s = str_replace(s, "`yellow`", FG_YELLOW)
	s = str_replace(s, "`blue`", FG_BLUE)
	s = str_replace(s, "`magenta`", FG_MAGENTA)
	s = str_replace(s, "`cyan`", FG_CYAN)
	s = str_replace(s, "`white`", FG_WHITE)
	s = str_replace(s, "`bright black`", FG_BRIGHT_BLACK)
	s = str_replace(s, "`bright red`", FG_BRIGHT_RED)
	s = str_replace(s, "`bright green`", FG_BRIGHT_GREEN)
	s = str_replace(s, "`bright yellow`", FG_BRIGHT_YELLOW)
	s = str_replace(s, "`bright blue`", FG_BRIGHT_BLUE)
	s = str_replace(s, "`bright magenta`", FG_BRIGHT_MAGENTA)
	s = str_replace(s, "`bright cyan`", FG_BRIGHT_CYAN)
	s = str_replace(s, "`bright white`", FG_BRIGHT_WHITE)
	
	printf(!"%s\r\n", s)
	return 0
End Function

Public Function DoorKitPrint(s as String) as Integer
	s = str_replace(s, "`black`", FG_BLACK)
	s = str_replace(s, "`red`", FG_RED)
	s = str_replace(s, "`green`", FG_GREEN)
	s = str_replace(s, "`yellow`", FG_YELLOW)
	s = str_replace(s, "`blue`", FG_BLUE)
	s = str_replace(s, "`magenta`", FG_MAGENTA)
	s = str_replace(s, "`cyan`", FG_CYAN)
	s = str_replace(s, "`white`", FG_WHITE)
	s = str_replace(s, "`bright black`", FG_BRIGHT_BLACK)
	s = str_replace(s, "`bright red`", FG_BRIGHT_RED)
	s = str_replace(s, "`bright green`", FG_BRIGHT_GREEN)
	s = str_replace(s, "`bright yellow`", FG_BRIGHT_YELLOW)
	s = str_replace(s, "`bright blue`", FG_BRIGHT_BLUE)
	s = str_replace(s, "`bright magenta`", FG_BRIGHT_MAGENTA)
	s = str_replace(s, "`bright cyan`", FG_BRIGHT_CYAN)
	s = str_replace(s, "`bright white`", FG_BRIGHT_WHITE)
	
	printf(!"%s", s)
	return 0
End Function


public Function DoorKitGetLine(ByVal length as Integer) as String
	Dim s as String
	Dim c as String
	Dim i as Integer
	
	do
		if (DDKgameOver = Now) then
			DoorKitPrintLn("`bright red`Timeout!`white`")
			End
		End if
		if (DDKtimeLeft = Now) then
			DoorKitPrintLn("`bright red`Sorry, you've run out of time!`white`")
			End		
		Endif
		sleep 1
		c = Inkey()
	loop until c <> ""
	DDKgameOver = DateAdd("n", 15, now)
	While c <> Chr(13)
		if (c = Chr(8)) then
			if (i > 0) then
				i = i - 1
				printf(!"%s", ESC + "[1D " + ESC + "[1D")
				s = left(s, i)
			end if
		else
			i = i + 1
			s = s + c
			print c;
			if (i = length) then return s
		end if
		do
			if (DDKgameOver = Now) then
				DoorKitPrintLn("`bright red`Timeout!`white`")
				End
			End if
			if (DDKtimeLeft = Now) then
				DoorKitPrintLn("`bright red`Sorry, you've run out of time!`white`")
				End		
			Endif		
			sleep 1	
			c = Inkey()
		loop until c <> ""
		DDKgameOver = DateAdd("n", 15, now)
	Wend
	return s
End Function

public Function DoorKitClearScreen() as Integer
	printf(!"%s", ESC + "[2J" + ESC + "[1;1H")
	return 0
End Function

Public Function DoorKitSendFile(ByVal fileName As String) As Integer
	Dim f as Integer

	f = FreeFile
	
	Open fileName For Input as #f
	If Err > 0 then Return 1
	do until eof(f)
		Dim s as String
		Line Input #f, s
		Dim p as UByte Ptr = strPtr(s)
		for i as integer = 0 to len(s)
			if (*p = 26) then
				printf(!"%s\r\n", left(s, i))
				close #f
				return 0
			end if
			
			p = p + 1
		next i
		
		printf(!"%s\r\n", s)
	Loop
	close #f
	Return 0
End Function

Private Function DoorKitReadDoorSys(ByVal dropFile As String) As Integer
	Dim f as Integer
	Dim s as String

	f = FreeFile
	Open dropFile For Input as #f
	If Err > 0 then Print "Error opening dropfile!":End
	' Comport
	Line Input #f, s 
	' EBaud
	Line Input #f, s
	' Databits
	Line Input #f, s
	' Node Number
	Line Input #f, s
	DDKdoorInfo.Node = val(s)
	' LBaud
	Line Input #f, s
	' Screen Display
	Line Input #f, s
	' Printer On
	Line Input #f, s
	' Page Bell
	Line Input #f, s
	' Caller Alarm
	Line Input #f, s
	' Username
	Line Input #f, s
	DDKdoorInfo.UserFirstName = Left(s, Instr(1, s, " ") - 1)
	DDKdoorInfo.UserLastName = Right(s, Len(s) - Instr(1, s, " "))
	' Location
	Line Input #f, s
	DDKdoorInfo.Location = s
	' Voice Phone
	Line Input #f, s
	' Data Phone
	Line Input #f, s
	' Password
	Line Input #f, s
	' SecLevel
	Line Input #f, s
	DDKdoorInfo.SecLevel = val(s)
	' Total Calls
	Line Input #f, s
	' Last Login
	Line Input #f, s
	' Sec TimeLeft
	Line Input #f, s
	DDKdoorInfo.TimeLeft = val(s)
	' Min TimeLeft
	Line Input #f, s
	' Graphics
	Line Input #f, s
	' Screen Len
	Line Input #f, s
	' Usermode
	Line Input #f, s
	' Extra1
	Line Input #f, s
	' Extra2
	Line Input #f, s
	' Expiry Date
	Line Input #f, s
	' Rec No
	Line Input #f, s
	' Protocol
	Line Input #f, s
	' Uploads
	Line Input #f, s
	' Downloads
	Line Input #f, s
	' Lim Down k
	Line Input #f, s
	' Lim Down k2
	Line Input #f, s
	' DOB
	Line Input #f, s
	DDKdoorInfo.Birthday = s
	' User Base
	Line Input #f, s
	' Msg Base
	Line Input #f, s
	' Sysop Name
	Line Input #f, s
	DDKdoorInfo.SysopName = s
	' Handle
	Line Input #f, s
	DDKdoorInfo.UserAlias = s
	' Next Event
	Line Input #f, s
	' Error Free
	Line Input #f, s
	' Always N
	Line Input #f, s
	' Always Y
	Line Input #f, s
	' Def Color
	Line Input #f, s
	' Always 0
	Line Input #f, s
	' Last Login 2
	Line Input #f, s
	' Time Login
	Line Input #f, s
	' Last Login Time
	Line Input #f, s
	' Max Integer
	Line Input #f, s
	' Downs Today
	Line Input #f, s
	' Upload K
	Line Input #f, s
	' Download K
	Line Input #f, s
	' Comment
	Line Input #f, s
	' Always 0
	Line Input #f, s
	' Posted
	Line Input #f, s
	Close #f

	Return 0 
End Function

Public Function DoorKitInit(ByVal dropFile As String) As Integer
	DDKgameOver = DateAdd("n", 15, now)
	
	if (Right(dropFile, 8) = "DOOR.SYS") Then
		DoorKitReadDoorSys(dropfile)
		DDKtimeLeft = DateAdd("s", DDKdoorInfo.TimeLeft, now)
		return 1
	End if
	
	return 0

End Function
