(*
                    _____,----,_______    _____,----,_____,----,_____,----,______,----,
                   _\    /____/\     /____\    /    /\    _    /\    /____/\    /    /_jp!
                  _\ .   \      .    \     .   \_    _____\      .   \      .         /_
              __ _\ `----,____/`----,____/`----,____/      \___/`----,____/`-----\___/ /_ __
             \_\\___                                                                ___//_/
                 .  /_   clutchbbs>> _             an old sko0l bbs since `95      _\  .
                 :.. /______________________________________________________________\ ..:
                       :.........................telnet://bbs.clutchbbs.com.........:


                                       Paging Module [Mystic]
                                       ~~~~~~~~~~~~~~~~~~~~~~

                                ACiDiC Paging Module Developed by n3!

                                     Version 2.0 (Linux/Windows)

                                       Updated: Jan, 2023

------------------------------------------------------------------------------------------------
FEATURES
------------------------------------------------------------------------------------------------

- Text/PushOver/Audio Pages
- Text/PushOver/Audio Login Alerts
- Emergency Chat Override
- Sysop Availability Status
- Email Notifications
- Blacklister
- Home Automation URL Support
- Themes (Prepackaged Themes)

------------------------------------------------------------------------------------------------
SUPPORT
------------------------------------------------------------------------------------------------

CLUTCH BBS
Sysop: niter3
Telnet: bbs.clutchbbs.com
Developer: n3! (niter3)
Alpha Tester: (Hawk Hubbard, Necromaster, maddog, Nighthawk, themadtux)

------------------------------------------------------------------------------------------------
UPDATES (CHANGE LOG)
------------------------------------------------------------------------------------------------
Date: Jan, 2023

- Added missing home automation alert procedures
- Fixed up some broken sections

Date: Dec, 2022 (Coding on these cold days.... Biggest blizzard warnings in history this year!)

- Added Pushover options as an alternative to text messaging
- Added Option For Home Automation URL
- Added wget.exe for windows. Stored in bin directory
- Removes Mystic theme setting. Not needed now that the mod main directory is stored in /mystic
- Themes have been added and easily usable by copying them in to their respective directories. 
- Settings file (settings.ini) now available and outside the .mps. No need to edit the mps.
- Enabled logging
- New directory /pmdata is now part of the root mystic directory (/mystic/pmdata/)
- Sound files are now moved to the following pmdata/sounds
- Ported IceChat Sound Files to mp3's including others. (Stored in /pmdata/sounds)
- Added beep codes and increased the delays for the progress bar
- Add Emergency Page Sound
- Fixed the blacklist Procedure. Doesn't require a temporary file write.
- Move everything into the mps. No need for a seperate script.
- Consolidated windows/linux into one MPS

Date: June, 2022

- Bug fixes around updated version of Mystic
- Fixed some coding to reflect Mystic 1.12 a47 changes
- Converted over to "mailsend-go" which can be found at https://github.com/muquit/mailsend-go

------------------------------------------------------------------------------------------------
MENU COMMANDS
------------------------------------------------------------------------------------------------

ENABLE PAGING (Text/Pushover Only)

	command: (GX) Execute MPL program
	Data: cl_paging page_text
 

ENABLE PAGING (Audio Only)

	command: (GX) Execute MPL program
	Data: cl_paging page_audio


ENABLE PAGING (Text/Pushover & Audio)

	command: (GX) Execute MPL program
	Data: cl_paging page_all


ENABLE LOGIN ALERT (Text/Pushover Only)

	command: (GX) Execute MPL program
	Data: cl_paging alert_text


ENABLE LOGIN ALERT (Audio Only)

	command: (GX) Execute MPL program
	Data: cl_paging alert_audio


ENABLE LOGIN ALERT (Text/Pushover & Audio)

	command: (GX) Execute MPL program
	Data: cl_paging alert_all

SYSOP STATUS MESSAGE

	command: (GX) Execute MPL program
	Data: cl_paging status

------------------------------------------------------------------------------------------------
*)

Uses USER
Uses CFG


Begin

Var SetFile : file
Var blfile : file;
Var blfile_tmp : file;
Var tmp_file : file;
Var user : string;
Var Str : string;
Var Str_TMP : string;
Var time : string;         
Var temp_time : string;
Var timeblah : string
Var cstart : string
Var cend : string
Var cend_real : integer
Var avail : string
Var avail_bl : string
Var availhloc : string
Var availhours : string
Var tz : string
Var ver : string
Var verloc : string
Var node : string
Var bbsname : string
Var ip : string
Var ansi : string
Var prbarloc : string
Var prbarlength : string
Var prbarcolor : string
Var prtxtcolor : string
Var prbarcur : string
Var prbarclear : string
Var anibarloc : string
Var anibarbg : string
Var anibarfg : string
Var snd_page : string
Var snd_page_emerg : string
Var snd_page_emerge_trk : string
Var snd_alert : string
Var sysoppage_msg : string
Var sysopout_msg : string
Var sysopinstatus_msg : string
Var sysopoutstatus_msg : string
Var sysopmail_msg : string
Var sysopname : string
Var method_text : string
Var method_audio : string
Var method_all : string
Var method_out : string
Var Stremerg : string
Var emergpass : string
Var emergyesno_msg : string
Var emergpass_msg : string
Var emergincorrect_msg : string
Var lines : integer
Var counter : integer
Var ar1 : Array[1..15] of String
Var ar2 : Array[1..15] of String
Var Opt : string
Var keyword : string
Var email_tog : string
Var sysopmsg_tog : string
Var emergpwd_tog : string
Var esmtp : string
Var eport : string
Var email : string
Var epass : string
Var femail : string
Var cellnumb : string
Var cellgateway : string
Var page_method : string
Var patoken : string
Var putoken : string
Var pdevice : string
Var ppriority : string
Var pushfiletmp : file
Var pushfiletmp_str : string
Var chrsize : string
Var char_a : integer
Var char_b : integer
Var os : string
Var pagemsgshort_str : string
Var mailinput : string
Var emerginput : string
Var promptyes_msg : string // Lightbar
Var promptno_msg : string // Lightbar
Var epromptyes_msg : string // Lightbar
Var epromptno_msg : string // Lightbar
Var prompt_track : integer // Lightbar tracking variable
Var prompt_input : string
Var page_ha_url : string
Var page_ha_tog : string
Var page_ha_counter : integer
Var alert_ha_url : string
Var alert_ha_tog : string
Var alert_ha_counter : integer
Var settingsfile_exist : string // Used to store true or false if settings.ini exists


GetThisUser

// -----------------------------------------------------------------------------------------------------------
// Variables Assignments

ver := 'v2.0'
ip := mci2str('UX')
bbsname := mci2str('BN')
node := int2str(Nodenum)

// Time Related

cstart := int2str(cfgchatstart)
cend := int2str(cfgchatend)
cend_real := cfgchatend
cend_real := cend_real - 1
availhours := cstart + '-' + cend

temp_time := timestr(datetime,false);
time := temp_time;

If cfgchatend = 00 or cfgchatend = 0 then
   cfgchatend :=24
	
delete(temp_time,3,1);
time := copy(temp_time,1,2);

// -----------------------------------------------------------------------------------------------------------
// Mail Procedure 

Procedure mail
Begin
	SysopLog('Paging Module: Procedure Mail')

// Lightbar Menu for Sysop Mail. First checks if the variable is turned on.

	If sysopmsg_tog = 'on' then
		Begin
			write(sysopmail_msg)
			write(promptno_msg)
			prompt_track := 0
			repeat
				prompt_input := Readkey

				If prompt_input = 'y' then
					Begin
						menucmd('MW','/To:' + sysopname + ' /SUBJ:Page_Attempt');
						halt
					End

				If prompt_input = #75 then // left arrow
					Begin
						prompt_track := 1
						write(promptyes_msg)
					End

				If prompt_input = #77 then // right arrow
					Begin
						prompt_track := 0
						write(promptno_msg)
					End

				If prompt_input = #13 and prompt_track = 1 then // Enter Key
					Begin
						menucmd('MW','/To:' + sysopname + ' /SUBJ:Page_Attempt');
						halt
					End

				If prompt_input = #13 and prompt_track = 0 then
               exit
					
      until prompt_input = 'n' or prompt_input = #13
   End

End

// -----------------------------------------------------------------------------------------------------------
// Home Automation Page URL

Procedure home_automation_page
Begin
Sysoplog ('Paging Module: Procedure home_automation_page')

// Linux
If page_ha_tog = 'on' and os = 'linux' then
   Begin

		// Loop to remove beginning of string (page_ha_url=)
		page_ha_counter := 0
	
		repeat 
			page_ha_counter := page_ha_counter + 1
			page_ha_url[page_ha_counter] := ' '
		until page_ha_counter = 12
		
		page_ha_url := WordGet(1,page_ha_url, ' ') // Gets URL after whitespaces. May be an issue if white spaces in the URL... 
		
		// Send URL to Home Automation

      SysopLog ('Paging Module: Sending Home Automation Page URL - lin')
      menucmd('DD','wget -qO- "' + page_ha_url + '" > /dev/null 2>&1 &')
		menucmd('DD','wget -qO- "' + page_ha_url + '" > /dev/null 2>&1 &') // Sends twice to wake it up
   End

// Windows
If page_ha_tog = 'on' and os = 'windows' then
	Begin
		
		// Loop to remove beginning of string (page_ha_url=)
		page_ha_counter := 0
	
		repeat 
			page_ha_counter := page_ha_counter + 1
			page_ha_url[page_ha_counter] := ' '
		until page_ha_counter = 12
		
		page_ha_url := WordGet(1,page_ha_url, ' ') // Gets URL after whitespaces. May be an issue if white spaces in the URL...
		
		// Send URL to Home Automation
		SysopLog ('Paging Module: Sending Home Automation Alert URL - win')
      menucmd('DD','start /b ' + CFGMPEPATH + 'pmdata\bin\wget -qO- "' + page_ha_url + '" > nul')
		menucmd('DD','start /b ' + CFGMPEPATH + 'pmdata\bin\wget -qO- "' + page_ha_url + '" > nul') // Sends twice to wake it up
   End
	
	If page_ha_tog <> 'on' then
		Begin
			SysopLog('Paging Module: Home Automation URL Not Defined')
		End

End


// -----------------------------------------------------------------------------------------------------------
// Procedure Home Automation Alert URL

	Procedure home_automation_alert
		Begin
			Sysoplog ('Paging Module: Procedure home_automation_alert')
			
				// Linux
				If alert_ha_tog = 'on' and os = 'linux' then
				   Begin

						// Loop to remove beginning of string (page_ha_url=)
						alert_ha_counter := 0
	
						repeat 
							alert_ha_counter := alert_ha_counter + 1
							alert_ha_url[alert_ha_counter] := ' '
						until alert_ha_counter = 13
		
						alert_ha_url := WordGet(1,alert_ha_url, ' ') // Gets URL after whitespaces. May be an issue if white spaces in the URL... 
		
						// Send URL to Home Automation

				      SysopLog ('Paging Module: Sending Home Automation Alert URL - lin')
				      menucmd('DD','wget -qO- "' + alert_ha_url + '" > /dev/null 2>&1 &')
						menucmd('DD','wget -qO- "' + alert_ha_url + '" > /dev/null 2>&1 &') // Sends twice to wake it up
				   End
					
				// Windows
				If alert_ha_tog = 'on' and os = 'windows' then
					Begin
		
						// Loop to remove beginning of string (page_ha_url=)
						alert_ha_counter := 0
	
						repeat 
							alert_ha_counter := alert_ha_counter + 1
							alert_ha_url[alert_ha_counter] := ' '
						until alert_ha_counter = 13
		
							alert_ha_url := WordGet(1,alert_ha_url, ' ') // Gets URL after whitespaces. May be an issue if white spaces in the URL...
		
							// Send URL to Home Automation
							SysopLog ('Paging Module: Sending Home Automation Alert URL - win')
					      menucmd('DD','start /b ' + CFGMPEPATH + 'pmdata\bin\wget -qO- "' + alert_ha_url + '" > nul')
							menucmd('DD','start /b ' + CFGMPEPATH + 'pmdata\bin\wget -qO- "' + alert_ha_url + '" > nul') // Sends twice to wake it up
					   End
	
				If alert_ha_tog <> 'on' then
					Begin
						SysopLog('Paging Module: Home Automation Alert URL Not Defined')
					End
			
		End

// **** START OF COMMANDS TO SEND OUT ***

// -----------------------------------------------------------------------------------------------------------
// Procedure Page Text (Linux)
	Procedure page_txt_lin
		Begin
			SysopLog ('Paging Module: Procedure page_txt_lin');
		
				fAssign   (tmp_file, CfgTempPath + 'tmp.sh', 66);
				fReset    (tmp_file);
				fReWrite  (tmp_file);
				fWriteStr (tmp_file, '#!/bin/bash');
				fWriteLn  (tmp_file, '');
				fWriteStr (tmp_file, 'mailsend-go -smtp ' + esmtp + ' -port ' + eport + ' auth -user ' + email + ' -pass ' + epass);
				fWriteStr (tmp_file, ' -fname "Mystic" -from ' + femail + ' -to ' + cellnumb + '@' + cellgateway + ' body -msg "User ');
				fWriteStr (tmp_file, UserAlias + ' is paging from ' + bbsname + '. (' + Str + ')" >/dev/null 2>&1');
				fClose    (tmp_file);
		
				MenuCmd('DD', 'chmod +x ' + CfgTempPath + 'tmp.sh');
				MenuCmd('DD', '/bin/sh ' + CfgTempPath + 'tmp.sh');
				
				FileErase (CfgTempPath + 'tmp.sh');		
		
	End

// -----------------------------------------------------------------------------------------------------------
// Procedure Page Text (Windows)
	Procedure page_txt_win
		Begin
			SysopLog ('Paging Module: Procedure pagetext_win');
			
			fAssign   (tmp_file, CfgTempPath + 'tmp.bat', 66);
		   fReWrite  (tmp_file);
			fWriteStr (tmp_file, 'start /b ' + CFGMPEPATH + 'pmdata\bin\mailsend -smtp ' + esmtp + ' -port ' + eport + ' auth -user ' + email + ' -pass ' + epass);
		   fWriteStr (tmp_file, ' -fname "Mystic" -from ' + femail + ' -to ' + cellnumb + '@' + cellgateway);
		   fWriteStr (tmp_file, ' body -msg "User ' + UserAlias + ' is paging from ' + bbsname + '. (' + Str + ')" > nul');
		   fClose    (tmp_file);
		
		   MenuCmd('DD', CfgTempPath + 'tmp.bat');
  
		   FileErase (CfgTempPath + 'tmp.bat');
			
		End
				
// -----------------------------------------------------------------------------------------------------------
// Page PushOver (Windows)
	Procedure page_pushover_win
		Begin
			SysopLog ('Paging Module: Procedure pagepushover_win');			
		
			fAssign   (tmp_file, CfgTempPath + 'tmp.bat', 66);
			fReWrite  (tmp_file);
			fWriteStr (tmp_file, 'start /b ' + CFGMPEPATH + 'pmdata\bin\wget -qO- https://api.pushover.net/1/messages.json --post-data="token=');
			fWriteStr (tmp_file, patoken + '&user=' + putoken);
			fWriteStr (tmp_file, '&device=' + pdevice + '&message=User ');
			fWriteLn  (tmp_file, UserAlias + ' is paging from ' + bbsname + '. (' + Str + ')&title=' + bbsname + '" > nul');
			fClose    (tmp_file);
		
			MenuCmd('DD', CfgTempPath + 'tmp.bat');
  
			FileErase (CfgTempPath + 'tmp.bat');
		
	End
				
// -----------------------------------------------------------------------------------------------------------
// Page PushOver (Linux)
	Procedure page_pushover_lin
		Begin
			SysopLog ('Paging Module: Procedure page_pushover_lin')
							
			fAssign   (tmp_file, CfgTempPath + 'tmp.sh', 66);
			fReset    (tmp_file);
			fReWrite  (tmp_file);
			fWriteStr (tmp_file, '#!/bin/sh');
			fWriteLn  (tmp_file, '');
			fWriteStr (tmp_file, 'wget https://api.pushover.net/1/messages.json --post-data="token=' + patoken + '&user=' + putoken);
			fWriteStr (tmp_file, '&message=User ' + UserAlias + ' is paging from ' + bbsname);
			fWriteStr (tmp_file, '. (' + Str + ')&title=' + bbsname + '&device=' + pdevice + '" -qO- > /dev/null 2>&1 &');
			fClose    (tmp_file);
		
			MenuCmd('DD', 'chmod +x ' + CfgTempPath + 'tmp.sh');
			MenuCmd('DD', '/bin/sh ' + CfgTempPath + 'tmp.sh');
  
			FileErase (CfgTempPath + 'tmp.sh');
		End
		
// -----------------------------------------------------------------------------------------------------------
// Email Page (Windows)
	Procedure page_email_win
		Begin
			SysopLog ('Paging Module: Procedure pageemail_win');

				fAssign   (tmp_file, CfgTempPath + 'tmp.bat', 66);
				fReWrite  (tmp_file);
				fWriteStr (tmp_file, 'start /b ' + CFGMPEPATH + 'pmdata\bin\mailsend -smtp ' + esmtp + ' -port ' + eport + ' auth -user ' + email + ' -pass ' + epass);
				fWriteStr (tmp_file, ' -fname "' + bbsname + ': Paging" -from ' + femail + ' -to ' + email + ' body -msg "User ' + UserAlias);
				fWriteStr (tmp_file, ' is paging from ' + bbsname + '. (' + Str + ')" > nul');
				fClose    (tmp_file);
	
				MenuCmd('DD', CfgTempPath + 'tmp.bat');

				FileErase (CfgTempPath + 'tmp.bat');
	
		
	End
		
// -----------------------------------------------------------------------------------------------------------
// Email Page (Linux)
	Procedure page_email_lin
		Begin
			SysopLog ('Paging Module: Procedure page_email_lin')
				
				fAssign   (tmp_file, CfgTempPath + 'tmp.sh', 66);
				fReset    (tmp_file);
				fReWrite  (tmp_file);
				fWriteStr (tmp_file, '#!/bin/sh');
				fWriteLn  (tmp_file, '');
				fWriteStr (tmp_file, 'mailsend-go -smtp ' + esmtp + ' -port ' + eport + ' auth -user ' + email + ' -pass ' + epass);
				fWriteStr (tmp_file, ' -fname "' + bbsname + ': Paging" -from ' + femail + ' -to ' + email + ' body -msg "User ' + UserAlias);
				fWriteStr (tmp_file, ' is paging from ' + bbsname + '. (' + Str + ')" >/dev/null 2>&1');
				fClose    (tmp_file);
		
				MenuCmd('DD', 'chmod +x ' + CfgTempPath + 'tmp.sh');
				MenuCmd('DD', '/bin/sh ' + CfgTempPath + 'tmp.sh');
  
				FileErase (CfgTempPath + 'tmp.sh');	
		
			
		End
		

// -----------------------------------------------------------------------------------------------------------
// Alert Text (Windows)
	Procedure alert_txt_win
		Begin
			SysopLog ('Paging Module: Procedure alert_txt_win')
				
			fAssign   (tmp_file, CfgTempPath + 'tmp.bat', 66);
		   fReWrite  (tmp_file);
			fWriteStr (tmp_file, 'start /b ' + CFGMPEPATH + 'pmdata\bin\mailsend -smtp ' + esmtp + ' -port ' + eport + ' auth -user ' + email + ' -pass ' + epass);
		   fWriteStr (tmp_file, ' -fname "Mystic" -from ' + femail + ' -to ' + cellnumb + '@' + cellgateway);
			fWriteStr (tmp_file, ' body -msg "User ' + UserAlias + ' logged into ' + bbsname + '. " > nul');
		   fClose    (tmp_file);
	
		   MenuCmd('DD', CfgTempPath + 'tmp.bat');

		   FileErase (CfgTempPath + 'tmp.bat');
			
		End
	
// -----------------------------------------------------------------------------------------------------------
// Alert Text (Linux)
	Procedure alert_txt_lin
		Begin
			SysopLog ('Paging Module: Procedure alert_txt_lin')
				
			fAssign   (tmp_file, CfgTempPath + 'tmp.sh', 66);
			fReset    (tmp_file);
			fReWrite  (tmp_file);
			fWriteStr (tmp_file, '#!/bin/sh');
			fWriteLn  (tmp_file, '');
			fWriteStr (tmp_file, 'mailsend-go -smtp ' + esmtp + ' -port ' + eport + ' auth -user ' + email + ' -pass ' + epass);
			fWriteStr (tmp_file, ' -fname "Mystic" -from ' + femail + ' -to ' + cellnumb + '@' + cellgateway);
			fWriteStr (tmp_file, ' body -msg "User ' + UserAlias + ' logged into ' + bbsname + '." >/dev/null 2>&1');
			fClose    (tmp_file);
		
			MenuCmd('DD', 'chmod +x ' + CfgTempPath + 'tmp.sh');
			MenuCmd('DD', '/bin/sh ' + CfgTempPath + 'tmp.sh');
  
			FileErase (CfgTempPath + 'tmp.sh');	
			
			
		End

// -----------------------------------------------------------------------------------------------------------
// Alert Pushover (Windows)
	Procedure alert_pushover_win
		Begin
			SysopLog ('Paging Module: Procedure alert_pushover_win');
				
			fAssign   (tmp_file, CfgTempPath + 'tmp.bat', 66);
		   fReWrite  (tmp_file);
			fWriteStr (tmp_file, 'start /b ' + CFGMPEPATH + 'pmdata\bin\wget -qO- https://api.pushover.net/1/messages.json --post-data="token=' + patoken + '&user=' + putoken);
		   fWriteStr (tmp_file, '&device=' + pdevice + '&message=User ' + UserAlias + ' logged into ' + bbsname);
			fWriteStr (tmp_file, '.&title=' + bbsname + '" > nul');
		   fClose    (tmp_file);
	
		   MenuCmd('DD', CfgTempPath + 'tmp.bat');

		   FileErase (CfgTempPath + 'tmp.bat');
				
		End
	
// -----------------------------------------------------------------------------------------------------------
// Alert Pushover (Linux)
	Procedure alert_pushover_lin
		Begin
			SysopLog ('Paging Module: Procedure alert_pushover_lin')
		
			fAssign   (tmp_file, CfgTempPath + 'tmp.sh', 66);
			fReset    (tmp_file);
			fReWrite  (tmp_file);
			fWriteStr (tmp_file, '#!/bin/sh');
			fWriteLn  (tmp_file, '');
			fWriteStr (tmp_file, 'wget https://api.pushover.net/1/messages.json --post-data="token=' + patoken + '&user=' + putoken);
			fWriteStr (tmp_file, '&message=User ' + UserAlias + ' logged into ' + bbsname);
			fWriteStr (tmp_file, '.&title=' + bbsname + '&device=' + pdevice + '" -qO- > /dev/null 2>&1 &');
			fClose    (tmp_file);
		
			MenuCmd('DD', 'chmod +x ' + CfgTempPath + 'tmp.sh')
			MenuCmd('DD', '/bin/sh ' + CfgTempPath + 'tmp.sh');
  
			FileErase (CfgTempPath + 'tmp.sh');	
		
		End
	
	
// **** END OF COMMANDS TO SEND OUT ***
	
// -----------------------------------------------------------------------------------------------------------
// Blacklist Availability Check

Procedure black_avail
Begin
	SysopLog('Paging Module: Procedure black_avail')

	If user = '' Then
		writeln(avail)
	Else
		writeln(avail_bl)

End

//-------------------------------------------------------------------------------
// Page Animation

Procedure page_anima
Begin
	SysopLog('Paging Module: Procedure page_anima')

	writeln(sysoppage_msg)
	writeln(anibarloc)
	writeln(anibarbg)
	writeln(anibarfg + '|DE|DE|BE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|BE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|BE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|BE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|BE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|BE|DE|DE|DE')

End

//------------------------------------------------------------------------------------------------------------
// Sysop IN Status

Procedure sysopINstatus
Begin
	SysopLog('Paging Module: Procedure sysopINstatus')
	CLRSCR

	writeln(sysopinstatus_msg)

End

// ------------------------------------------------------------------------------------------------------------
// Sysop OUT Status

Procedure sysopOUTstatus
Begin
	SysopLog('Paging Module: Procedure sysopOUTstatus')
	CLRSCR

	writeln(sysopoutstatus_msg)

End

// -----------------------------------------------------------------------------------------------------------
// Sysop IN All Audio/Text (LINUX)

Procedure sysopINall
Begin
	SysopLog('Paging Module: Procedure sysopINall')
	CLRSCR

	dispfile (ansi)
	writeln(prbarloc + prbarcolor + prtxtcolor + prbarlength + verloc + ver + avail + availhloc + availhours + tz)
	writeln(method_all)
	write(prbarcur)

	Str := Input (73, 73, 1, '')
	Str_TMP := WordGet(1,Str, ' ') // Removes Spaces from Str and stores in temp variable for checking below
	char_a := str2int(chrsize) // Sets char_a to the length from settings
	char_b := (Length(Str_TMP)) // Checks the length of string without spaces

	If Str = '' Then
		exit

	If char_b < char_a Then
	   Begin
		writeln(pagemsgshort_str)
		halt
	   End

	If str <> '' Then
	   Begin

		If page_method = 'txt' Then
			Begin
		      SysopLog ('Paging Module: Sending Text Message')
				page_txt_lin()
			End
			
		If page_method = 'pushover' Then
			Begin
		      SysopLog ('Paging Module: Sending Pushover')				
				page_pushover_lin()
			End
			
		If email_tog = 'on' Then
			Begin
		      SysopLog ('Paging Module: Sending Email')
				page_email_lin()
			End
			
		If snd_page_emerge_trk = '1' Then
			Begin
		      SysopLog ('Paging Module: Playing Audio Sound (Emergency) ' + snd_page)
				menucmd('DD','sudo -b mpg123 -q ' + CFGMPEPATH + 'pmdata/sounds/' + snd_page_emerg + ' >/dev/null 2>&1')
			End
			
		If snd_page_emerge_trk <> '1' Then
			Begin
		      SysopLog ('Paging Module: Playing Audio Sound ' + snd_page)
				menucmd('DD','sudo -b mpg123 -q ' + CFGMPEPATH + 'pmdata/sounds/' + snd_page + ' >/dev/null 2>&1')
			End
			
		home_automation_page()	
		snd_page_emerge_trk := '0'
		SysopLog ('Paging Module: ' + UserAlias + ' paged you for chat.')
		page_anima()
		mail()
	   End
End

// -----------------------------------------------------------------------------------------------------------
// Sysop IN All Audio/Text (WINDOWS)

Procedure sysopINall_win
Begin
	SysopLog('Paging Module: Procedure sysopINall_win')
	CLRSCR

	dispfile (ansi)
	writeln(prbarloc + prbarcolor + prtxtcolor + prbarlength + verloc + ver + avail + availhloc + availhours + tz)
	writeln(method_all)
	write(prbarcur)

	Str := Input (73, 73, 1, '')
	Str_TMP := WordGet(1,Str, ' ') // Removes Spaces from Str and stores in temp variable for checking below
	char_a := str2int(chrsize) // Sets char_a to the length from settings
	char_b := (Length(Str_TMP)) // Checks the length of string without spaces

	If Str = '' Then
		exit
		
	If char_b < char_a Then
	   Begin
			writeln(pagemsgshort_str)		
			exit
	   End

	If str <> '' Then
	   Begin
	
			If page_method = 'txt' Then
				Begin
					SysopLog ('Paging Module: Sending Text Message')
					page_txt_win()
				End
				
			If page_method = 'pushover' Then
				Begin
					SysopLog ('Paging Module: Sending Pushover')			
				   page_pushover_win()
					
				End
				
			If email_tog = 'on' Then
				Begin
					SysopLog ('Paging Module: Sending Email')
					page_email_win()
				End
				
			If snd_page_emerge_trk = '1' Then
				Begin
			      SysopLog ('Paging Module: Playing Audio Sound (Emergency) ' + snd_page)
					menucmd('DD','start /b ' + CFGMPEPATH + 'pmdata\bin\mpg123 -q ' + CFGMPEPATH + 'pmdata\sounds\' + snd_page_emerg + '')
				End
				
			If snd_page_emerge_trk <> '1' Then
				Begin
			      SysopLog ('Paging Module: Playing Audio ' + snd_page)
					menucmd('DD','start /b ' + CFGMPEPATH + 'pmdata\bin\mpg123 -q ' + CFGMPEPATH + 'pmdata\sounds\' + snd_page + '')
				End
				
			home_automation_page()
			snd_page_emerge_trk := '0'
			SysopLog ('Paging Module: ' + UserAlias + ' paged you for chat.')	
			CLRSCR // Re-Display - Windows Issue
			dispfile (ansi)
			writeln(prbarloc + prbarcolor + prtxtcolor + prbarlength + verloc + ver + avail + availhloc + availhours + tz)
			write(prbarcur + Str)
			writeln('|16' + method_all)
			page_anima()
			mail()
	   End
End

// -----------------------------------------------------------------------------------------------------------
// Sysop IN Audio (LINUX)

Procedure sysopINaudio
Begin
	SysopLog('Paging Module: Procedure sysopINaudio_lin')
	CLRSCR
	dispfile (ansi)

	writeln(prbarloc + prbarcolor + prtxtcolor + prbarlength + verloc + ver + avail + availhloc + availhours + tz)
	writeln(method_audio)
	write(prbarcur)

	Str := Input (73, 73, 1, '')
	Str_TMP := WordGet(1,Str, ' ') // Removes Spaces from Str and stores in temp variable for checking below
	char_a := str2int(chrsize) // Sets char_a to the length from settings
	char_b := (Length(Str_TMP)) // Checks the length of string without spaces

	If Str = '' Then
      exit

   If char_b < char_a Then
	   Begin
			writeln(pagemsgshort_str)		
			exit
	   End

	If str <> '' Then
	   Begin

			If email_tog = 'on' Then
				Begin
					SysopLog ('Paging Module: Sending Email')
					page_email_lin()
				End

			If snd_page_emerge_trk = '1' Then
				Begin
			      SysopLog ('Paging Module: Playing Audio Sound (Emergency)')
					menucmd('DD','sudo -b mpg123 -q ' + CFGMPEPATH + 'pmdata/sounds/' + snd_page_emerg + ' >/dev/null 2>&1')
				End
				
			If snd_page_emerge_trk <> '1' Then
				Begin
			      SysopLog ('Paging Module: Playing Audio Sound')
					menucmd('DD','sudo -b mpg123 -q ' + CFGMPEPATH + 'pmdata/sounds/' + snd_page + ' >/dev/null 2>&1')
				End
			
			home_automation_page()
			snd_page_emerge_trk := '0'
      	SysopLog ('Paging Module: ' + UserAlias + ' paged you for chat.')
			page_anima()
			mail()

	   End
End

// -----------------------------------------------------------------------------------------------------------
// Sysop IN Audio (WINDOWS)

Procedure sysopINaudio_win
Begin
	SysopLog('Paging Module: Procedure sysopINaudio_win')
	CLRSCR
	dispfile (ansi)

	writeln(prbarloc + prbarcolor + prtxtcolor + prbarlength + verloc + ver + avail + availhloc + availhours + tz)
	writeln(method_audio)
	write(prbarcur)

	Str := Input (73, 73, 1, '')
	Str_TMP := WordGet(1,Str, ' ') // Removes Spaces from Str and stores in temp variable for checking below
	char_a := str2int(chrsize) // Sets char_a to the length from settings
	char_b := (Length(Str_TMP)) // Checks the length of string without spaces

	If Str = '' Then
		exit

   If char_b < char_a Then
	   Begin
			writeln(pagemsgshort_str)
			exit
	   End

	If str <> '' Then
	   Begin
		
			If email_tog = 'on' Then
				Begin
			      SysopLog ('Paging Module: Sending Email')
					page_email_win()
				End

			If snd_page_emerge_trk = '1' Then
				Begin
			      SysopLog ('Paging Module: Playing Audio Sound (Emergency)')
					menucmd('DD','start /b ' + CFGMPEPATH + 'pmdata\bin\mpg123 -q ' + CFGMPEPATH + 'pmdata\sounds\' + snd_page_emerg + '')
				End
				
			If snd_page_emerge_trk <> '1' Then
				Begin
			      SysopLog ('Paging Module: Playing Audio Sound')
					menucmd('DD','start /b ' + CFGMPEPATH + 'pmdata\bin\mpg123 -q ' + CFGMPEPATH + 'pmdata\sounds\' + snd_page + '')
				End
			
			home_automation_page()
			snd_page_emerge_trk := '0'
			SysopLog ('Paging Module: ' + UserAlias + ' paged you for chat.')
			CLRSCR // Re-Display - Windows Issue
			dispfile (ansi)
			writeln(prbarloc + prbarcolor + prtxtcolor + prbarlength + verloc + ver + avail + availhloc + availhours + tz)
			write(prbarcur + Str)
			writeln('|16' + method_all)
			page_anima()
			mail()
	   End
End

// ------------------------------------------------------------------------------------------------------------------------
// Sysop IN text (LINUX)

Procedure sysopINtext
Begin
	SysopLog('Paging Module: Procedure sysopINtext_lin')
	CLRSCR
	dispfile (ansi)

	writeln(prbarloc + prbarcolor + prtxtcolor + prbarlength + verloc + ver + avail + availhloc + availhours + tz)
	writeln(method_text)
	write(prbarcur)

	Str := Input (73, 73, 1, '')
	Str_TMP := WordGet(1,Str, ' ') // Removes Spaces from Str and stores in temp variable for checking below
	char_a := str2int(chrsize) // Sets char_a to the length from settings
	char_b := (Length(Str_TMP)) // Checks the length of string without spaces

	If Str = '' Then
      exit

   If char_b < char_a Then
		Begin
			writeln(pagemsgshort_str)
			exit
	   End

	If str <> '' Then
		Begin

			If email_tog = 'on' Then
				Begin
			      SysopLog ('Paging Module: Sending Email')
					page_email_lin()
				End

			If page_method = 'txt' Then
				Begin
			      SysopLog ('Paging Module: Sending Text Message')
					page_txt_lin()
				End
		
			If page_method = 'pushover' Then
				Begin
			      SysopLog ('Paging Module: Sending Pushover')
					page_pushover_lin()
				End

			SysopLog ('Paging Module: ' + UserAlias + ' paged you for chat.')
			page_anima()
			mail()
	   
		End
End

// ------------------------------------------------------------------------------------------------------------------------
// Sysop IN text (WINDOWS)

Procedure sysopINtext_win
Begin
	SysopLog('Paging Module: Procedure sysopINtext_win')
	CLRSCR
	dispfile (ansi)

	writeln(prbarloc + prbarcolor + prtxtcolor + prbarlength + verloc + ver + avail + availhloc + availhours + tz)
	writeln(method_text)
	write(prbarcur)

	Str := Input (73, 73, 1, '')
	Str_TMP := WordGet(1,Str, ' ') // Removes Spaces from Str and stores in temp variable for checking below
	char_a := str2int(chrsize) // Sets char_a to the length from settings
	char_b := (Length(Str_TMP)) // Checks the length of string without spaces

	If Str = '' Then
		exit

   If char_b < char_a Then
	   Begin
			writeln(pagemsgshort_str)
			exit
	   End

	If str <> '' Then
	   Begin
			If email_tog = 'on' Then
				Begin
			      SysopLog ('Paging Module: Sending Email')
					page_email_win()
				End
		
			If page_method = 'txt' Then
				Begin
			      SysopLog ('Paging Module: Sending Text Message')
					page_txt_win()
				End
				
			If page_method = 'pushover' Then
				Begin
			      SysopLog ('Paging Module: Sending Pushover')
					page_pushover_win()
				End

			SysopLog ('Paging Module: ' + UserAlias + ' paged you for chat.')
			CLRSCR // Re-Display - Windows Issue
         dispfile (ansi)
         writeln(prbarloc + prbarcolor + prtxtcolor + prbarlength + verloc + ver + avail + availhloc + availhours + tz)
			write(prbarcur + Str)
			writeln('|16' + method_all)
         page_anima()
         mail()
	   End
End

// ------------------------------------------------------------------------------------------------------------------------
// Emergency Page - Select (LINUX)

Procedure sysop_emerg_select
Begin
	SysopLog('Paging Module: Procedure sysop_emerg_select')
	snd_page_emerge_trk := '1'

	Case Upper(ParamStr(1)) of
		'PAGE_TEXT'   : sysopintext;
		'PAGE_AUDIO'  : sysopinaudio;
		'PAGE_ALL'    : sysopinall;
	end

End

// ------------------------------------------------------------------------------------------------------------------------
// Emergency Page - Select (WINDOWS)

Procedure sysop_emerg_select_win
Begin
	SysopLog('Paging Module: Procedure sysop_emerg_select_win')
	snd_page_emerge_trk := '1'

	Case Upper(ParamStr(1)) of
		'PAGE_TEXT'   : sysopintext_win;
		'PAGE_AUDIO'  : sysopinaudio_win;
		'PAGE_ALL'    : sysopinall_win;
	end

End

// ------------------------------------------------------------------------------------------------------------------------
// Sysop Emergency Page (LINUX)

Procedure sysop_emerg
Begin
   SysopLog('Paging Module: Procedure sysop_emerg')
   write(emergpass_msg)
   Stremerg := Input (15, 15, 1, '')

   If Stremerg = emergpass Then
      sysop_emerg_select
   
   Else If stremerg <> emergpass Then
		Begin
			writeln(emergincorrect_msg)
			halt
		End

End

// ------------------------------------------------------------------------------------------------------------------------
// Sysop Emergency Page (WINDOWS)

Procedure sysop_emerg_win
Begin
   SysopLog('Paging Module: Procedure sysop_emerg_win')
   write(emergpass_msg)
   Stremerg := Input (15, 15, 1, '')

   If Stremerg = emergpass Then
		sysop_emerg_select_win
   
   Else If stremerg <> emergpass Then
      Begin
			writeln(emergincorrect_msg)
			halt
      End
End

// -----------------------------------------------------------------------------------------------------------------------
// Sysop OUT (LINUX)
 
Procedure sysopOUT
Begin
   SysopLog('Paging Module: Procedure sysopOUT')

   CLRSCR
   dispfile (ansi)

   writeln(prbarloc + prbarcolor + prtxtcolor + prbarlength + verloc + ver + avail + availhloc + availhours + tz)
   writeln(method_out)
   write(prbarcur)

	Str := Input (73, 73, 1, '')
	Str_TMP := WordGet(1,Str, ' ') // Removes Spaces from Str and stores in temp variable for checking below
	char_a := str2int(chrsize) // Sets char_a to the length from settings
	char_b := (Length(Str_TMP)) // Checks the length of string without spaces

   If Str = '' Then
      exit

   If char_b < char_a Then
		Begin
			writeln(pagemsgshort_str)
			exit
	  End

   If Str <> '' Then
		Begin
			black_avail
			writeln(method_out)
			writeln(sysopout_msg)
			mail()
		End

// Lightbar YES/NO (Emergency Password)

	If emergpwd_tog = 'on' then
		Begin
   		write(emergyesno_msg)
   		write(epromptno_msg)
   		prompt_track := 0
   		repeat
				prompt_input := Readkey

				If prompt_input = 'y' then
					Begin
						sysop_emerg
					End

				If prompt_input = #75 then // left arrow
					Begin
						prompt_track := 1
						write(epromptyes_msg)
					End

				If prompt_input = #77 then // right arrow
					Begin
						prompt_track := 0
						write(epromptno_msg)
					End

				If prompt_input = #13 and prompt_track = 1 then // Enter Key
					Begin
						sysop_emerg
						prompt_track := 1
					End

				If prompt_input = #13 and prompt_track = 0 then
					exit
			Until prompt_input = 'n'

	End

End

// -----------------------------------------------------------------------------------------------------------------------
// Sysop OUT (WINDOWS)
 
Procedure sysopOUT_win
Begin
	SysopLog('Paging Module: Procedure sysopOUT_win')

	CLRSCR
	dispfile (ansi)

	writeln(prbarloc + prbarcolor + prtxtcolor + prbarlength + verloc + ver + avail + availhloc + availhours + tz)
	writeln(method_out)
	write(prbarcur)

	Str := Input (73, 73, 1, '')
	Str_TMP := WordGet(1,Str, ' ') // Removes Spaces from Str and stores in temp variable for checking below
	char_a := str2int(chrsize) // Sets char_a to the length from settings
	char_b := (Length(Str_TMP)) // Checks the length of string without spaces

	If Str = '' Then
		exit

      If char_b < char_a Then
			Begin
				writeln(pagemsgshort_str)
				exit
			End

		If Str <> '' Then
			Begin
				black_avail
				writeln(method_out)
				writeln(sysopout_msg)
				mail()
			End

// Lightbar YES/NO (Emergency Password)

	If emergpwd_tog = 'on' then
		Begin
   		write(emergyesno_msg)
   		write(epromptno_msg)
   		prompt_track := 0
   		repeat
				prompt_input := Readkey

				If prompt_input = 'y' then
					Begin
						sysop_emerg
					End

				If prompt_input = #75 then // left arrow
					Begin
						prompt_track := 1
						write(epromptyes_msg)
					End

				If prompt_input = #77 then // right arrow
					Begin
						prompt_track := 0
						write(epromptno_msg)
					End

				If prompt_input = #13 and prompt_track = 1 then // Enter Key
					Begin
						sysop_emerg
						prompt_track := 1
					End

				If prompt_input = #13 and prompt_track = 0 then
					exit
			Until prompt_input = 'n'

	End

End

// ------------------------------------------------------------------------------------------------------------------------
// Sysop Alert Audio (LINUX)

Procedure sysop_alert_audio
Begin
	SysopLog('Paging Module: Procedure sysop_alert_audio_lin')
	SysopLog('Paging Module: Playing Audio File ' + snd_alert)
	
	If alert_ha_tog = 'on' Then
		Begin
			home_automation_alert()
		End
		
	menucmd('DD','sudo -b mpg123 -q ' + CFGMPEPATH + 'pmdata/sounds/' + snd_alert + ' >/dev/null 2>&1')
End

// ------------------------------------------------------------------------------------------------------------------------
// Sysop Alert Audio (WINDOWS)

Procedure sysop_alert_audio_win
Begin
	SysopLog('Paging Module: Procedure sysop_alert_audio_win')
	SysopLog('Paging Module: Playing Audio File ' + snd_alert)
	
	If alert_ha_tog = 'on' Then
		Begin
			home_automation_alert()
		End
		
	menucmd('DD','start /b ' + CFGMPEPATH + 'pmdata\bin\mpg123 -q ' + CFGMPEPATH + 'pmdata\sounds\' + snd_alert + '')
End

// ------------------------------------------------------------------------------------------------------------------------
// Sysop Alert Text (LINUX)

Procedure sysop_alert_text
Begin
	SysopLog('Paging Module: Procedure sysop_alert_text_lin')

	If page_method = 'txt' Then
		Begin
			SysopLog ('Paging Module: Sending Text Message Alert')
			alert_txt_lin()
		End
		
	If page_method = 'pushover' Then
		Begin
			SysopLog ('Paging Module: Sending Pushover Alert')
			alert_pushover_lin()
		End
End

// ------------------------------------------------------------------------------------------------------------------------
// Sysop Alert Text (WINDOWS)

Procedure sysop_alert_text_win
Begin
	SysopLog('Paging Module: Procedure sysop_alert_text_win')

	If page_method = 'txt' Then
		Begin
			SysopLog ('Paging Module: Sending Text Message Alert')
			alert_txt_win()
		End
		
	If page_method = 'pushover' Then
		Begin
			SysopLog ('Paging Module: Sending Pushover Alert')
			alert_pushover_win()
		End
End

// ------------------------------------------------------------------------------------------------------------------------
// Sysop Alert ALL (LINUX)

Procedure sysop_alert_all
Begin
	SysopLog('Paging Module: Procedure sysop_alert_all_lin')

	If page_method = 'txt' Then
		Begin
	      SysopLog ('Paging Module: Sending Text Message Alert')
			alert_txt_lin()
		End
		
	If page_method = 'pushover' Then
		Begin
			SysopLog ('Paging Module: Sending Pushover Alert')
			alert_pushover_lin()
		End
		
	If alert_ha_tog = 'on' Then
		Begin
			home_automation_alert()
		End	
		
		
	SysopLog ('Paging Module: Playing Alert Audio File ' + snd_alert)
	menucmd('DD','sudo -b mpg123 -q ' + CFGMPEPATH + 'pmdata/sounds/' + snd_alert + ' >/dev/null 2>&1')

End

// ------------------------------------------------------------------------------------------------------------------------
// Sysop Alert ALL (WINDOWS)

Procedure sysop_alert_all_win
Begin
	SysopLog('Paging Module: Procedure sysop_alert_all_win')

	If page_method = 'txt' Then
		Begin
	      SysopLog ('Paging Module: Sending Text Message Alert')
			alert_txt_win()
		End
		
	If page_method = 'pushover' Then
		Begin
			SysopLog ('Paging Module: Sending Pushover Alert')
			alert_pushover_win()
		End
		
		
	If alert_ha_tog = 'on' Then
		Begin
			home_automation_alert()
		End
			
	SysopLog ('Paging Module: Playing Alert Audio File ' + snd_alert)	
	menucmd('DD','start /b ' + CFGMPEPATH + 'pmdata\bin\mpg123 -q ' + CFGMPEPATH + 'pmdata\sounds\' + snd_alert + ' > nul')

End

// ------------------------------------------------------------------------------------------------------------------------
// Starts Sysop IN text (LINUX)

Procedure sysop_page_text
Begin
	SysopLog('Paging Module: Procedure sysop_page_text')
	SysopLog('Paging Module: Checking Chat Hours')

	If (str2int(time) >= cfgchatstart) and (str2int(time) <= cend_real) then
		sysopINtext
	Else
		sysopOUT

End

// ------------------------------------------------------------------------------------------------------------------------
// Starts Sysop IN text (WINDOWS)

Procedure sysop_page_text_win
Begin
	SysopLog('Paging Module: Procedure sysop_page_text_win')
	SysopLog('Paging Module: Checking Chat Hours')

   If (str2int(time) >= cfgchatstart) and (str2int(time) <= cend_real) then
      sysopINtext_win
   Else
      sysopOUT_win

End

//------------------------------------------------------------------------------------------------------------
// Starts Sysop IN audio (LINUX)

Procedure sysop_page_audio
Begin
	SysopLog('Paging Module: Procedure sysop_page_audio')
	SysopLog('Paging Module: Checking Chat Hours')

	If (str2int(time) >= cfgchatstart) and (str2int(time) <= cend_real) then
		sysopINaudio
   Else
		sysopOUT

End

//------------------------------------------------------------------------------------------------------------
// Starts Sysop IN audio (WINDOWS)

Procedure sysop_page_audio_win
Begin
	SysopLog('Paging Module: Procedure sysop_page_audio_win')
	SysopLog('Paging Module: Checking Chat Hours')

	If (str2int(time) >= cfgchatstart) and (str2int(time) <= cend_real) then
      sysopINaudio_win
   Else
      sysopOUT_win

End

//------------------------------------------------------------------------------------------------------------
// Starts Sysop IN all (LINUX)

Procedure sysop_page_all
Begin
	SysopLog('Paging Module: Procedure sysop_page_all')
	SysopLog('Paging Module: Checking Chat Hours')

   If (str2int(time) >= cfgchatstart) and (str2int(time) <= cend_real) then
		sysopINall

   Else
		sysopOUT

End

//------------------------------------------------------------------------------------------------------------
// Starts Sysop IN all (WINDOWS)

Procedure sysop_page_all_win
Begin
	SysopLog('Paging Module: Procedure sysop_page_all_win')
	SysopLog('Paging Module: Checking Chat Hours')

   If (str2int(time) >= cfgchatstart) and (str2int(time) <= cend_real) then
      sysopINall_win
   Else
      sysopOUT_win

End

// ------------------------------------------------------------------------------------------------------------
// Starts status message

Procedure sysop_status
Begin
	SysopLog('Paging Module: Procedure sysop_status')
	SysopLog('Paging Module: Checking Chat Hours')

	If (str2int(time) >= cfgchatstart) and (str2int(time) <= cend_real) then
		sysopINstatus
   Else
		sysopOUTstatus

End

// ------------------------------------------------------------------------------------------------------------
// ERROR MESSAGE

Procedure error
Begin
	SysopLog('Paging Module: Procedure error')

	CLRSCR
	writeln('|12ERROR!|CR|CR|07Please configure the following options.|CR|CRPage_Text - Text Message|CRPage_Audio - Audio Playback|CRPage_All - Text Messsage & Audio playback')
	writeln('Alert_Text - Text when somebody logs in|CRAlert_Audio - Alert via audio when somebody logs in|CRAlert_All - Alert via text & audio when somebody logs in')
	writeln('Status - Sysop Availability Message|CR|CRIn order to receive an email. Set it in the settings.')
	writeln('|CR|PA')

End

// ------------------------------------------------------------------------------------------------------------
// Blacklist Pass (LINUX)

Procedure black_pass
Begin
	SysopLog('Paging Module: Procedure black_pass')

	counter := lines

	Case Upper(ParamStr(1)) of
		'PAGE_TEXT'   : sysop_page_text;
		'PAGE_AUDIO'  : sysop_page_audio;
		'PAGE_ALL'    : sysop_page_all;
		'STATUS'      : sysop_status;
	End

End

// ------------------------------------------------------------------------------------------------------------
// Blacklist Pass (WINDOWS)

Procedure black_pass_win
Begin
	SysopLog('Paging Module: Procedure black_pass_win')

	counter := lines

	Case Upper(ParamStr(1)) of
		'PAGE_TEXT'   : sysop_page_text_win;
		'PAGE_AUDIO'  : sysop_page_audio_win;
		'PAGE_ALL'    : sysop_page_all_win;
		'STATUS'      : sysop_status;
	End

End

// ------------------------------------------------------------------------------------------------------------
// Blacklist Deny (LINUX)

Procedure black_deny
Begin
	SysopLog('Paging Module: Procedure black_deny')

	counter := lines

	Case Upper(ParamStr(1)) of
		'PAGE_TEXT'   : sysopout;
		'PAGE_AUDIO'  : sysopout;
		'PAGE_ALL'    : sysopout;
		'STATUS'      : sysopOUTstatus;
	End

End

// ------------------------------------------------------------------------------------------------------------
// Blacklist Deny (WINDOWS)

Procedure black_deny_win
Begin
	SysopLog('Paging Module: Procedure black_deny_win')

	counter := lines

	Case Upper(ParamStr(1)) of
		'PAGE_TEXT'   : sysopout_win;
		'PAGE_AUDIO'  : sysopout_win;
		'PAGE_ALL'    : sysopout_win;
		'STATUS'      : sysopOUTstatus;
	End

End

// ------------------------------------------------------------------------------------------------------------
// Blacklist Checker (LINUX)

Procedure check_blacklist
Begin
	SysopLog('Paging Module: Procedure check_blacklist')
	SysopLog ('Paging Module: Checking Blacklist For User')

	fAssign (blfile, CFGMPEPATH + 'data/cl_blacklist.txt', 30);
      freset (blfile)

		While Not fEof(blfile) Do
		Begin

			fReadLn(blfile,opt)

			If opt = UserAlias Then
				user := opt
			End
	fClose(blfile)

	If user = UserAlias Then
		Begin
			SysopLog ('Paging Module: User Found In Blacklist')
			black_deny()
		End

	If user <> UserAlias Then
		Begin
			SysopLog ('Paging Module: User Not Found In Blacklist')
			black_pass()
		End

End

// ------------------------------------------------------------------------------------------------------------
// Blacklist Checker (WINDOWS)

Procedure check_blacklist_win
Begin
	SysopLog('Paging Module: Procedure check_blacklist_win')
	SysopLog ('Paging Module: Checking Blacklist For User')

	fAssign (blfile, CFGMPEPATH + 'data\cl_blacklist.txt', 30);
      freset (blfile)

		While Not fEof(blfile) Do
			Begin

				fReadLn(blfile,opt)

				If opt = UserAlias Then
					user := opt
			
			End
	
	fClose(blfile)

	If user = UserAlias Then
		Begin
			SysopLog ('Paging Module: User Found In Blacklist')
			black_deny_win()
		End

	If user <> UserAlias Then
		Begin
			SysopLog ('Paging Module: User NOT Found In Blacklist')
			black_pass_win()
		End
		
End

// ------------------------------------------------------------------------------------------------------------
// Blacklist Start (LINUX)

Procedure start_blacklist
Begin
	SysopLog('Paging Module: Procedure start_blacklist')
	SysopLog ('Paging Module: Checking For Blacklist File')

	If FileExist(CFGMPEPATH + 'data/cl_blacklist.txt') then
		check_blacklist()
	Else
		black_pass()

End

// ------------------------------------------------------------------------------------------------------------
// Blacklist Start (WINDOWS)

Procedure start_blacklist_win
Begin
	SysopLog('Paging Module: Procedure start_blacklist_win')
	SysopLog ('Paging Module: Checking For Blacklist File')

	If FileExist(CFGMPEPATH + 'data\cl_blacklist.txt') then
		check_blacklist_win()
	Else
		black_pass_win()

End

// ------------------------------------------------------------------------------------------------------------
// ::: Main Program :::

SysopLog ('Paging Module: ' + UserAlias + ' Loaded The Paging Module.')	


	If FileExist(CFGMPEPATH + 'pmdata/settings.ini') Then // Checks if file settings.ini exists first
		settingsfile_exist := 'true'
	Else
		settingsfile_exist := 'false'
		
		
	If settingsfile_exist = 'false' Then // If settings.ini Is Not Found
		Begin
			clrscr
			SysopLog('Paging Module: Unable To Locate settings.ini')
			writeln('')
			writeln('|12*** Paging Module Error ***')
			writeln('')
			writeln('|07Unable to find settings.ini file!')
			writeln('')
			writeln('Confirm your "|15pmdata|07" |07directory exists under your themes script directory.')
			writeln('')
			writeln('Support: Clutch BBS (bbs.clutchbbs.com)')
			writeln('')
			write('|15Press Any Key To Continue')
			Readkey
			halt
	End
	
		
	If settingsfile_exist = 'true' Then // If settings.ini File Is Found
		Begin
		
			SysopLog('Paging Module: settings.ini file loaded from ' + CFGMPEPATH + 'pmdata/')

			fAssign (SetFile, CFGMPEPATH + 'pmdata/settings.ini', 60);
			freset (SetFile)

			Begin
				While Not fEof(SetFile) Do
					Begin

						fReadLn(SetFile,opt)
						KeyWord:=Upper(WordGet(1,opt,'='))

						Case KeyWord of

							'ANSI'                  : ansi := WordGet(2, opt, '=')						// Ansi File
							'AVAIL'                 : avail := WordGet(2,opt, '=')						// Availability (text/message)
							'AVAIL_BL'              : avail_bl := WordGet(2,opt, '=')					// Availability Blacklist (text/message)
							'AVAILHLOC'					: availhloc := WordGet(2,opt, '=')              // Ansi Location                  
							'TZ'							: tz := WordGet(2,opt, '=')   						// Timezone Message
							'SYSOPNAME'             : sysopname := WordGet(2,opt, '=')					// Sysop Name
							'SND_PAGE'              : snd_page := WordGet(2,opt, '=')					// Page Sound
							'SND_PAGE_EMERG'        : snd_page_emerg := WordGet(2,opt, '=')   		// Page Emergency Sound
							'SND_ALERT'             : snd_alert := WordGet(2,opt, '=')		   		// Sound Alert
							'METHOD_TEXT'           : method_text := WordGet(2,opt, '=')				// Type of Page
							'METHOD_AUDIO'          : method_audio := WordGet(2,opt, '=')   			// Type of Page
							'METHOD_ALL'            : method_all := WordGet(2,opt, '=')					// Type of Page
							'METHOD_OUT'            : method_out := WordGet(2,opt, '=')					// Type of Page
							'PRBARLOC'              : prbarloc := WordGet(2,opt, '=')					// Prompt Bar location
							'PRBARCUR'              : prbarcur := WordGet(2,opt, '=')					// Prompt Bar Cursor Location
							'PRBARLENGTH'           : prbarlength := WordGet(2,opt, '=')				// Prompt Bar Length
							'PRBARCOLOR'            : prbarcolor := WordGet(2,opt, '=')					// Prompt Bar Color
							'PRBARCLEAR'            : prbarclear := WordGet(2,opt, '=')					// Prompt Bar Clear
							'ANIBARBG'              : anibarbg := WordGet(2,opt, '=')					// Animation Bar Background Color
							'ANIBARFG'              : anibarfg := WordGet(2,opt, '=')					// Animation Bar Foreground Color
							'SYSOPPAGE_MSG'         : sysoppage_msg := WordGet(2,opt, '=')				// Sysop Page Message
							'SYSOPOUT_MSG'          : sysopout_msg := WordGet(2,opt, '=')				// Sysop Out Message
							'EMERGYESNO_MSG'        : emergyesno_msg := WordGet(2,opt, '=')			// Emergency YES/NO Message
							'EMERGPASS_MSG'         : emergpass_msg := WordGet(2,opt, '=')				// Emergency Password Message
							'EMERGINCORRECT_MSG'    : emergincorrect_msg := WordGet(2,opt, '=')		// Emergency Incorrect Password Message
                  	'SYSOPMAIL_MSG'         : sysopmail_msg := WordGet(2,opt, '=')				// Sysopmail Message
							'SYSOPINSTATUS_MSG'     : sysopinstatus_msg := WordGet(2,opt, '=')		// Sysop IN Status Message
							'SYSOPOUTSTATUS_MSG'    : sysopoutstatus_msg := WordGet(2,opt, '=')		// Sysop OUT Status Message
							'EMERGPASS'             : emergpass := WordGet(2,opt, '=')              // Emergency Password
							'VERLOC'						: verloc := WordGet(2,opt, '=')						// Version Location
							'ESMTP'						: esmtp := WordGet(2,opt, '=')						// SMTP Address
							'EPORT'						: eport := WordGet(2,opt, '=')						// SMTP Port
							'EMAIL'						: email := WordGet(2,opt, '=')						// Email Address
							'EPASS'						: epass := WordGet(2,opt, '=')						// Email Password
							'FEMAIL'						: femail := WordGet(2,opt, '=')						// Email From Address
							'CELLNUMB'					: cellnumb := WordGet(2,opt, '=')					// Mobile Cell Number
							'CELLGATEWAY'				: cellgateway := WordGet(2,opt, '=')				// Mobile Cell Gateway
							'PAGE_METHOD'				: page_method := WordGet(2,opt, '=')				// Page Method
							'PATOKEN'					: patoken := WordGet(2,opt, '=')						// Pushover Application Token
							'PUTOKEN'					: putoken := WordGet(2,opt, '=')						// Pushover User Token
							'PDEVICE'					: pdevice := WordGet(2,opt, '=')						// Pushover Device Name
							'PPRIORITY'					: ppriority := WordGet(2,opt, '=')					// Pushover Priority (Not In Use)
							'EMAIL_TOG'					: email_tog := WordGet(2,opt, '=')					// Email Toggle
							'EMERGPWD_TOG'				: emergpwd_tog := WordGet(2,opt, '=')				// Emergency Password Toggle
							'SYSOPMSG_TOG'				: sysopmsg_tog := WordGet(2,opt, '=')				// Sysop Message Toggle
							'CHRSIZE'					: chrsize := WordGet(2,opt, '=')						// Page Character Length
							//'OS'							: os := WordGet(2,opt, '=')							// OS (Windows/Linux)
							'PAGEMSGSHORT_STR'		: pagemsgshort_str := WordGet(2,opt, '=')			// Page Message Too Short
							'PROMPTYES_MSG'         : promptyes_msg := WordGet(2,opt, '=')				// Prompt YES Message (Lightbar)
							'PROMPTNO_MSG'          : promptno_msg := WordGet(2,opt, '=')				// Prompt NO Message (Lightbar)
							'EPROMPTYES_MSG'			: epromptyes_msg := WordGet(2,opt, '=')			// Emergency Prompt YES (Lightbar)
							'EPROMPTNO_MSG'			: epromptno_msg := WordGet(2,opt, '=')				// Emergency Prompt NO (Lightbar)
							'PAGE_HA_TOG'				: page_ha_tog := WordGet(2,opt, '=')				// Home Automation Page Toggle
							'PAGE_HA_URL'				: page_ha_url := opt										// Home Automation Page URL
							'ALERT_HA_TOG'				: alert_ha_tog := WordGet(2,opt, '=')				// Home Automation Alert Toggle
							'ALERT_HA_URL'				: alert_ha_url := opt									// Home Automation Alert URL

							End
						End
							
						fClose(SetFile)
						
						
// Check OS	and set variable
	
	If OSType = 0 or OSType = 4 Then  // Windows or OS/2
			os := 'windows'
	Else 
			os := 'linux'
			

// ------------ Check OS and sends to OS procedures ------------

	If os = 'linux' Then
		Begin
			Case Upper(ParamStr(1)) of

			'PAGE_TEXT'   : start_blacklist;
			'PAGE_AUDIO'  : start_blacklist;
			'PAGE_ALL'    : start_blacklist;
			'ALERT_AUDIO' : sysop_alert_audio;
			'ALERT_TEXT'  : sysop_alert_text;
			'ALERT_ALL'   : sysop_alert_all;
			'STATUS'      : start_blacklist;

			Else
				error
		End
   
	End
	

	If os = 'windows' Then
		Begin
		Case Upper(ParamStr(1)) of

			'PAGE_TEXT'   : start_blacklist_win;
			'PAGE_AUDIO'  : start_blacklist_win;
			'PAGE_ALL'    : start_blacklist_win;
			'ALERT_AUDIO' : sysop_alert_audio_win;
			'ALERT_TEXT'  : sysop_alert_text_win;
			'ALERT_ALL'   : sysop_alert_all_win;
			'STATUS'      : start_blacklist_win;

			Else
				error
		End
   End
	
// ------------ END OF CHECK OS ------------
 
 
		End // End of File settings.ini check

End
End
