# -*- coding: utf-8 -*-

# -----------------------------------------------
# ACiDiC presents: Fox News Alert
# author: Lawrence Manuel (aka Smooth)
# contact email: smooth@inktwo.com
# release date: October 15, 2017
# -----------------------------------------------

# -----------------------------------------------
# required Python Modules
# -----------------------------------------------

import os
import ConfigParser
import xmltodict
import urllib
import datetime
import textwrap


# -----------------------------------------------
# variable declarations
# -----------------------------------------------

config = ConfigParser.ConfigParser()
config.read(os.path.dirname(os.path.abspath(__file__)) + '/sm-foxnews.cfg')
titleName = config.get('Fox News Config', 'titleName')
outputFileName = config.get('Fox News Config', 'outputFileName')
rss = 'http://feeds.foxnews.com/foxnews/latest'
rssUrl = urllib.urlopen(rss)
rssData = xmltodict.parse(rssUrl)
rssUrl.close()

# -----------------------------------------------
# generate Fox News Alert
# -----------------------------------------------

textFile = open(outputFileName, 'w')

textFile.write('|CL|09-------------------------------------------------------------------------------|CR')
textFile.write('|17|07>>|15 ' + titleName + ' |16|07:|12 generated on ' + '{:%b %d, %Y}'.format(
    datetime.date.today()) + ' |14@|12 ' + datetime.datetime.now().time().strftime('%I:%M:%S %p') + ' |CR')
textFile.write('|09-------------------------------------------------------------------------------|CR')


for index, item in enumerate(rssData['rss']['channel']['item']):
    # print(title['title']);
    textFile.write('|17|15 FOX |16|07 ' + textwrap.fill(item['title'], width=73) + '|CR')
    try:
        textFile.write('|04posted: .(|15' + item['pubDate'] + '|04).|CR')
    except KeyError:
        textFile.write('\n')
    try:
        stopPos = item['description'].find('<div')
        if index < 2:
            textFile.write('|12' + textwrap.fill(item['description'][:stopPos], width=79).encode('utf-8') + '|07|CR|CR')
        else:
            textFile.write('|12' + textwrap.fill(item['description'][:stopPos], width=79).encode('utf-8') + '|07|CR')
    except KeyError:
        textFile.write('|CR')
    if index == 2:
        textFile.write('|09-------------------------------------------------------------------------------|CR')
        textFile.write('|[X13|15/. |07Mystic BBS Python Mod developed by Smooth.ACiDiC |15.\|CR')
        textFile.write('|09-------------------------------------------------------------------------------|CR')
        textFile.write('|PA')
        break
textFile.close()
