# -*- coding: utf-8 -*-

# -----------------------------------------------
# ACiDiC presents: CNN Headlines
# author: Lawrence Manuel (aka Smooth)
# contact email: smooth@inktwo.com
# release date: October 13, 2017
# -----------------------------------------------

# -----------------------------------------------
# required Python Modules
# -----------------------------------------------

import os
import ConfigParser
import xmltodict
import urllib
import datetime
import textwrap


# -----------------------------------------------
# variable declarations
# -----------------------------------------------

config = ConfigParser.ConfigParser()
config.read(os.path.dirname(os.path.abspath(__file__)) + '/sm-cnn-headlines.cfg')
bbsName = config.get('CNN Headlines Config', 'bbsName')
outputFileName = config.get('CNN Headlines Config', 'outputFileName')
rss = 'http://rss.cnn.com/rss/cnn_topstories.rss'
rssUrl = urllib.urlopen(rss)
rssData = xmltodict.parse(rssUrl)
rssUrl.close()

# -----------------------------------------------
# generate CNN Headlines
# -----------------------------------------------

textFile = open(outputFileName, 'w')

textFile.write('|CL|02-------------------------------------------------------------------------------|CR')
textFile.write('|20|12>>|15 ' + bbsName + ' CNN Headlines |16|07|04:|10 generated on ' + '{:%b %d, %Y}'.format(
    datetime.date.today()) + ' |14@|10 ' + datetime.datetime.now().time().strftime('%I:%M:%S %p') + ' |CR')
textFile.write('|02-------------------------------------------------------------------------------|CR')


for index, item in enumerate(rssData['rss']['channel']['item']):
    # print(title['title']);
    textFile.write('|20|15 CNN |16|07 ' + textwrap.fill(item['title'], width=73) + '|CR')
    try:
        textFile.write('|03posted: .(|15' + item['pubDate'] + '|03).|CR')
    except KeyError:
        textFile.write('\n')
    try:
        stopPos = item['description'].find('<div')
        textFile.write('|02' + textwrap.fill(item['description'][:stopPos], width=79).encode('utf-8') + '|07|CR|CR')
    except KeyError:
        textFile.write('|CR')
    if index == 2:
        textFile.write('|02-------------------------------------------------------------------------------|CR')
        textFile.write('|[X13|15/. |07Mystic BBS Python Mod developed by Smooth.ACiDiC |15.\|CR')
        textFile.write('|02-------------------------------------------------------------------------------')
        textFile.write('|CR|PA')
        break
textFile.close()
