/*****************************************************************************
 *
 * $Id: safe-tool.c,v 1.1 2003/02/22 15:17:54 mbroek Exp $
 * Purpose ...............: Safe Door maintenance tool
 *
 *****************************************************************************
 * Copyright (C) 2003
 *   
 * Michiel Broek		FIDO:		2:280/2802
 * Beekmansbos 10
 * 1971 BV IJmuiden
 * the Netherlands
 *
 * This file is part of Safe Cracker door.
 *
 * This door is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Safe Cracker is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MBSE BBS; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "../config.h"
#include <stdlib.h>
#include <doorlib.h>
#include "safe-tool.h"


char    *logfile = NULL;
char    *bbsname = NULL;
long	digit1 = 0;
long	digit2 = 0;
long	digit3 = 0;
long	maxtries = 0;
long	maxnumber = 0;
long	numgenerator = 0;
char	*prize = NULL;
char	*welcome = NULL;
char	*opened = NULL;
char	*workdir = NULL;

keytab_t keytab[] = {
    {(char *)"logfile",     door_parse_getstr,      (char **)&logfile},
    {(char *)"bbsname",     door_parse_getstr,      (char **)&bbsname},
    {(char *)"digit1",	    door_parse_getlong,	    (char **)&digit1},
    {(char *)"digit2",      door_parse_getlong,     (char **)&digit2},
    {(char *)"digit3",      door_parse_getlong,     (char **)&digit3},
    {(char *)"maxtries",    door_parse_getlong,	    (char **)&maxtries},
    {(char *)"maxnumber",   door_parse_getlong,	    (char **)&maxnumber},
    {(char *)"prize",	    door_parse_getstr,	    (char **)&prize},
    {(char *)"welcome",	    door_parse_getstr,	    (char **)&welcome},
    {(char *)"opened",	    door_parse_getstr,	    (char **)&opened},
    {(char *)"workdir",	    door_parse_getstr,	    (char **)&workdir},
    {(char *)"numgenerator",door_parse_getlong,	    (char **)&numgenerator},
    {NULL,                  NULL,                   NULL}
};


void	tool(char *);



int main(int argc, char **argv)
{
    /*
     * Initialize and load configuration.
     */
    if (argc != 2) {
	fprintf(stderr, "Usage: %s /path/to/configfile\n\n", argv[0]);
	exit(1);
    }
    if (door_parse_config(argv[1], keytab)) {
	fprintf(stderr, "Parsing configuration failed\n\n");
	exit(1);
    }
    door_loginit(logfile, (char *)"safe-tool", FALSE);
    door_log(' ', "");
    door_log(' ', "SAFE-TOOL v%s started", VERSION);
    door_log('+', "User starts Safe Cracker maintenance tool");

    fprintf(stdout, "SAFE-TOOL v%s\n", VERSION);
    fprintf(stdout, "%s\n\n", COPYRIGHT);
    tool(argv[1]);

    door_log(' ', "SAFE-TOOL finished");
    return 0;
}



void tool(char *config)
{
    FILE    *fp;
    char    *temp;
    int	    records = 0, cracked = FALSE;

    if (numgenerator) {
	fprintf(stdout, "Safe combination : Random generated\n");
    } else {
	fprintf(stdout, "Safe combination : %ld %ld %ld\n", digit1, digit2, digit3);
    }
    fprintf(stdout, "Maximum tries ...: %ld\n", maxtries);
    fprintf(stdout, "Maximum number ..: %ld\n", maxnumber);
    fprintf(stdout, "Prize ...........: %s\n\n", prize);

    temp = calloc(PATH_MAX, sizeof(char));
    sprintf(temp, "%s/safe.data", workdir);

    if ((fp = fopen(temp, "r+")) == NULL) {
	fprintf(stdout, "There is no safe.data file, the door is never used!\n\n");
	free(temp);
	return;
    }
    fread(&safehdr, sizeof(safehdr), 1, fp);
    while (fread(&safe, safehdr.recsize, 1, fp) == 1) {
	records++;
    }
    if (!records) {
	fclose(fp);
	free(temp);
	fprintf(stdout, "There are no records in the safe.data file!\n\n");
	return;
    }
    
    fprintf(stdout, "Date         User                                 Trys Opened\n");
    fprintf(stdout, "------------ ------------------------------------ ---- ------\n");
    fseek(fp, safehdr.hdrsize, SEEK_SET);

    while (fread(&safe, safehdr.recsize, 1, fp) == 1) {
	fprintf(stdout, "%-12s %-36s %4d %s\n", safe.Date, safe.Name, safe.Trys, safe.Opened?"Yes":"No");
	if (safe.Opened) {
	    cracked = TRUE;
	    door_log('+', "The safed is cracked by user %s", safe.Name);
	}
    }
    if (!cracked) {
	fclose(fp);
	free(temp);
	fprintf(stdout, "\nNobody has cracked the safe yet!\n\n");
	return;
    }

    /*
     * The safe is cracked, option to reset the safe.
     */
    fprintf(stdout, "\nThe safe is cracked, reset the safe [y/N]: ");
    fflush(stdout);
    if (toupper(getchar()) == 'Y') {

	fseek(fp, safehdr.hdrsize, SEEK_SET);
	while (fread(&safe, safehdr.recsize, 1, fp) == 1) {
	    if (safe.Opened) {
		door_log('+', "Resetting safe record of user %s", safe.Name);
		fprintf(stdout, "Resetting safe record of user %s\n", safe.Name);
		safe.Trys = 0;
		safe.Opened = FALSE;
		fseek(fp, - safehdr.recsize, SEEK_CUR);
		fwrite(&safe, safehdr.recsize, 1, fp);
	    }
	}

	if (!numgenerator) {
	    fprintf(stdout, "*** REMEMBER, edit %s to enter a new combination\n", config);
	}
    }

    fclose(fp);
    free(temp);
    fprintf(stdout, "\n");
}


