#!/bin/sh
#
#  AMC (Automatic Message Creator) installation script
#    (c) 2004/11/06  -  J/D.H. Beekhuizen
#

#  Version number
VERSION=0.99.3/Linux

declare -i Count

# some useful functions

#  Request displays the first parameter, and asks a new value for 
#  variable, which name is # in the second parameter

Request ()
{
qvar=$2
eval oldvar=\$$qvar
eval echo -n \""$1 [$oldvar] : "\" 
read $qvar
eval test -z \"\$$qvar\" && eval $qvar=\'$oldvar\'
}

#  YesNo gives you value 1 on "no", value 0 on "yes"
#  The parameter specifies the text to display

YesNo ()
{
	while true
		do
		echo -n "$1 (Y/n) ? "
		read qans
		case Q$qans in
			Q|Qy|QY) return 0;;
			Qn|QN)   return 1;;
		esac
	done
}

#  Well...
#

Sorry ()
{
	echo
	echo "I'm sorry I couldn't be of any help."
	echo
}

#  Things could go wrong...
#

InstallProblem ()
{
	echo
	echo "The 'install' utility returned an error."
	echo "Unable to proceed!"
	echo
	if [ "" = "True" ]
		then
		rm -rf  2>&1 > /dev/null
	fi
	exit 7
}

LinkProblem ()
{
	echo
	echo "The symbolic link could not be made."
	echo "Please investigate this and do it manually."
	echo
}
	
#  You must be root to use this script
#

if [ "`id -un`" != "root" ]
    then
    echo
	echo "You must be root to install AMC for general use!"
	echo "Please read 00INSTALL for instructions on installation."
	echo
	exit 3
fi


#  Blurb
#

clear
echo
echo "This script will install"
echo "Automatic Message Creator  v$VERSION"
echo "for general use."
echo

#  The default is to install in /opt/amc

PREFIX=/opt

#  Get the installation directory

Request "Please specify the directory to install AMC in" PREFIX
AMC_ROOT=$PREFIX/amc

#  Check if it exists already

if [ -d $AMC_ROOT ]
	then
	echo
	echo "There already exists a directory $AMC_ROOT."
	if YesNo "Do you want to overwrite it"
		then
		if YesNo "Are you absolutely sure"
			then
			AMC_New=False
			Count=10
			while [ $Count -gt 0 ]
				do
				echo -en "Starting in $Count seconds; use <Ctrl>C to bail out "\\r
				sleep 1
				Count=$(($Count-1))
			done
			echo
			echo
			echo "Any existing default configuration files will be saved as *.sav"
			echo
		else
			Sorry
		fi
	else
		Sorry
	fi
else
	AMC_New=True
fi
	
#  OK, now do the installation
#

#  Save old default configuration files
#

if [ "$AMC_New" = "False" ]
	then
	for ff in amc.cfg amc.txt amcbirth.day
		do
		mv $AMC_ROOT/etc/$ff $AMC_ROOT/etc/$ff.sav
	done
fi

#  Make the directories
#

install -o root -g root -m 755 -d $AMC_ROOT      ||  InstallProblem
install -o root -g root -m 755 -d $AMC_ROOT/bin  ||  InstallProblem
install -o root -g root -m 755 -d $AMC_ROOT/doc  ||  InstallProblem
install -o root -g root -m 755 -d $AMC_ROOT/etc  ||  InstallProblem
install -o root -g root -m 755 -d $AMC_ROOT/log  ||  InstallProblem

#  Install the contents			
#

install -o root -g root -m 755 -s bin/* $AMC_ROOT/bin
install -o root -g root -m 644 doc/* $AMC_ROOT/doc
install -o root -g root -m 644 etc/* $AMC_ROOT/etc
install -o root -g root -m 666 /dev/null $AMC_ROOT/log/amc.log

#  Installation done
#

echo
echo "The installation is finished."
echo "The executable file is:                  " $AMC_ROOT/bin/amc
echo "The default configuration files are in:  " $AMC_ROOT/etc
echo "The default log file is:                 " $AMC_ROOT/log/amc.log
echo "Documentation is in:                     " $AMC_ROOT/doc

#  Make a link?
#

echo
echo "It's possible to create a symbolic link to AMC"
echo "in either /usr/local/bin or /usr/bin"
echo

if YesNo "Do you want to create a symbolic link in /usr/local/bin"
	then
	ln -sf $AMC_ROOT/bin/amc /usr/local/bin/amc  ||  LinkProblem
else
	if YesNo "Do you want to create a symbolic link in /usr/bin"
		then
		ln -sf $AMC_ROOT/bin/amc /usr/bin/amc    ||  LinkProblem
	fi
fi

echo
echo "AMC is now installed and ready for use."
echo "Please change the configuration to your own needs."
echo
echo "Have fun with it!"
echo
