/*
 * Xitami for OS/2 v2.x WPfolder Installation Program copyright (c) 1998
 * by Scott Drake of Innovative Solutions Online 1:2630/212
 * sdrake@isonline.com
 *
 * This program creates a folder to hold program objects for Xitami/2, then
 * creates program objects for each executable.  It only needs to be run once
 * (unless you move the Xitami/2 directory -- see say notes at end). Run this
 * program in the Xitami/2 directory (where you unpacked the archive).
 */

/* see if we might be in the right directory... */

'@Echo off'
'cls'

say''
say''
say'[0;1;34;44m[0;30;44m[40m'
say'[1;34;44m [0;30;44m [40m'
say'[1;34;44m             [33mXitami for OS/2 v2.x WPfolder Installation Program           [0;30;44m [40m'
say'[1;34;44m                     [36mCopyright (c) 1998 by [31mScott Drake                    [0;30;44m [40m'
say'[1;34;44m          [33mXitami Web Server [36mis Copyright (c) 1991, 1998 by [31miMatix         [0;30;44m [40m'
say'[1;34;44m                            [36mAll rights reserved                           [0;30;44m [40m'
say'[1;34;44m [0;30;44m [40m'
say'[1;34;44m [0;30;44m[1;34m [0;30;44m[40m'
say'[1;34;44m [0;30;44m     [1;37mXitami is Free software and comes with ABSOLUTELY NO WARRANTY.      [34m [0;30;44m[40m'
say'[1;34;44m [0;30;44m     [1;37mYou may redistribute this software under certain conditions,        [34m [0;30;44m[40m'
say'[1;34;44m [0;30;44m     [1;37mread the file LICENSE.TXT for details.                              [34m [0;30;44m[40m'
say'[1;34;44m [0;30;44m[1;34m [0;30;44m[40m'
say'[1;34;44m[0;30;44m[0m'

/*
 * allow user to eliminate associations from being placed on AV/2.
 * seemed to upset some fellow on CIS (I guess he doesn't know about
 * Settings notebooks on WPS objects).
 */
assocfilter = ';ASSOCFILTER=*.ZIP,*.ARC,*.LZH,*.ARJ,*.ZOO,*.MO0,READ.ME,README,README.1ST,README.OS2,REGISTER.TXT'
existed = ''
parse upper arg dummy
if dummy = 'NOASSOC' then assocfilter = ''

rc = stream('xitami.exe','c','query exists')
if rc = '' then
do
  say '[0;1;31mSorry, Xitami.EXE not found.  Must not be right directory.  Terminating.[0m'
  exit
end

/* tell user what we're doing, give him a chance to hit CTRL-C */
say''
say''
say '       [1;33mThis program creates Desktop objects for Xitami. If you do not want'
say '       [1;33mcreate the Desktop Objects, just press CTRL + C then press Enter.'
say ''


say''
say '         [0;1;35mOtherwise Press [Enter] to continue with the Installation...[0m'
pull dummy .
say ''


/* save current directory */

curdir = directory()

/* load rexx utility functions */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* say it, then do it */

'cls'
say "[0;1;5;31mCreating The Xitami for OS/2 folder and objects...[0m"

/* first, create Xitami folder */

rc = stream('xitami.ico','c','query exists')
title = "Xitami for OS/2^Web Server"
classname = 'WPFolder'
location = '<WP_DESKTOP>'
setup = 'OBJECTID=<Xitami_Folder>;OPEN=DEFAULT'
if rc \= '' then setup = setup';ICONFILE='rc
result=SysCreateObject(classname,title,location,setup,r)

/* Check to see if the Xitami Folder already exists... */
if result = 0 then
do
  assocfilter = ''
  existed = 'TRUE'
  say ''
  say '[0;1;31mThe Xitami for OS/2 folder already exists.'
  say '[33mShould I update the objects? (Y/n)[0m'
  parse upper pull dummy
  if left(dummy,1) = 'N' then exit
  say ''
end

/* now, create program objects in Xitami folder */

title = "Xitami for OS/2"
classname = 'WPProgram'
location = '<Xitami_Folder>'
setup = 'PROGTYPE=WINDOWABLEVIO;OBJECTID=<Xitami for OS/2>;EXENAME='curdir'\XITAMI.EXE;STARTUPDIR='curdir
if existed = '' then setup = setup';PARAMETERS='
call SysCreateObject classname,title,location,setup,u

rc = stream('license.ico','c','query exists')
title = "Xitami License"
classname = 'WPProgram'
location = '<Xitami_Folder>'
setup = 'OBJECTID=<Xitami License>;EXENAME=e.exe;PARAMETERS='curdir'\LICENSE.TXT;STARTUPDIR='curdir
if rc \= '' then setup = setup';ICONFILE='rc
call SysCreateObject classname,title,location,setup,u

rc = stream('readme.ico','c','query exists')
title = "Xitami for OS/2^ Read Me First"
classname = 'WPProgram'
location = '<Xitami_Folder>'
setup = 'OBJECTID=<Xitami for OS/2 Read Me First>;EXENAME=e.exe;PARAMETERS='curdir'\readme;STARTUPDIR='curdir
if rc \= '' then setup = setup';ICONFILE='rc
call SysCreateObject classname,title,location,setup,u

rc = stream('readme.ico','c','query exists')
title = "Xitami for OS/2^ Read Me Text"
classname = 'WPProgram'
location = '<Xitami_Folder>'
setup = 'OBJECTID=<Xitami for OS/2 Read Me Text>;EXENAME=e.exe;PARAMETERS='curdir'\readme.txt;STARTUPDIR='curdir
if rc \= '' then setup = setup';ICONFILE='rc
call SysCreateObject classname,title,location,setup,u



/* Final words */

'cls'

say ''
say ''
say ''
say ''
say ''
say ' [0;1;34;44m[40m'
say '[A[79C[0;30;44m[1C[1;34m [0;30;44m [40m'
say '[A[79C[44m[1C[1;34m      [36mThe Xitami for OS/2 DeskTop folder and Icons are now installed.     [0;30;44m [40m'
say '[A[79C[44m[1C[1;34m    [36mWe hope you Enjoy Xitami, report any problems to xitami@imatix.com.   [0;30;44m [40m'
say '[A[79C[44m[1C[1;34m [0;30;44m [40m'
say '[A[79C[0;30;44m[1C[1;34m[0;30;44m[40m'
say '[A[79C[44m[0m'

