#
# TEEFAX FOR BBS
#
# (c) 2020 shinobi
#
# + Blue, Magenta
# + subpages navigation (p)prev,(n)ext
#

DEBUG=0
HELP=1
dirname='/bbs/doors/teefax/pages'

from time import localtime, strftime
import datetime
import curses
import os
import sys
import re
import traceback
import requests
from bs4 import BeautifulSoup

wi=None # width
hwi=None # half screen width
scrx=0
scry=0
nw=None

WHITE=1
CYAN=2
RED=3
BLACK=4
GREEN=5
YELLOW=6
MAGENTA=7
BLUE=8

def getUserAgent():
  ua='Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2225.0 Safari/537.36'
  return(ua)

def getFName(pageNo):
  ret=dirname+'/'+'teefax_'+str(pageNo)+'.txt'
  return(ret)

def touchFile(pageNo):
  with open(getFName(pageNo), 'w') as f:
    f.write('')

def getFromFile(pageNo):
  with open(getFName(pageNo), 'r') as f:
    txt=f.read()
  return(txt)

def prn(strng,end='\n',clr=0,sx=0,sy=0,bold=0):
  global scrx, scry, nw, wi
  if end!='\n':
    strng+=end
  w=len(strng)
  if (bold==1):
    nw.addstr(scry+sy,scrx+sx,strng,curses.color_pair(clr)|curses.A_BOLD)
  else:
    nw.addstr(scry+sy,scrx+sx,strng,curses.color_pair(clr))
  scrx+=w
  if end=='\n':
    scrx=0
    scry+=1
  nw.move(0,wi-1)

def extractCharacters(inpStr):
  res=""
  for i in inpStr:
    #if i.isalpha() \
    #or i == " " \
    #or (ord(i)>=ord('0') and ord(i)<=ord('9')) \
    #or i == "|" \
    #or i == ".":
    if ord(i)>=32 and ord(i) <= 126:
      res = "".join([res, i])
  return(res)

def pageToText(pageNo,subPageNo=1):
  dpage=[]
  pagestr=''
  getPage(pageNo)
  pg=getFromFile(pageNo)
  currentPage=0
  lineno=0
  thisPage=0
  sy=0
  pages=0
  subPagesAvail=0
  firstPage=0
  for line in pg.split('\n'):
    m = re.search('^SC.*', line)
    if m:
      subPagesAvail+=1
  for line in pg.split('\n'):
    m = re.search('^SC.*', line)
    if m:
      currentPage=re.sub('^SC,([0-9]+)', r'\1',line)
      if firstPage==0 and currentPage != 0:
        firstPage=currentPage
        break
  if int(subPageNo)>=subPagesAvail:
    subPageNo=subPagesAvail
  if subPagesAvail==1 and subPageNo != firstPage:
    subPageNo=firstPage
  if DEBUG==1:
    nw.addstr(16,48,"pageNo "+str(subPageNo),curses.color_pair(WHITE)|curses.A_NORMAL)
    nw.addstr(17,48,"pageNo "+str(subPagesAvail),curses.color_pair(WHITE)|curses.A_NORMAL)
  for line in pg.split('\n'):
    sx=0
    m = re.search('^SC.*', line)
    if m:
      currentPage=re.sub('^SC,([0-9]+).*', r'\1',line)
      if int(currentPage)==int(subPageNo):
        thisPage=1
      elif int(currentPage)!=int(subPageNo):
        thisPage=0
    if "OL," in line[:3] and thisPage==1:
      #line = re.sub('OL,([0-9]+),'+chr(27)+'Q.*', r'\1|',line)
      #line = re.sub('OL,([0-9]+),'+chr(27)+'Q.*', r'',line) #
      lineno = re.sub('^OL,([0-9]+).*', r'\1',line)
      #line = re.sub('OL,([0-9]+)', r'\1|',line)
      line = re.sub('OL,([0-9]+),', r'',line)
      #resline=extractCharacters(line) 
      resline=line
      clr=WHITE
      cc=0 # current char
      if sy==0:
        dt=datetime.datetime.now()
        strdt=dt.strftime(" %a %d %b")
        strtm=dt.strftime("%H:%M")
        hdr01=str(pageNo)+"/"+"{:02d}".format(int(subPageNo))+"/"+str(subPagesAvail)+" TEEFAX " + str(pageNo) + strdt
        hdr02=strtm
        nw.addstr(0,0,hdr01,curses.color_pair(WHITE)|curses.A_BOLD)
        nw.addstr(0,32,hdr02,curses.color_pair(YELLOW)|curses.A_BOLD)
      else:
        while cc < len(resline):
          escch=0
          if resline[cc]==chr(27) and cc<len(resline)-3:
            if resline[cc+1]=='A':
              clr=RED
              sx+=1
            elif resline[cc+1]=='B':
              clr=GREEN
              sx+=1
            elif resline[cc+1]=='C':
              clr=YELLOW
              sx+=1
            elif resline[cc+1]=='F':
              clr=CYAN
              sx+=1
            elif resline[cc+1]=='D': # 
              clr=BLUE
              sx+=1
            elif resline[cc+1]=='E': # 
              clr=MAGENTA
              sx+=1
            elif resline[cc+1]=='G':
              clr=WHITE
              sx+=1
            # NOT IMPLEMENTED
            elif resline[cc+1]=='V': # 
              clr=WHITE
            elif resline[cc+1]=='Q': # 
              clr=WHITE
            elif resline[cc+1]=='R': # 
              clr=WHITE
            elif resline[cc+1]=='T': # 
              clr=WHITE
            elif resline[cc+1]==']': # 
              clr=WHITE
            elif resline[cc+1]=='M': # 
              clr=WHITE
            elif resline[cc+1]=='F': # 
              clr=WHITE
            elif resline[cc+1]=='P': # 
              clr=WHITE
            cc+=2
            escch=1
          if resline[cc]==chr(27):
            cc+=1
          if (int(lineno)<he and sx<wi):
            #nw.addstr(sy,sx,resline[cc],curses.color_pair(clr)|curses.A_BOLD)
            nw.addstr(int(lineno),sx,resline[cc],curses.color_pair(clr)|curses.A_BOLD)
            a=1
          if escch==0:
            cc+=1
            sx+=1
        #nw.addstr(int(lineno),0,str(lineno),curses.color_pair(WHITE)|curses.A_BOLD)
      dpage.append(resline) 
      sy+=1
  pagestr='\n'.join(dpage)
  return(pagestr)
    
def getIndex():
  url='http://teastop.plus.com/svn/teletext'
  requests.packages.urllib3.util.ssl_.DEFAULT_CIPHERS += 'HIGH:!DH:!aNULL'
  try:
    requests.packages.urllib3.contrib.pyopenssl.DEFAULT_SSL_CIPHER_LIST += 'HIGH:!DH:!aNULL'
  except AttributeError:
    pass
  headers = { 'User-Agent': getUserAgent()}
  page = requests.get(url,headers=headers)
  txt=page.content.decode('utf8',"ignore")
  with open(getFName(0), 'w') as f:
    f.write(txt)

def getPageName(pageNo):
  idx=getFromFile(0)
  pages=[]
  soup = BeautifulSoup(idx, "html.parser")
  for div in soup.findAll('a'):
    pages.append(div.text)
  for page in pages:
    m = re.search('^P'+str(pageNo), page)
    if m:
      return(page)
    m = re.search('^p'+str(pageNo), page)
    if m:
      return(page)
    m = re.search('^BBC'+str(pageNo)+'.*', page)
    if m:
      return(page)
  return('')

def getPage(pageNo):
  if (getPageName!=''):
    url='http://teastop.plus.com/svn/teletext/'+getPageName(pageNo)
    requests.packages.urllib3.util.ssl_.DEFAULT_CIPHERS += 'HIGH:!DH:!aNULL'
    try:
      requests.packages.urllib3.contrib.pyopenssl.DEFAULT_SSL_CIPHER_LIST += 'HIGH:!DH:!aNULL'
    except AttributeError:
      pass
    headers = { 'User-Agent': getUserAgent()}
    page = requests.get(url,headers=headers)
    txt=page.content.decode('utf8',"ignore")
    with open(getFName(pageNo), 'w') as f:
      f.write(txt)
    
def main(pageNo,subPageNo=1):
  try:
    os.path.getmtime(getFName(pageNo))
  except Exception:
    touchFile(pageNo)
  now = localtime() # get struct_time
  ftime=localtime(os.path.getmtime(getFName(pageNo)))
  ftimei=int(strftime("%Y%m%d%H", ftime))
  cur_time=strftime("%Y%m%d%H%m", now)
  upd_time=strftime("%Y%m%d0515", now)
  mod_time=strftime("%Y%m%d%H%m", ftime)
  if ((mod_time < upd_time and cur_time > upd_time) or (getFromFile(pageNo)=='')):
    umsg="---| Downloading page ..."+str(pageNo) + " |---"
    nw.addstr(1,48,umsg,curses.color_pair(WHITE)|curses.A_NORMAL)
    getPage(pageNo)
    pageToText(pageNo,subPageNo)
    #prn(pageToText(pageNo),end='')
    #inpc()
  else:
    umsg="---| From cache: "+str(pageNo) + " |---"
    nw.addstr(1,48,umsg,curses.color_pair(WHITE)|curses.A_NORMAL)
    pageToText(pageNo,subPageNo)
  if (HELP==1):
    umsg01="KEYS:"
    umsg02="(n)ext subpage"
    umsg03="(p)rev subpage"
    umsg04="(#) go to page"
    umsg05="(q)uit"
    nw.addstr(3,48,umsg01,curses.color_pair(YELLOW)|curses.A_BOLD)
    nw.addstr(5,48,umsg02,curses.color_pair(YELLOW)|curses.A_NORMAL)
    nw.addstr(6,48,umsg03,curses.color_pair(YELLOW)|curses.A_NORMAL)
    nw.addstr(7,48,umsg04,curses.color_pair(YELLOW)|curses.A_NORMAL)
    nw.addstr(9,48,umsg05,curses.color_pair(YELLOW)|curses.A_NORMAL)
  #prn('\nEnter page or (q)uit: ')

def init():
  global nw, he, wi, hhe, hwi
  #print("\x1b[0;31m")
  scr = curses.initscr()
  he,wi=scr.getmaxyx()
  hhe=round(he/2)
  hwi=round(wi/2)
  nw = curses.newwin(he, wi)
  curses.start_color()
  curses.init_pair(1, curses.COLOR_WHITE, curses.COLOR_BLACK)
  curses.init_pair(2, curses.COLOR_CYAN, curses.COLOR_BLACK)
  curses.init_pair(3, curses.COLOR_RED, curses.COLOR_BLACK)
  curses.init_pair(4, curses.COLOR_BLACK, curses.COLOR_BLACK)
  curses.init_pair(5, curses.COLOR_GREEN, curses.COLOR_BLACK)
  curses.init_pair(6, curses.COLOR_YELLOW, curses.COLOR_BLACK)
  curses.init_pair(7, curses.COLOR_MAGENTA, curses.COLOR_BLACK)
  curses.init_pair(8, curses.COLOR_BLUE, curses.COLOR_BLACK)
  curses.noecho()
  curses.doupdate()
  #curses.curs_set(0)
  nw.keypad(1)

def inpc():
  nw.refresh()
  a=nw.getch()
  nw.refresh()
  if chr(a)=='q':
    deinit()
    exit(0)
  elif chr(a)=='n':
    return(ord("n"))
  elif chr(a)=='p':
    return(ord("p"))
  return(a)

def deinit():
  global curses, nw
  nw.clear()
  curses.nocbreak()
  curses.echo()
  curses.doupdate()
  curses.endwin()

def getPageNo():
  nw.addstr(23,48,"> ",curses.color_pair(WHITE)|curses.A_BOLD)
  nw.move(23,50)
  pageStr=""
  i=0
  while i < 3:
    pchar=chr(inpc())
    if pchar=='n':
      nw.move(23,53)
      nw.refresh()
      return(-1)
    if pchar=='p':
      nw.move(23,53)
      nw.refresh()
      return(-2)
    if (ord(pchar)>=ord('0') and ord(pchar)<=ord('9')): # or \
       #(ord(pchar)>=ord('a') and ord(pchar)<=ord('f')):
      nw.addstr(23,50+i,pchar,curses.color_pair(WHITE)|curses.A_BOLD)
      nw.refresh()
      pageStr+=pchar
      i+=1
  try:
    pageNo=int(pageStr)
  except Exception as e:
    if DEBUG==1:
      nw.addstr(15,48,"Invalid page Number",curses.color_pair(WHITE)|curses.A_NORMAL)
      nw.refresh()
    pageNo=100
  nw.move(23,53)
  return(pageNo)

def entry():
  init()
  pg=getIndex()
  pageNo=100
  main(str(pageNo))
  subPageNo=1
  #nw.getch()
  while 1:
    try:
      origPage=pageNo
      pageNo=getPageNo()
      if pageNo==-1:
        subPageNo+=1
        pageNo=origPage
      elif pageNo==-2:
        if (subPageNo>1):
          subPageNo-=1
        pageNo=origPage
      else:
        subPageNo=1
      #prn(len(str(pageNo)),'')
      if len(str(pageNo))==3 and pageNo>=100 and pageNo<=999:
        nw.clear()
        main(str(pageNo),str(subPageNo))
      else:
        nw.clear()
        main(str(100),1)
    except Exception as e:
      print("Incorrect Page Number: " + str(e),end='')
      nw.clear()
      main(str(pageNo))
      deinit()
      pass
  deinit()
  exit(0)

try:
  entry()
except Exception as e:
  deinit()
  clog=open("crash.log","w")
  traceback.print_exc(file=sys.stdout)
  traceback.print_exc(file=clog)
  print("ERR: " + str(e))
