/******************************************************************************
 *    _______          _____  _________ __          __
 *    \      \   _____/ ____\/   _____//  |______ _/  |_
 *    /   |   \_/ __ \   __\ \_____  \\   __\__  \\   __\
 *   /    |    \  ___/|  |   /        \|  |  / __ \|  |
 *   \____|__  /\___  >__|  /_______  /|__| (____  /__|
 *           \/     \/              \/           \/    
 *
 *  NefStat 0.05 (24/02/00)
 *  by Serguei Trouchelle (2:464/4077.1)                  http://vidrada.8m.com
 *  Partial Copyright (c) 1998, 1999 Anarchy Software
 *
 *  Utility to gather statistix from Nef's log
 *  
 ******************************************************************************/

/*** Filenames by default */

def_log     = 'd:\fido\common\logs\nef.Log'
def_history = 'history.nef'
def_output  = 'stat.nef'
def_nodes   = 'statno.nef'       /* Use '' to make all statistics in one file */

/*** NefStat log file (nul to suppress) */

statlog     = 'nefstat.log'

/*** Statistics order
  When def_nodes = def_output
    = 0 -- areas first
    = 1 -- nodes first  */

headoverheels = 1

/*** Debug mode
    = 0 -- tiny log
    = 1 -- extended log */

debugmode = 0

/*** OS/REXX delete 
    = 0 -- REXX delete
    = 1 -- OS delete (for some strange filesystems, e.g. network drives and
                      so-called operational systems, e.g. WinNT) */

osdelete = 0

/*** Our address (4D!!!) */

our_aka     = '2:464/4077.0'

/*** Hidden echoareas -- don't appear in statistics */

hidden_echoes.0=1
hidden_echoes.1='SYSTEM'
hidden_echoes.2='.BAD.TICS'

/*** Hidden nodes -- don't appear in statistics */

hidden_nodes.0=1
hidden_nodes.1='2:464/4077.101'

/*** CPS -- setting to calculate approx. time online */

CPS = 1680

/*** hide hours in time online when zero */

Hide0Hours = 0

/******************************************************************************/

/******************************************************************************/
/* No serviceable parts below!!!                                              */
/******************************************************************************/
call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

version = '0.05 (24/02/2000)'

say
say "Nef statistix builder -- NefStat v."version
say "Written by Serguei Trouchelle (2:464/4077.1)"
say "Partial CopyRight (c) 1998,1999 Anarchy Software"
say

parse ARG log history output outputn

if output='' & log\='-default-' then do
  say "Usage:"
  say "  NefStat.cmd <Nef log> <history file> <output file>"
  say "or"
  say "  NefStat.cmd <Nef log> <history file> <areastat file> <nodestat file>"
  say
  say "  For example: "
  say "    NefStat f:\bbs\Nef\Nef.log f:\bbs\Nef\Nef.hst f:\temp\report.txt"
  say
  say "  NOTE: If <Nef log> is '-default-' (without quotes) then"
  say "        default filenames will be used (see in script)."
  exit 1
end

if log='-default-' then do
  log     = def_log
  history = def_history
  output  = def_output
  outputn = def_nodes
end

if outputn='' then outputn=output

/******************************************************************************/

start_time = ''
end_time = ''
analize=0
echo_num=0
node_num=0
loglines=0
workstart=time('s')

parse version rxver
call toLog "Begin, NefStat v"version "on" rxver

if debugmode then do
  call toLog "Log:" log 
  call toLog "Hst:" history
  call toLog "Out:" output
  call toLog "OuN:" outputn
  call toLog "HoH:" headoverheels
  call toLog "Del:" osdelete
end

logsize = stream(log,'c','query size')

rc = stream(history,'c','open read')
if debugmode then
  call toLog "Open hst, rc=" rc

if rc ='READY:' then do
  l=linein(history)
  if l\='$ NefStat history file' then do
    call toLog "Invalid history file" history "- bad signature."
    call FileDelete(history)
    signal ErrHistory
  end
  
  l=linein(history)
  parse var l '$ 'start_time' / 'end_time
  
  l=linein(history)
  parse var l '$ Echoes 'echo_num
  if \datatype(echo_num,'N') then do
    call toLog "Error reading total number of echoes"
    call FileDelete(history)
    start_time=''
    end_time=''
    echo_num=0
    signal ErrHistory
  end
  
  do i=1 to echo_num
    l=linein(history)
    parse var l echo.i.name echo.i.in echo.i.out echo.i.self dd mm tt sta
    echo.i.lasttraf = dd' 'mm' 'tt
  end
  
  l=linein(history)
  parse var l '$ Nodes 'node_num
  if \datatype(node_num,'N') then do
    call toLog "Error reading total number of nodes"
    call FileDelete(history)
    start_time=''
    end_time=''
    echo_num=0
    node_num=0
    signal ErrHistory
  end
  
  do i=1 to node_num
    l=linein(history)
    parse var l node.i.addr node.i.in node.i.out 
  end
  
  l=linein(history)
  if l='$ EOF' then do
    call toLog "History reading ok. "echo_num" echoes and "node_num" nodes."
  end
  
end

errHistory:
rc=stream(history,'c','close')
if debugmode then 
    call toLog "Close hst, rc=" rc

rc=stream(log,'c','open read')
if debugmode then 
    call toLog "Open log, rc=" rc

found=0
if end_time\='' then 
  do while lines(log)
    l = linein(log)
    stamp=substr(l,3,15)
    if stamp=end_time then do
      found=1
      leave
    end
  end

if \found then
  rc=stream(log,'c','seek =1')
  
stamp   = ''
do while lines(log)

  l=linein(log)
  if strip(l)='' then iterate
  loglines=loglines+1
  parse value l with head' NEF  'body
  stamp = substr(head,3)
  action = substr(head, 1, 1)

  if start_time='' then 
    start_time = stamp 
  
  bar=left( copies( '', 60-format(chars(log)/logsize*60,,0) ), 60, '')
  call charout, stamp '['substr(bar,1,28)||right(100-format(chars(log)/logsize*100,,0)'%',4,'0')||substr(bar,33)']'||'0d'x
    
  if action = '+' then do
    if pos('Begin,',body)=1 then do
      analize=1
      iterate
    end
  end
  
  if analize = 0 then iterate
  
  select
    when action = '*' then do
      if pos('ATCH:', body)=2 then do
        parse value body with x'ATCH:' echo_tag filename size
        size = word(body, words(body))
        caddr = our_aka
        z = GetEchoNum(echo_tag)
        echo.z.self = echo.z.self + size
        y = GetNodeNum(caddr)
        node.y.in   = node.y.in + size
        end
      else do
        if pos('RCV:', body)=1 then do
          parse value body with 'RCV:' echo_tag filename size caddr
          size = word(body, words(body) - 1)
          caddr = word(body, words(body))
          z = GetEchoNum(echo_tag)
          echo.z.in   = echo.z.in   + size
          if pos('.',caddr)=0 then
            caddr=caddr||'.0'
          y = GetNodeNum(caddr)
          node.y.in   = node.y.in + size
          end
        else do
          if pos('Sent-to', body)=1 then do
            parse value body with 'Sent-to' caddr x
            echo.z.out  = echo.z.out  + size
            if pos('.',caddr)=0 then
              caddr=caddr||'.0'
            y = GetNodeNum(caddr)
            node.y.out   = node.y.out + size
            end
          else do
            iterate /* Cleaning passthru */
          end /* sent-to */
        end /* rcv */
      end /* .atch */
      echo.z.lasttraf = stamp
    end
    when action='#' then do
      if Pos('Error:',body)=1 then do
        parse value body with 'Error: From' caddr 'file' x
        z = GetEchoNum('_BAD.TICS')
        echo.z.in   = echo.z.in   + 1024
        echo.z.lasttraf = stamp
      end
    end
    otherwise
  end
end

if stamp\='' then
  end_time = stamp

/******************************************************************************/
rc=FileDelete(output)
call toLog "Killing" output ". rc="rc

if stream(output,'c','open write')\='READY:' then do
  call toLog "Error opening" output "for write."
  call toLog "Exiting..."
  exit -1
end

call lineout output, ' * Nef statistix on 'our_aka
call lineout output, ' * From 'start_time' to 'end_time

if output\=outputn then do
  rc=FileDelete(outputn)
  call toLog "Killing" outputn ". rc="rc

  if stream(outputn,'c','open write')\='READY:' then do
    call toLog "Error opening" outputn "for write."
    call toLog "Exiting..."
    exit -1
  end
  call lineout outputn, ' * Nef statistix on 'our_aka
  call lineout outputn, ' * From 'start_time' to 'end_time
end

if headoverheels=1 then do
  call say_stat_nodes
  call say_stat_echoes
end
else do
  call say_stat_echoes
  call say_stat_nodes
end


call lineout output, ''
call lineout output, ' * Generated by NefStat version' version
call lineout output, ' * Written by Serguei Trouchelle (2:464/4077.1)'
call lineout output, ' * Partial CopyRight 1998,1999 Anarchy Software'
rc = stream(output,'c','close')

if output\=outputn then do
  call lineout outputn, ''
  call lineout outputn, ' * Generated by NefStat version' version
  call lineout outputn, ' * Written by Serguei Trouchelle (2:464/4077.1)'
  call lineout outputn, ' * Partial CopyRight 1998,1999 Anarchy Software'
  rc = stream(outputn,'c','close')
end

/* history ********************************************************************/

history_new = history'~'

call FileDelete(history_new)

rc=stream(history_new,'c','open write')
if debugmode then 
    call toLog "Open hst~, rc=" rc

if rc='READY:' then do
  call lineout history_new, '$ NefStat history file'
  call lineout history_new, '$ 'start_time' / 'end_time
  call lineout history_new, '$ Echoes' echo_num
  do i=1 to echo_num
    call lineout history_new, echo.i.name echo.i.in echo.i.out echo.i.self echo.i.lasttraf
  end
  call lineout history_new, '$ Nodes' node_num
  do i=1 to node_num
    call lineout history_new, node.i.addr node.i.in node.i.out
  end
  call lineout history_new, '$ EOF'
end
rc=stream(history_new,'c','close')
if debugmode then 
    call toLog "Close hst~, rc=" rc

rc=CopyFile(history_new, history)
call ToLog "Copying history from" history_new "to" history ". rc="rc
rc=FileDelete(history_new)
call ToLog "Killing" history_new ". rc="rc

workend=time('s')
if workend<workstart then runtime = 86400-workstart+workend
                     else runtime = workend-workstart

call toLog "End. Runtime="runtime" seconds. Processed "loglines" log lines."
call toLog "<EMPTY>"

exit 0

/******************************************************************************/
say_stat_nodes: procedure expose node_num node. hidden_nodes. outputn cps hide0hours

do j=1 to node_num
  parse value node.j.addr with z':'n'/'f'.'p
  node.j.addr = right(z,5)||right(n,5)||right(f,5)||right(p,5)
  qs_stem.j = node.j.addr' 'left(node.j.in,12)' 'left(node.j.out,12)
end
call qqsort 1, node_num

call lineout outputn, ''
call lineout outputn, center('-= Nodes statistix =-', 78)
call lineout outputn, ''
call lineout outputn, ' Address               kBytes In    kBytes Out   Time online if CPS='CPS
call lineout outputn, '--------------------  ------------ ------------ ---------------------------'

do i=1 to node_num
  parse value space(qs_stem.i) with n_z n_n n_f n_p node.i.in node.i.out
  node.i.addr = n_z':'n_n'/'n_f'.'n_p
  found=0
  do k=1 to hidden_nodes.0
    if hidden_nodes.k=node.i.addr then
      found=1
  end
  if found then iterate

  timeonline=(node.i.in+node.i.out)%60%CPS
  min=timeonline//60
  if min<10 then min='0'min
  if \Hide0Hours | (timeonline%60>0) then
     min=timeonline%60' hrs 'min
  call lineout outputn, ' 'left(node.i.addr,20)' 'right(node.i.in%1024,12)' 'right(node.i.out%1024,12)' 'right(min' min', 26)
end
call lineout outputn, '--------------------  ------------ ------------ ---------------------------'
return

/******************************************************************************/
say_stat_echoes: procedure expose output echo_num echo. hidden_echoes.

call lineout output, ''
call lineout output, center("-= Echoes statistix =-", 78)
call lineout output, ''

call lineout output, ' Echotag                kB In       kB Out      kB Loc      Last traffic at Sta'
call lineout output, '---------------------- ----------- ----------- -----------  --------------- ---'

mon.1=31; mon.2=29; mon.3=31;  mon.4=30;  mon.5=31;  mon.6=30;
mon.7=31; mon.8=31; mon.9=30; mon.10=31; mon.11=31; mon.12=31;

do i=1 to echo_num
  /* check echoarea status */
  parse value echo.i.lasttraf with lt_d lt_mt lt_h':'lt_m':'lt_s
  select
    when lt_mt='Jan' then lt_m=01
    when lt_mt='Feb' then lt_m=02
    when lt_mt='Mar' then lt_m=03
    when lt_mt='Apr' then lt_m=04
    when lt_mt='May' then lt_m=05
    when lt_mt='Jun' then lt_m=06
    when lt_mt='Jul' then lt_m=07
    when lt_mt='Aug' then lt_m=08
    when lt_mt='Sep' then lt_m=09
    when lt_mt='Oct' then lt_m=10
    when lt_mt='Nov' then lt_m=11
    when lt_mt='Dec' then lt_m=12
    otherwise lt_m=0
  end
  parse value Date('e') with cur_d'/'cur_m'/'
  lt_=0;
  do j=1 to lt_m-1
    lt_=lt_+mon.j
  end
  lt_=lt_+lt_d
  cur_=0;
  do j=1 to cur_m-1
    cur_=cur_+mon.j
  end
  cur_=cur_+cur_d
  if cur_<lt_ then 
    diff=cur_+366-lt_
  else
    diff=cur_-lt_    
  select
    when diff<7  then sta=''
    when diff<14 then sta='*'
    when diff<30 then sta='+'
    when diff<60 then sta='!'
    otherwise sta='X'
  end
/**/
  qs_stem.i = left(echo.i.name,32)' 'left(echo.i.in,12)' 'left(echo.i.out,12)' 'left(echo.i.self,12)' 'echo.i.lasttraf'  'sta
end
call qqsort 1, echo_num

do i=1 to echo_num
  parse value space(qs_stem.i) with echo.i.name echo.i.in echo.i.out echo.i.self dd mm tt sta
  echo.i.lasttraf = dd mm tt  
  found=0
  do k=1 to hidden_echoes.0
    if hidden_echoes.k=echo.i.name then
      found=1
  end
  if found then iterate
  
  call lineout output, ' 'left(echo.i.name,21)' 'right(echo.i.in%1024,11)' 'right(echo.i.out%1024,11)' 'right(echo.i.self%1024,11)'  'echo.i.lasttraf'  'sta
end

call lineout output, '---------------------- ----------- ----------- -----------  --------------- ---'

return

/******************************************************************************/
GetEchoNum: procedure expose echo_num echo.

  echoname = arg(1)
  
  do i=1 to echo_num
    if echo.i.name = echoname then
      return i
  end
  
  echo_num=echo_num+1
  echo.echo_num.name     = echoname  
  echo.echo_num.in       = 0
  echo.echo_num.out      = 0
  echo.echo_num.self     = 0
  echo.echo_num.lasttraf = ''
  
return echo_num

/******************************************************************************/
GetNodeNum: procedure expose node_num node.

  nodeaddr = arg(1)
  
  do i=1 to node_num
    if node.i.addr = nodeaddr then
      return i
  end
  
  node_num=node_num+1
  
  node.node_num.addr = nodeaddr
  node.node_num.in   = 0
  node.node_num.out  = 0
  
return node_num
  
/******************************************************************************/
CopyFile: procedure Expose debugmode statlog osdelete

  blocksize = 1000000 /* size of block */

  src=arg(1)
  dst=arg(2)
  append=arg(3)
  if append='' then 
    append=0
  
  if append=0 then do
    rc=FileDelete(dst)
    if debugmode then 
      call toLog "Kill dst, `"dst"`, rc=" rc

    if rc\=0 & rc\=1 & rc\=2 then
      return "ERROR: DELETE RC="rc
  end    

  if stream(src,'c','open read')\='READY:' then
    return "ERROR: CANNOT OPEN SOURCE FILE"
  if stream(dst,'c','open write')\='READY:' then
    return "ERROR: CANNOT OPEN TARGET FILE"
    
  filesize = stream(src,'c','query size')
  
  do while filesize\=0
    if(filesize>blocksize) then block = blocksize
                           else block = filesize
                           
    data = charin(src,,block)
    if length(data)\=block then
      return "ERROR: CANNOT READ DATA"
      
    call charout dst, data
      
    filesize = filesize-block
  end
  
  rc=stream(src,'c','close')
  rc=stream(dst,'c','close')
    
return "OK:"

/******************************************************************************/
toLog: procedure expose statlog

  ls = arg(1)

  if stream(statlog,'c','open write')\='READY:' then do
    say '07'x "Can't write to logfile" statlog
    return
  end
  
  if ls='<EMPTY>' then call lineout statlog, ''
                  else call lineout statlog, DATE() TIME()' NFST 'ls
  
  rc=stream(statlog,'c','close')
  
return

/******************************************************************************/
FileDelete: procedure expose debugmode osdelete statlog
  df = arg(1)
  rc=stream(df,'c','close')
  if debugmode then 
    call toLog 'Close' df ', rc='rc
  if osdelete then do
    '@del' df '>nul 2>nul'
    if debugmode then
      call toLog 'OS delete' df
    rc=SysFileDelete(df)
    if debugmode then 
      call toLog 'Retry delete' df ', rc='rc
  end
  else do
    rc=SysFileDelete(df)
    if debugmode then
      call toLog 'Delete' df ', rc='rc
    if rc\=0 & rc\=2 then do
      rc=SysFileDelete(df)
      if debugmode then 
        call toLog 'Retry delete' df ', rc='rc
    end
  end
return rc

/* ------------------------------------------------------------------ */
/* function: quick sort routine                                       */
/*                                                                    */
/* call:     QuickSort first_element, last_element                    */
/*                                                                    */
/* returns:  nothing                                                  */
/*                                                                    */
/* notes:    You must save the elements to sort in the stem "a."      */
/*           a.0 must contain the number of elements in the stem.     */
/*                                                                    */
/*                                                                    */
qqsort: procedure expose qs_stem.
 
  arg lf, re
 
  if re -lf < 9 then
    do lf = lf to re -1
 
      m = lf
 
      do j = lf +1 to re
        if qs_stem.j << qs_stem.m then                                   /* v2.80 */
          m = j
      end /* j = lf +1 to re */
 
      t = qs_stem.m; qs_stem.m = qs_stem.lf; qs_stem.lf = t
 
    end /* lf = lf to re -1 */
    else
    do
      i = lf
      j = re
      k = (lf + re)%2
      t = qs_stem.k
 
      do until i > j
 
        do while qs_stem.i << t                                    /* v2.80 */
          i = i + 1
        end /* while qs_stem.i << t */
 
        do while qs_stem.j >> t                                    /* v2.80 */
          j = j - 1
        end /* while qs_stem.j >> t */
 
        if i <= j then
        do
          xchg = qs_stem.i
          qs_stem.i = qs_stem.j
          qs_stem.j = xchg
          i = i + 1
          j = j - 1
        end /* if i <= j then */
 
      end /* until i > j */
 
      call qqsort lf, j
      call qqsort i, re
    end /* else */
 
return

/* EOF */