;
; ==========================================================================
;            Patch script for timEd/386 v1.10  (DOS-386 Version)
;                      Version 1.00 - 05. May 1998
;
;     Created by Wilfried Brinkmann, Fido 2:2448/6001, e-mail tsc@cww.de
; ==========================================================================
;
; NOTE: This patch script will modify timedp.exe and add a lot of new
;       routines to handle the necessary modifications.
;       There is no additional program required to run the patched
;       tim386.exe!
;
;       If you wish to understand this patch, you will want to see what
;       the added service routines do. The source code is added as comment.
;
SIZE 366498                ; filesize tim386.exe
;
COPY UNPATCH\TIM386.EXE    ; make a backup copy in <TimedPath>\unpatch
;
; --------------------------------------------------------------------------
; Fix handling of a UNIX time_t timestamp from 2038 on. Previously, it
; was treated as a signed long (which led to an overflow on 18/01/2038).
; Now we treat it as an unsigned long.
;
; The fix itself is a little bit tricky ;-)
; I must insert a call in a 3 byte wide area (cwd, idiv ecx), but a normal
; call has 5 bytes. So I have made a special service at the routine entry.
; The first normal call returns a virtual call address for the division
; service in esi and a virtual address in edi for the final exit service.
; At the same time, the first (unsigned) divison is executed.
;
VER 38D61 53+              ; push     ebx
          51+              ; push     ecx
          52+              ; push     edx
          8B18+            ; mov      ebx,[eax]
          89D8+            ; mov      eax,ebx
          B93C000000+      ; mov      ecx,0000003C
          99+              ; cwd
          F7F9             ; idiv     ecx
          ;
CHA $     60+              ; pushad                ; push all regs
          8B18+            ; mov      ebx,[eax]
          89D8+            ; mov      eax,ebx
          B93C000000+      ; mov      ecx,0000003C
          ;
          ; now call the first service to get the virtual address
          ; (esi - unsigned division, edi - exit service)
          ;
          E800ADFFFF       ; call     -00005300 (00033A70)
;
VER 38D78 99+              ; cwd
          F7F9             ; idiv     ecx
CHA $     90+              ; nop                   ; call unsigned division
          FFD6             ; call     esi          ; (addr in esi)
;
VER 38D7D 99+              ; cwd
          F7F9             ; idiv     ecx
CHA $     90+              ; nop
          FFD6             ; call     esi
;
VER 38D88 99+              ; cwd
          F7F9             ; idiv     ecx
CHA $     90+              ; nop
          FFD6             ; call     esi
;
VER 38D92 99+              ; cwd
          F7F9             ; idiv     ecx
CHA $     90+              ; nop
          FFD6             ; call     esi
;
VER 38D9D 99+              ; cwd
          F7F9             ; idiv     ecx
CHA $     90+              ; nop
          FFD6             ; call     esi
;
VER 38DAA 99+              ; cwd
          F7F9             ; idiv     ecx
CHA $     90+              ; nop
          FFD6             ; call     esi
;
VER 38DBA 99+              ; cwd
          F7F9             ; idiv     ecx
CHA $     90+              ; nop
          FFD6             ; call     esi
;
VER 38E8E 5A+              ; pop      edx
          59+              ; pop      ecx
          5B               ; pop      ebx
          ;
CHA $     FFD7+            ; call     edi          ; call final exit service
          61               ; popad                 ; and restore all regs
;
; My special handling routine ...
; At the first entry this servive will returns the virtual call address
; for the unsigned division in esi and the final call address in edi.
; After the virtual address is calculated, the first divison is made.
;
VER 33A70 00000000000000000000000000000000+
          0000000000000000000000
          ;
          ; local call to get the entry address in esi
          ;
CHA $     E80D000000+      ; call     +0000000D (@33A82)
          ;
          89F7+            ; mov      edi,esi      ; addr from stack to esi
          83C608+          ; add      esi,08       ; offs to idiv service
          83C711+          ; add      edi,11       ; offs to exit service
          ;
          ; unsigned division service (call esi entry point)
          ;
          31D2+            ; xor      edx,edx      ; clear edx to make
          F7F9+            ; idiv     ecx          ; unsigned divison
          C3+              ; ret
          ;
@33A82:   8B3424+          ; mov      esi,[esp]    ; entry addr to esi
          C3+              ; ret
          ;
          ; final exit servive (call edi entry point)
          ;
          89442420+        ; mov      [esp+20],eax ; store changed eax at
          C3               ; ret                   ; old eax pos on stack.

;
; ---------------------------------------------------------------------------
; Fix date display of the message info screen ('110 instead of '10 and so on)
;
VER 2EACB FF31+            ; push     dword ptr [ecx]
          FF7104+          ; push     dword ptr [ecx+04]
          FF7108+          ; push     dword ptr [ecx+08]
          8B4110+          ; mov      eax,[ecx+10]
          FF7114           ; push     dword ptr [ecx+14]
          ;
CHA $     E8B7E80000+      ; call     +0000E8B7 (0003D387)
          8B4110+          ; mov      eax,[ecx+10]
          90+              ; nop
          90+              ; nop
          90+              ; nop
          90+              ; nop
          90+              ; nop
          90               ; nop
;
; --------------------------------------------------------------------------
; Fix three digit year in the FTSC date field in the squish message base
; ("100" instead of "00"). Previously, a three digit number was pushed
; to the stack from 2000 on.
;
VER 3CC71 FF30+            ; push     dword ptr [eax]
          FF7004+          ; push     dword ptr [eax+04]
          8B5010+          ; mov      edx,[eax+10]
          FF7008+          ; push     dword ptr [eax+08]
          C1E202+          ; shl      edx,02
          FF7014           ; push     dword ptr [eax+14]
          ;
CHA $     91+              ; xchg     ecx,eax
          E810070000+      ; call     +00000710 (0003D387)
          91+              ; xchg     ecx,eax
          8B5010+          ; mov      edx,[eax+10]
          C1E202+          ; shl      edx,02
          90+              ; nop
          90+              ; nop
          90+              ; nop
          90               ; nop
;
; --------------------------------------------------------------------------
; Fix three digit year in the FTSC date field in *.MSG files
; ("100" instead of "00"). Previously, a three digit number was pushed
; to the stack from 2000 on.
;
VER 414A1 FF30+            ; push     dword ptr [eax]
          FF7004+          ; push     dword ptr [eax+04]
          8B5010+          ; mov      edx,[eax+10]
          FF7008+          ; push     dword ptr [eax+08]
          C1E202+          ; shl      edx,02
          FF7014           ; push     dword ptr [eax+14]
          ;
CHA $     91+              ; xchg     ecx,eax
          E8E0BEFFFF+      ; call     -00004120 (0003D387)
          91+              ; xchg     ecx,eax
          8B5010+          ; mov      edx,[eax+10]
          C1E202+          ; shl      edx,02
          90+              ; nop
          90+              ; nop
          90+              ; nop
          90               ; nop
;
; The added routine for the three above patches. (info scrn, squish, *.msg)
; This routine is called when writing a FTSC date stamp into a *.squish or
; *.msg base and writing the info screen. It prevents the 2 digit date field
; from spilling (without the modulo 100 operation, "100" would be written
; there in the year 2000 instead of 00).
;
VER 3D387 0000000000000000000000000000000000000000000+
          00000000000000000000000000000
          ;
CHA $     FF7104+          ; push     dword ptr [ecx+04]
          FF7108+          ; push     dword ptr [ecx+08]
          50+              ; push     eax          ; room for two values
          50+              ; push     eax
          51+              ; push     ecx
          52+              ; push     edx
          8B4114+          ; mov      eax,[ecx+14] ; get year
          31C9+            ; xor      ecx,ecx
          B164+            ; mov      cl,64
          99+              ; cwd
          F7F9+            ; idiv     ecx          ; modulo 100
          8954240C+        ; mov      [esp+0C],edx ; save year on stack
          5A+              ; pop      edx
          59+              ; pop      ecx
          8B01+            ; mov      eax,[ecx]    ; get value to push
          87442410+        ; xchg     [esp+10],eax ; swap ret addr/eax
          870424+          ; xchg     [esp],eax    ; swap eax/ret addr
          C3               ; ret

;
; ---------------------------------------------------------------------------
; Fix interpretation of a two digit year number when reading Squish and
; *.MSG style message bsaes. Previously, it was always interpreted as 19xx,
; Now, we use the following logic: 19xx if xx>=80, 20xx if xx<80
;
VER 48B8B 83E850+          ; sub      eax,50
          30E4             ; xor      ah,ah
          ;
CHA $     E81B48FFFF       ; call     -0000B7E5 (0003D3AB)
;
; Convert a two digit year number that is stored in eax into a DOS time
; compliant year number (which gives the number of years that have been passed
; since 1980). The method we use is save until 2080. Prevent wrong binary
; timestamps (TimEd derives them from the two digit FTSC date) in Squish and
; MSG areas.
;
VER 3D3AB 0000000000000000000000
          ;
CHA $     83E850+          ; sub      eax,50       ; sub 80
          7703+            ; jnbe     +03 (@3D2B3) ; no overflow, done
          83C064+          ; add      eax,64       ; else add 100
@3D3B3:   30E4+            ; xor      ah,ah
          C3               ; ret

;
; --------------------------------------------------------------------------
; Fix incorrect interpretation of a hudson time stamp which led to
; totally wrong display of a hudson message date after 2000.
;
VER 3E903 0FB745F4+        ; movzx    eax,[ebp-0C]
          8945E0           ; mov      [ebp-20],eax

CHA $     E8677EFFFF+      ; call     -00008199 (0003676F)
          90+              ; nop
          90               ; nop
;
; This routine is called when reading a message from the Hudson HMB.
; The date that is in [ebp-0c] is a two digit year number, but we want
; to have a "tm.tm-year" style year number in eax. Therefore, we check
; if the value is smaller than 80, and if so, we assume that it is in
; the 21st century and therefore add 100 to it. This makes HMB save
; until 31-12-2079.
;
VER 3676F 00000000000000000000000000000000
          ;
CHA $     0FB745F4+        ; movzx    eax,[ebp-0C]
          83F850+          ; cmp      eax,50
          7703+            ; jnbe     +03 (0003322C)
          83C064+          ; add      eax,64
          8945E0+          ; mov      [ebp-20],eax
          C3               ; ret

;
; --------------------------------------------------------------------------
; Fix three digit year in the textual date field in the Hudson HMB
; ("100" instead of "00"). Previously, a three digit number was pushed
; to the stack from 2000 on.
;
VER 3EDF8 FF7014+          ; push     dword ptr [eax+14]
          89C1             ; mov      ecx,eax
          ;
CHA $     E88279FFFF       ; call     -0000867E (0003677F)
;
; The routine that has been added for the patch from above (hudson fix).
; This routine is called when writing a FTSC date stamp into a hudson base.
; It prevents the 2 digit date field from spilling (without the modulo 100
; operation, "100" would be written there in the year 2000 instead of 00).
;
VER 3677F 00000000000000000000000000000+
          0000000000000000000
          ;
CHA $     50+              ; push     eax
          8B4014+          ; mov      eax,[eax+14] ; get year
          52+              ; push     edx
          31C9+            ; xor      ecx,ecx
          B164+            ; mov      cl,64
          99+              ; cwd
          F7F9+            ; idiv     ecx          ; modulo 100
          92+              ; xchg     edx,eax
          5A+              ; pop      edx
          87442404+        ; xchg     [esp+04],eax ; swap year/ret addr
          870424+          ; xchg     [esp],eax    ; swap ret addr/eax
          89C1+            ; mov      ecx,eax
          C3               ; ret

;
; --------------------------------------------------------------------------
; Fix incorrect dates in replies generated with a template containing
; the %year token.  Previously, a three digit year number was pushed to
; the stack.
;
VER 254B0 8B45E8+          ; mov      eax,[ebp-18]
          FF7014           ; push     dword ptr [eax+14]
          ;
CHA $     E892120100+      ; call     +00011292 (00036747)
          90               ; nop
;
; This routine is called from the patch from above when writing the day number
; for a %year variable in a message template. We have patched the executable
; to use %4.4i instead of 19%2.2i as sprintf format string, so we have to
; push a four digit year number now.
;
VER 36747 0000000000000000000000000000000000000000+
          0000000000000000000000000000000000000000
          ;
CHA $     8B45E8+          ; mov      eax,[ebp-18]
          50+              ; push     eax
          8B4014+          ; mov      eax,[eax+14] ; get year
          51+              ; push     ecx
          52+              ; push     edx
          31C9+            ; xor      ecx,ecx
          B164+            ; mov      cl,64        ; modulo 100
          99+              ; cwd
          F7F9+            ; idiv     ecx
          81C26C070000+    ; add      edx,0000076C ; add 1900
          09C0+            ; or       eax,eax      ; was year > 99 ?
          7403+            ; jz       +03 (@36764) ; no, done
          83C264+          ; add      edx,64       ; else add 100
@36764:   92+              ; xchg     edx,eax
          5A+              ; pop      edx
          59+              ; pop      ecx
          87442404+        ; xchg     [esp+04],eax ; swap year/ret addr
          870424+          ; xchg     [esp],eax    ; swap ret addr/eax
          C3               ; ret
          ;
VER 5200E 313925322E326900 ; db "19%2.2i",0
          ;
CHA $     25342E3469000000 ; db "%4.4i",0,0,0

;
; --------------------------------------------------------------------------
; Patch the Tearline and other places to announce version "1.10.y2k"
; intead of "1.10".
;
VER 551DE 00000000         ; db 0,0,0,0
          ;
CHA $     2E79326B         ; db ".y2k"
;
; Done!
;

