/*************************************************************************
  Wipe        Move or Cut a block and fill with spaces

  Author:     SemWare

  Date:       Jun  1, 1994 - Initial version

  Overview:

  This macro file provides two macros:  MoveWipe, which is a variation
  of the MoveBlock command; and CutWipe, which is a variation of the
  Cut (to the System ClipBoard) command.  When you execute Wipe from
  the Potpourri PickList, MoveWipe is assigned to <AltShift M>, and
  CutWipe is assigned to <Shift Grey*>.  These macros behave similarly
  to the commands on which they are based, except that the area of
  text from which the block is moved or cut, is filled with spaces.
  Also, with MoveWipe, if a column block is moved, the editor overlays
  existing text with the contents of the block, rather than inserting
  the contents of the block into its new location.

  Keys:
        <AltShift M>        MoveWipe()
        <AltShift Grey->    CutWipe()

  Usage notes:

  If you wish to make this macro a permanent part of your
  configuration, then simply add "Wipe" to the AutoLoad list on the
  Macro menu.

  Copyright 1992-1995 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/

// Cut a block, back-filling with spaces
public integer proc CutWipe()
    integer copied

    PushBlock()
    copied = Copy()
    PopBlock()
    if copied
        FillBlock(' ')
        UnmarkBlock()
    endif
    return (copied)
end

// Move a block, back-filling with spaces
public proc MoveWipe()
    integer curr_id, save_clip_id, save_state, tmp

    curr_id = GetBufferId()
    tmp = CreateTempBuffer()
    GotoBufferId(curr_id)
    if tmp
        save_clip_id = Set(ClipBoardId, tmp)

        if CutWipe()
            save_state = Set(UnMarkAfterPaste, OFF)
            Paste(_OVERWRITE_)
            Set(UnMarkAfterPaste, save_state)
        endif

        Set(ClipBoardId, save_clip_id)
        AbandonFile(tmp)
    endif
end

<AltShift M>        MoveWipe()
<AltShift Grey->    CutWipe()
