proc swap_chars()
    string c[1]

    c = GetText(CurrPos(), 1)
    DelChar()
    Left()
    InsertText(c, _INSERT_)
end

public proc TransposeChars()
    if CurrLineLen() > 1
        if CurrPos() == 1
            Right()
            swap_chars()
            Left()
        elseif CurrPos() == CurrLineLen() + 1
            Left()
            swap_chars()
            Right()
        elseif CurrPos() > 1 and CurrPos() <= CurrLineLen()
            swap_chars()
        endif
    endif
end

public proc TransposeWords()
    string s1[255], s2[255]
    integer start_line

    start_line = CurrLine()

    PushPosition()
    if not WordLeft() or start_line <> CurrLine()
        PopPosition()
        return ()
    endif
    // get the word that was to the left
    s1 = GetWord()
    if not WordRight() or start_line <> CurrLine()
        PopPosition()
        return ()
    endif
    // get the word at or to the right
    s2 = GetWord()
    PopPosition()

    PushPosition()
    WordLeft()
    DelChar(Length(s1))
    InsertText(s2, _INSERT_)
    PopPosition()

    WordLeft()
    WordRight()
    DelChar(Length(s2))
    InsertText(s1, _INSERT_)
    WordLeft()
end

public integer proc TransposeLinesAbove()
    if CurrLine() > 1
        DelLine()
        Up()
        UnDelete()
        return (TRUE)
    endif
    return (FALSE)
end

public integer proc TransposeLinesBelow()
    if Down()
        DelLine()
        Up()
        UnDelete()
        return (TRUE)
    endif
    return (FALSE)
end

public proc RotateLineDown()
    if TransposeLinesBelow()
        Down()
    endif
end

public proc RotateLineUp()
    if TransposeLinesAbove()
        Up()
    endif
end
