/*------------------------------------------------------------------------
This SAL source code is based on:

Tentris by Oscar Toledo G. (nanochess)
Source: https://nanochess.itch.io/tentris
A Tetris-like game in 10 lines of GW-BASIC

Original author comments:

 I was on Twitter and read the tweet by @electron_greg about writing a Space Invaders clone
 for a 10 line BASIC jam, I was wondering whether it was possible.

 Followed the link

  https://itch.io/jam/ascii-basic-10liner

 and I saw very intesting games (the Missile Command one is my favorite)

 Anyway I thought that a Tetris game could fit. The first day was simply getting the pieces
 to be shown on the screen, the second day was trying to get a workable keyboard interface
 (and many doubts about the feasibility of the project!!!), but finally the third day
 (Jun/23/2021) I managed to fit the line removal code, and then proceeded to work five
 hours straight to optimize it. The last two hours were basically fitting an insidious
 single extra letter.

 I decided for GW-Basic because my first PC computer was a Televideo PC with 512 KB of RAM
 and I remember typing programs from Compute! magazines in the afternoons (also if my
 parents were distracted I would put Double Dragon or Rogue :P).

 For better randomness you can add at this sentence at the start of the game: RANDOMIZE
 TIMER

 You can only use uppercase letters from the keyboard to move (A and D) and rotate (W).

 The game will exit with an error once the board is filled.

 Enjoy it!

end original author comments

 ------------------------------------------------------------------------*/
string ps[64]="BJ@@QJI@JB@@IJQ@IIII@D@@JJ@@JJ@@QQJ@AC@@JII@CQ@@IIJ@CA@@JQQ@QC@@"
string bs[1], cs[1], junk[1]
integer c,d,e,h,i,k,q,r,s,u,w,x,y,z
constant T = 10 // change the fall down speed of the block (e.g. T=100 is very slow)
integer total_blocks

integer proc inkey()
    integer k

    if not KeyPressed() return (0) endif
    k = GetKey()
    if k in <cursorleft>, <a>
        return (<a>)
    elseif k in <cursorright>, <d>
        return (<d>)
    elseif k in <cursorup>, <cursordown>, <w>
        return (<w>)
    elseif k == <escape>
        return (<escape>)
    endif
    return (0)
end

proc eight()
    for c=1 to 4
        d = asc(substr(ps, z + r mod i + c)) - 64
        w=d/8
        while d
            d=d-1 & 7
            getstrxy(x+w+d, y+c, junk, 1)
            h = h + iif((asc(junk[1]) > 32), -1, 0)
            vgotoxy(x+w+d, y + c)
            putoemstr(cs)  //was writeline
        endwhile
    endfor
end

proc main()
        PopWinOpen(10, 1, min(Query(ScreenCols), 40), min(Query(ScreenRows), 25), 0, "Tetris", 15)
        total_blocks = 0 // Reset the total blocks counter when the game starts
        clrscr()
        bs = chr(219)
        for y = 1 to 19
            putoemstrxy(1, y, format(" ":14, bs, " ":14, bs))
        endfor
        putoemstrxy(1, y, format(" ":14, bs:16:bs))
        gotoxy(1, 1)
two:    k = inkey()
        if k == <escape>
            PopWinClose()
            return ()
        endif
        x = 19
        c = x
        r = c
        while r
            d = 13
            for e = 16 to 28
                getstrxy(e, r, junk, 1)
                d = d + iif((junk[1] == chr(219)), -1, 0)
            endfor
            if d
                for e = 16 to 28
                    vgotoxy(e, c)
                    getstrxy(e, r, junk, 1)
                    putoemstr(junk)
                endfor
                c = c - 1
            endif
            r = r - 1
        endwhile
        y = 0
        z = random(0, 6) * 8
        z = z - iif((z > 39), -1, 0) * 8
        i = 8 - iif((z > 31), -1, 0) * 8
        if d == 13
            total_blocks = total_blocks + 1
            putoemstrxy(1, 22, format("Total Blocks: ", total_blocks))
        endif
        while 1
            cs = ""
            h = 0
            eight()
            cs = bs
            if h
                r = q
                x = u
                if k == 0
                    y = y - 1
                    eight()
                    goto two    // xxx
                endif
            endif

six:        eight()
            q = r
            u = x

            k = inkey()
            if k == <escape>
                PopWinClose()
                return ()
            endif

            if k == 0
                if gettime() < s
                    goto six    // xxx
                else
                    s = gettime() + 10
                endif
            endif
            cs = " "
            eight()
            x = x + iif((k == <a>), -1, 0) - iif((k==<d>), -1, 0)
            y = y - iif((k == 0), -1, 0)
            r = r - iif((k == <w>), -1, 0)*4
        endwhile
end

<alt 1> main()
