/*************************************************************************
  ShowKey     Displays information about keys available in TSE

  Author:     SemWare

  Date:       Oct  9, 1992 - Initial version (Richard Blackburn)
              May  9, 1994 - Enhancements and modifications

  Overview:

  This macro displays information about the assignable keys on the
  keyboard. When you execute this macro, an information chart is
  displayed on the screen.  You then press a key or key-combination
  (using the <Ctrl>, <Shift>, and <Alt> keys).  If the key is one that
  the editor recognizes as an assignable key, a line is displayed in
  the chart that identifies the following information for that key:

     screen display character (if applicable)

     ASCII code

     scan code

     hexadecimal representation

     decimal representation

     key name (that is, the "name" to use for that key in an editor key
      assignment)

  If the key is not assignable, nothing is displayed when you press
  the key.

  Keys:       (none)

  Usage notes:

  This macro does not have any key assignments.  To use, simply
  select it from the Potpourri menu.

  Copyright 1992-1995 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/

/************************************************************************
  Author:  SemWare

  Date:    October  1992 - Initial version by Richard Blackburn
           December 1992 - Mods by Sammy Mitchell
           December 1992 - Mods by Steve Watkins
           March    1994 - Mods by Steve Watkins
                           - added additional Alt keys
                           - added Ctrl Alt, Ctrl Shift, Alt Shift, and
                             Shift Shift keys
           May      1994 - Mods by Steve Watkins
                           - added keypad entries

  Description:

  Show TSE's key code and value of keys pressed.

  Usage notes:

  To use, add these macros to your TSE.S file, and key assignments to
  your TSE.KEY file, and re-bind the editor using the -b switch of sc.

  Be sure to rename the main routine if used in TSE.S.  A good name might
  be ShowKey

  Example key assignments might be:

  <f11>         ShowKey()

  Alternatively, add the key assignments to this file, and load the
  macro (as an external macro) as needed via the LoadMacro command
  (<ctrl f10><L> or 'menu->macro->load')
 ************************************************************************/

constant
    X1 = 2, Y1 = 2, WIDTH = 70, HEIGHT = 20

constant KEYWIDTH = 32

proc main()
    integer key, n
    string  key_name[KEYWIDTH]

    Set(Break,OFF)

    PushPosition()

    if PopWinOpen(X1, Y1, X1 + WIDTH, Y1 + HEIGHT, 2, "ShowKey... Press <Esc> to Exit", 15)
        Set(Attr, 7)
        ClrScr()

        WriteLine("Char   ASCII   Scan     Hex     Dec   Key")
        WriteLine("       Code    Code                   Name")
        Window(X1 + 1, Y1 + 3, X1 + WIDTH - 1, Y1 + HEIGHT - 1)
        VHomeCursor()

        repeat
            key = GetKey()
            key_name = str(key)
            key_name = KeyName(key)
            for n = Length(key_name) downto 1
                if Asc(key_name[n]) < 32
                    key_name = "<"+Str(key)+">"
                    break
                endif
            endfor
            Writeline( chr(key):3, key mod 256:8, key / 256:8,str(key,16):8, key:8,
                        '   <', key_name, '>')
            if key == 0
                break
            endif

        until key == <Escape>
        Delay(9)
        PopWinClose()
    endif

    PopPosition()
end

