/*************************************************************************
  Para        Macros to go to the end and to the next and previous paragraph

  Author:     SemWare

  Date:       Apr 23, 1993 - Initial version (Richard Blackburn)
              Sep 21, 1993 - Fixes and enhancements

  Overview:

  These macros will position the cursor on the next or previous
  paragraph, or at the end of the current paragraph.  They assume that
  there is at least one blank line between paragraphs.

  Keys:
            <Ctrl CursorDown>       NextPara()
            <Ctrl CursorUp>         PrevPara()
            <Ctrl CenterCursor>     EndPara()

  Usage notes:

  If you wish to make this macro a permanent part of your
  configuration, then simply add "Para" to the AutoLoad list on the
  Macro menu.

  Copyright 1992-1995 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/

// Go to the start of the next Paragraph.
proc NextPara()
    // if in a paragraph, scan till the end of it
    while PosFirstNonWhite()
        if not Down()
            goto common_exit
        endif
    endwhile

    // skip any blank lines
    while PosFirstNonWhite() == 0
        if not Down()
            goto common_exit
        endif
    endwhile

    common_exit:
    GotoPos(PosFirstNonWhite())
end

// If in a para (and not on the first line) go to the beginning of the para.
// Otherwise, go to the beginning of the previous para.
proc PrevPara()
    if not Up()
        goto common_exit
    endif

    while PosFirstNonWhite() == 0
        if not Up()
            goto common_exit
        endif
    endwhile

    while PosFirstNonWhite()
        if not Up()
            goto common_exit
        endif
    endwhile

    Down()

    common_exit:
    GotoPos(PosFirstNonWhite())
end

// Go to the end of the current (or next, if not in a) para
proc EndPara()
    // skip any blank lines
    while PosFirstNonWhite() == 0
        if not Down()
            goto common_exit
        endif
    endwhile

    // scan till the end of paragraph
    while PosFirstNonWhite()
        if not Down()
            goto common_exit
        endif
    endwhile

    Up()

    common_exit:
    EndLine()
end

<Ctrl CursorDown>       NextPara()
<Ctrl CursorUp>         PrevPara()
<Ctrl CenterCursor>     EndPara()
