/**************************************************************************
  match.s

  log:
  Mar  26, 1993 SEM initial version
  Jan   2, 1997 SEM add string-length-between-quotes feature
  Apr  29, 1997 SEM re-work so it can be called by VisualMatch
  Nov  20, 1997 SEM in count code, if matching " not found, scan left for match
  Oct  16, 1998 SEM don't scroll horizontally unless we have to
  May      2003 SEM allow match function to work on any two
        tokens, e.g.:
        match('(', ')', forward, stay-in-window)
        match('begin', 'end', forward, false)
        match('end', 'begin', backward, false)

  1) If the cursor is on (){}[]<>, position to matching character.
  2) If the cursor is on '", count the number of characters in-between.
  3) Otherwise, go forward looking for a match character as in 1) above.
 **************************************************************************/

string proc fixup(string s)
    integer i
    string s2[255] = ""

    for i = 1 to Length(s)
        if Pos(s[i], "`~!@#$%^&*()-_=+\|[]{};:,./<>?")
            s2 = s2 + '\' + s[i]
        else
            s2 = s2 + s[i]
        endif
    endfor
    return (s2)
end

integer proc Match(string ch, string mc, integer onward, integer stay_in_window)
    integer level, start_line, start_row, start_xoffset
    string find_str[80], find_options[10]

    start_xoffset = CurrXoffset()
    start_line = CurrLine()
    start_row = CurrRow()

    level = 1                       // Start out at level 1

    find_options = "x" + iif(onward, "+", "b")
    // what about things like 'begin', 'end'? use word option if
    // either token begins and ends in an alpha character
    if isAlpha(ch[1]) and isAlpha(ch[Length(ch)]) or
       isAlpha(mc[1]) and isAlpha(mc[Length(mc)])
        find_options = find_options + 'w'
    endif

    PushBlock()
    if stay_in_window
        find_options = find_options + "l"
        PushPosition()
        BegWindow()
        MarkLine()
        EndWindow()
        MarkLine()
        PopPosition()
    endif

    if Length(ch) == 1 and Length(mc) == 1
        find_str = "[\" + ch + "\" + mc + "]"
    else
        find_str = "{" + fixup(ch) + "}|{" + fixup(mc) + "}"
    endif

    while lFind(find_str, find_options)
        case CurrChar()             // And check out the current character
            when Asc(ch)
                level = level + 1
            when Asc(mc)
                level = level - 1
                if level == 0
                    if CurrXoffset() <> start_xoffset
                        GotoXoffset(start_xoffset)       // Fix up possible horizontal scrolling
                    endif
                    ScrollToRow(CurrLine() - start_line + start_row)
                    PopBlock()
                    return (TRUE)           // And return success
                endif
        endcase
    endwhile

    PopBlock()
    return (FALSE)
end

proc CountString()
    integer c1

    PushPosition()

    c1 = CurrPos()
    if lFind(Chr(CurrChar()), "+c") or lFind(Chr(CurrChar()), "bc")
        Message("String is ", Abs(CurrPos() - c1) - 1, " characters long.")
    else
        Message("End of string not found...")
    endif

    PopPosition()
end

/****************************************************************************
  The match command.  Use this macro to match (){}{}<> chars.

  If first arg is "vmatch", just match, and return true/false accordingly.
 ***************************************************************************/
proc main()
    integer p, start_line, start_row
    string ch[1], mc[1], match_chars[32] = "(){}[]<>"   // pairs of chars to match


    p = Pos(chr(CurrChar()), match_chars)
    if p
        ch = match_chars[p]             // Get the character we're matching
        mc = match_chars[iif(p & 1, p + 1, p - 1)]  // And its reverse
    endif

    if Lower(Query(MacroCmdLine)) == "vmatch"
        Set(MacroCmdLine, iif(p and Match(ch, mc, p & 1, TRUE), "true", "false"))
        return ()
    endif

    start_line = CurrLine()
    start_row = CurrRow()
    // If we're not already on a match char, go forward to find one
    if p == 0
        if CurrChar() in Asc('"'), Asc("'")
            CountString()
        elseif lFind("[(){}[\]<>]", "x")
            ScrollToRow(CurrLine() - start_line + start_row)
        endif
    else
        PushPosition()
        if Match(ch, mc, p & 1, FALSE)
            KillPosition()
        else
            PopPosition()
            Warn("Match not found")
        endif
    endif
end

proc match_pair(integer onwards)
    string s[64], s1[32], s2[32]

    s = ""
    if not Ask("Enter begin/end string. Quote as needed:", s)
        return ()
    endif

    s1 = GetFileToken(s, 1)
    s2 = GetFileToken(s, 2)
    if s1 == "" or s2 == ""
        Warn("Missing token")
        return ()
    endif

    PushLocation()
    if not match(s1, s2, onwards, FALSE)
        PopLocation()
        Warn("No match found")
        return ()
    endif
    KillLocation()
end

public proc match_pair_forward()
    match_pair(true)
end

public proc match_pair_backward()
    match_pair(false)
end

#if 0
// to match /* */ multiline comments:
<f3>  if CurrChar() in Asc('/')
        Match('/*', '*/', TRUE, FALSE)
      elseif CurrChar() in Asc('*')
        Match('*/', '/*', FALSE, FALSE)
      endif
// to match "begin" "end":

<f3>  if CurrChar() in Asc('b')
        Match('begin', 'end', TRUE, FALSE)
      elseif CurrChar() in Asc('e')
        Match('end', 'begin', FALSE, FALSE)
      endif
#endif
