/*************************************************************************
  LongstLn    Locates the longest line in the current file or block

  Author:     Ray Asbury

  Date:       Apr 23, 1993 - Initial version

  Overview:

  This macro locates the longest line in the current file.  When you
  execute this macro, you are positioned on the longest line, and its
  length is displayed on the StatusLine.  If a block is marked in the
  current file, then the search is limited to the block.

  Keys:       (none)

  Usage notes:

  This macro does not have any key assignments.  To use, simply
  select it from the Potpourri menu.

*************************************************************************/

// ASSUMPTIONS: If a block is marked in the current file, then the length
//              of the longest line in the block will be returned.  Otherwise
//              the length of the longest line in the file will be returned.
//
//
// PARAMETERS:  go_to_it    - if TRUE, longest line will become new cursor line
//                               if there are multiple lines, the first one will
//                               become the new cursor line.
//                            if FALSE, cursor line will not change
//
// RETURNS:     Length of the longest line.
//
// GLOBAL VARS: none
//
// LOCAL VARS:  marking     - saves the state of block marking
//              max_len     - work var to hold the max_len
//              last_line   - line number of last line to be tested
//              line_no     - line number of the longest line
//
integer proc LongestLine(integer go_to_it)
    integer Marking = Set(Marking, Off),     // turn off marking
            max_len = 0,
            last_line,
            line_no

    PushPosition()
    if isBlockInCurrFile()
        GotoBlockBegin()
        last_line = Query(BlockEndLine)
    else
        BegFile()
        last_line = NumLines()
    endif

    max_len = CurrLineLen()
    line_no = CurrLine()

    while Down() and (CurrLine() <= last_line)
        if CurrLineLen() > max_len
            max_len = CurrLineLen()
            line_no = CurrLine()
        endif
    endwhile

    if go_to_it
        KillPosition()          // kill pushed position since
        GotoLine(line_no)       // we're going to the new line
    else
        PopPosition()           // return to where we started and
        Set(Marking, marking)   // restore the state of block marking
    endif
    return (max_len)
end LongestLine


//
// Macro to determine, and go to, the longest line in a file or marked block.
//
// ASSUMPTIONS: If a block is marked in the current file, then only the lines
//              in the block will be tested.
//
//              This is an interactive version of the LongestLine() macro.
//
//              The LongestLine() proc defined above MUST be available.
//
// PARAMETERS:  none
//
// RETURNS:     nothing
//
// GLOBAL VARS: none
//
// LOCAL VARS:  max_len     - holds length of longest line
//

proc Main()
    integer max_len

    Message('Locating longest line...')

    max_len = LongestLine(TRUE)         // get longest line len, and go to it

    Message('Current line is ',max_len,' characters long.')
end

