/*
  Macro         KeepBlinking
  Author        Carlo Hogeveen
  Website       eCarlo.nl/tse
  Compatibility TSE Pro v4.0 upwards
  Version       v1.1.1   25 Oct 2024

  This extension keeps the cursor blinking in TSE.

  That the cursor stops blinking after a few seconds is caused by Windows.
  Now many years ago this was introduced in a past version of Windows.
  Applications needed to adapt for it, and not all did.

  On 19 Aug 2024 a test of the number of blinks before blinking stops:
    Notepad   5
    TSE       5   (Without the KeepBlinking extension.)
    Word     30
    WordPad   5

  Thanks to Stein Oiestad who came up with a solution!
  Any errors in its implementation are mine.


  INSTALLATION

  Copy this source file to TSE's "mac" folder.

  Compile the file as a TSE macro, for instance by opening it in TSE
  and applying the Macro -> Compile menu.

  Macro -> Execute KeepBlinking to toggle it ON/OFF.
  (This adds/removes KeepBlinking to/from the Macro AutoLoad List.)


  HISTORY

  v1       14 Jun 2019
    Initial release.

  v1.0.1   18 Aug 2024
    Fixed: KeepBlinking did not work when comparing files.

  v1.1     19 Aug 2024
    Made KeepBlinking Potpourri-friendly.

  v1.1.1   25 Oct 2024
    Added extra error-checks to make the extension more fool-proof.

*/


// Glocal variables
integer c = 0


proc idle()
  if c >= 18
    if Query(Cursor)
      Set(Cursor, OFF)
      Set(Cursor, ON)
    endif
    c = 0
  else
    c = c + 1
  endif
end idle


proc WhenLoaded()
  Hook(_IDLE_        , idle)
  Hook(_NONEDIT_IDLE_, idle)
end WhenLoaded


proc Main()
  string macro_name [MAXSTRINGLEN] = SplitPath(CurrMacroFilename(), _NAME_)

  if isAutoLoaded()
    if DelAutoLoadMacro(macro_name)
      Warn('KeepBlinking is now OFF for this TSE session and future ones.')
    else
      Alarm()
      Warn('Could not delete macro "', macro_name, '" from file "tseload.dat".')
    endif
    PurgeMacro(macro_name)
  else
    if AddAutoLoadMacro(macro_name)
      Warn('KeepBlinking is now ON for this TSE session and future ones.')
    else
      Alarm()
      Warn('Could not add macro "', macro_name, '" to file "tseload.dat".')
    endif
  endif
end Main

