/*************************************************************************
  Justify     Justifies a paragraph based on the right margin

  Author:     SemWare

  Date:       Apr 23, 1993 - Initial version (Richard Blackburn)

  Overview:

  This macro work just like the WrapPara() command, but also justifies
  each line to the RightMargin.

  Keys:       (none)

  Usage notes:

  This macro does not have any key assignments.  To use, simply select
  it from the Potpourri menu.

  Copyright 1992-1995 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/

/***********************************************************************
   Procedure to justify a paragraph.

   The method used to justify the paragraph is:

        Save our position.
        If the lm == 0 set it to the position of first non white char
            on the next line.
        Repeat
            Calculate the number of spaces needed to justify the line.
            If > 0 and < 1/3 the line length
                Check to see if the line number is even or odd.
                If even start at the end of the line, else at beginning.
                Work through the line putting a space between words.
        Until
            You can't go down.
            You encounter a blank line.
            The lm changes and you have ParaEndStyle set to 1
***********************************************************************/

//
// PARAMETERS:  none
//
// RETURNS:     nothing
//
// GLOBAL VARS: none
//
// LOCAL VARS:  wordset - Save the Current WordSet
//              rm      - Right margin
//              lm      - Left Margin
//              linelen - length of the current line
//              endtype - paragraph end type
//              spaces  - number of spaces needed to justify the line
//
proc Main()
    string  wordset[32] = Set(WordSet, ChrSet(Chr(0) + '-' +Chr(8) + Chr(10) + '-' + Chr(31) + '!-' + Chr(255)))
    integer rm = Query(RightMargin),
            lm = Query(LeftMargin),
            linelen = 0,
            endtype = Query(ParaEndStyle),
            spaces = 0

    PushPosition()
    if lm == 0
        if Down()
            lm = PosFirstNonWhite()
            Up()
        endif
    endif
    repeat
        linelen = CurrLineLen()
        spaces = rm - linelen
        if spaces > 0 AND spaces < (CurrLineLen() / 3)
            if CurrLine() mod 2
                GotoPos(PosFirstNonWhite())
            else
                EndLine()
            endif
            while spaces
                if CurrLine() mod 2
                    WordRight()
                    if CurrChar() == _AT_EOL_
                        GotoPos(PosFirstNonWhite())
                        WordRight()
                    endif
                else
                    WordLeft()
                    if CurrPos() == PosFirstNonWhite()
                        EndLine()
                        WordLeft()
                    endif
                endif
                InsertText(' ', _INSERT_)
                spaces = spaces - 1
            endwhile
        endif
    until NOT Down()
        OR CurrLineLen() == 0
        OR (endtype AND lm <> PosFirstNonWhite())
    PopPosition()
    Set(WordSet, wordset)
end
