/**************************************************************************
  Feb 19 2002 SEM: Make sure the width is wide enough to display a 4 digit
                date.
  May 14 2016 SEM: show correct filesize for large files.

  Dec 05 2017 SEM: handle filenames wider than the window
 **************************************************************************/

// Assumes input string has no leading zeroes...
// Returns string with formatting commas inserted
string proc InsertCommas(string s)
    string   ret[26] = s
    integer  idx = (length(s) mod 3) + 1
    if length(s) > 3
        while idx < length(ret)
            if idx > 1
                ret = InsStr(",",ret,idx)
                idx = idx + 4
            else
                idx = idx + 3
            endif
        endwhile
    endif
    return( ret)
end

/****************************************************************************
  Display information (disk date, time, size, attributes) about the current
  file.
 ****************************************************************************/
proc main()
    string attributes[40], access[40], lockmsg[40], fn[_MAX_PATH_]
    integer color_attr, file_attributes, cursor, x1, y1, width, height, h, flags

    if not FindThisFile(CurrFilename(), -1)
        Warn("File not found")
        return ()
    endif

    attributes = ""
    file_attributes = FFAttribute()
    if file_attributes & _READONLY_
        attributes = attributes + "READONLY "
    endif
    if file_attributes & _HIDDEN_
        attributes = attributes + "HIDDEN "
    endif
    if file_attributes & _SYSTEM_
        attributes = attributes + "SYSTEM "
    endif
    if file_attributes & _ARCHIVE_
        attributes = attributes + "ARCHIVE "
    endif

    flags = Query(BufferFlags)
    lockmsg = ""

    h = fOpen(Currfilename(), _OPEN_READONLY_ | _OPEN_DENY_NONE_)
    if h == -1
        access = "Read/Write access denied"
    else
        fClose(h)
        h = fOpen(Currfilename(), _OPEN_READWRITE_ | _OPEN_DENY_NONE_)
        if h == -1
            access = "Write access denied"
            if flags & _READONLY_LOCKING_
                lockmsg = "(File is locked by TSE [READONLY])"
            elseif flags & _HANDLE_LOCKING_
                lockmsg =  "(File is locked by TSE [HANDLE])"
            endif
        else
            fClose(h)
            access = "Read/Write access allowed"
        endif
    endif

    fn = CurrFilename()
    if length(fn) >= Query(ScreenCols) - 2
        fn = SqueezePath(fn, Query(ScreenCols) - 2)
    endif

    width = Max(32,
                Max( Length(fn) + 3,
                Max( Length(access) + 5 + 3,
                Max( Length(lockmsg) + 5 + 3, Length(attributes) + 20 + 3))))

    height = 13 + 4 + (BinaryMode() <> 0)

    x1 = (Query(ScreenCols) / 2) - (width / 2)
    y1 = (Query(ScreenRows) / 2) - (height / 2)
    if PopWinOpen(x1, y1, x1 + width - 1, y1 + height - 1, 4, "File information", Query(MenuBorderAttr))

        color_attr = Set(Attr, Query(MenuTextAttr))
        cursor = Set(Cursor, off)

        ClrScr()
        WriteLine("")
        WriteLine(fn)
        WriteLine("")
        WriteLine(" M e m o r y")
        WriteLine("     Lines:":-20, InsertCommas(Str(NumLines())))
        if BinaryMode()
            WriteLine("RecordSize:":-20, BinaryMode())
        endif
        WriteLine("")
        WriteLine(" D i s k")
        WriteLine("     Size:", InsertCommas(FFSizeStr()):20)
        WriteLine("     Date:":-20, FFDateStr())
        WriteLine("     Time:":-20, FFTimeStr())
        WriteLine("     Attributes:":-20, attributes)
        WriteLine("")

        WriteLine("     ", access)
        WriteLine("     ", lockmsg)

        WindowFooter("Press a key to continue")
        GetKey()
        PopWinClose()

        Set(Attr, color_attr)
        Set(Cursor, cursor)

    endif
end

